/*
 * Decompiled with CFR 0.152.
 */
package ome.client;

import ome.api.IUpdate;
import ome.client.ConflictResolver;
import ome.client.Storage;
import ome.client.ThrowsConflictResolver;
import ome.model.IMutable;
import ome.model.IObject;
import ome.system.ServiceFactory;

public class Session {
    public static final int INVALID = -1;
    public static final int TRANSIENT = 0;
    public static final int PERSISTENT = 1;
    public static final int DELETED = 2;
    protected boolean closed = false;
    protected long lastModification = System.currentTimeMillis();
    protected ServiceFactory serviceFactory;
    protected Storage storage;
    protected ConflictResolver conflictResolver;
    private static final String NULL_VERSION = "Invalid entity. Is it missing a version?";

    private Session() {
    }

    public Session(ServiceFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("ServiceFactory may not be null");
        }
        this.serviceFactory = factory;
        this.storage = new Storage();
        this.conflictResolver = new ThrowsConflictResolver();
    }

    public IObject find(Class klass, Long id) {
        this.errorIfClosed();
        if (klass == null || id == null) {
            throw new IllegalArgumentException("Class and id may not be null.");
        }
        if (this.storage.isDeleted(klass, id)) {
            return null;
        }
        return this.storage.findPersistent(klass, id);
    }

    public long lastModification() {
        this.errorIfClosed();
        return this.lastModification;
    }

    public void register(IObject iObject) {
        this.errorIfClosed();
        if (iObject == null) {
            return;
        }
        switch (this.getState(iObject)) {
            case 0: {
                this.storage.storeTransient(iObject);
                break;
            }
            case 1: {
                iObject = this.checkForConflicts(iObject);
                this.storage.storePersistent(iObject);
                break;
            }
            case -1: {
                throw new IllegalArgumentException(NULL_VERSION);
            }
        }
        this.lastModification = System.currentTimeMillis();
    }

    public void markDirty(IObject iObject) {
        this.errorIfClosed();
        if (iObject == null) {
            return;
        }
        switch (this.getState(iObject)) {
            case 1: {
                this.storage.storeDirty(iObject);
                break;
            }
            default: {
                throw new IllegalArgumentException(NULL_VERSION);
            }
        }
    }

    public void delete(IObject iObject) {
        this.errorIfClosed();
        if (iObject == null) {
            return;
        }
        switch (this.getState(iObject)) {
            case 1: {
                this.storage.storeDeleted(iObject);
                break;
            }
            default: {
                throw new IllegalArgumentException(NULL_VERSION);
            }
        }
        this.lastModification = System.currentTimeMillis();
    }

    public void flush() {
        int i;
        this.errorIfClosed();
        IUpdate iUpdate = this.serviceFactory.getUpdateService();
        IObject[] insert = this.storage.copyCreatedEntities();
        IObject[] update = this.storage.copyDirtyEntities();
        IObject[] delete = this.storage.copyDeletedEntities();
        IObject[] inserted = iUpdate.saveAndReturnArray(insert);
        if (insert.length != inserted.length) {
            throw new RuntimeException("Differing sizes returned from server.");
        }
        for (int i2 = 0; i2 < inserted.length; ++i2) {
            this.storage.replaceTransient(insert[i2], inserted[i2]);
        }
        IObject[] updated = iUpdate.saveAndReturnArray(update);
        if (update.length != updated.length) {
            throw new RuntimeException("Differing sizes returned from server.");
        }
        for (i = 0; i < updated.length; ++i) {
            this.storage.storePersistent(updated[i]);
        }
        for (i = 0; i < delete.length; ++i) {
            iUpdate.deleteObject(delete[i]);
        }
    }

    public IObject checkOut(IObject iObject) {
        this.errorIfClosed();
        if (iObject == null) {
            return null;
        }
        Class<?> k = iObject.getClass();
        if (this.getState(iObject) == 0) {
            return this.storage.hasReplacement(iObject) ? this.storage.getReplacement(iObject) : iObject;
        }
        Long id = iObject.getId();
        if (this.storage.isDeleted(k, id)) {
            return null;
        }
        if (this.storage.isPersistent(k, id)) {
            return this.storage.findPersistent(k, id);
        }
        return iObject;
    }

    public void close() {
        this.storage = null;
        this.closed = true;
    }

    protected IObject checkForConflicts(IObject possibleReplacement) {
        Class<?> k = possibleReplacement.getClass();
        Long id = possibleReplacement.getId();
        IObject registeredVersion = this.storage.findPersistent(k, id);
        if (this.storage.isDirty(k, id)) {
            return this.conflictResolver.resolveConflict(registeredVersion, possibleReplacement);
        }
        if (this.storage.isDeleted(k, id)) {
            return this.conflictResolver.resolveConflict(registeredVersion, possibleReplacement);
        }
        return possibleReplacement;
    }

    protected int getState(IObject iObject) {
        IMutable iMutable;
        if (iObject == null) {
            throw new IllegalArgumentException("Entities to test may not be null");
        }
        if (iObject.getId() == null) {
            return 0;
        }
        if (iObject instanceof IMutable && (iMutable = (IMutable)iObject).getVersion() == null) {
            return -1;
        }
        return 1;
    }

    protected void errorIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Session " + this.toString() + " is closed.");
        }
    }
}

