/*
 * Decompiled with CFR 0.152.
 */
package ome.client;

import java.security.Principal;
import javax.naming.NamingException;
import org.jboss.security.SecurityAssociation;
import org.springframework.aop.TargetSource;
import org.springframework.jndi.JndiObjectTargetSource;
import org.springframework.util.Assert;

public class JBossTargetSource
implements TargetSource {
    protected JndiObjectTargetSource target;
    protected Principal principal;
    protected String credentials;

    public JBossTargetSource(JndiObjectTargetSource target, Principal securityPrincipal, String securityCredentials) {
        Assert.notNull((Object)target, (String)"Target is required");
        Assert.notNull((Object)securityPrincipal, (String)"Principal is required.");
        Assert.notNull((Object)securityCredentials, (String)"Credentials required.");
        this.target = target;
        this.principal = securityPrincipal;
        this.credentials = securityCredentials;
    }

    public Class getTargetClass() {
        return this.target.getTargetClass();
    }

    public Object getTarget() throws NamingException {
        Object retVal = this.target.getTarget();
        SecurityAssociation.setPrincipal((Principal)this.principal);
        SecurityAssociation.setCredential((Object)this.credentials);
        return retVal;
    }

    public void releaseTarget(Object target) {
        this.target.releaseTarget(target);
    }

    public boolean isStatic() {
        return this.target.isStatic();
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JBossTargetSource)) {
            return false;
        }
        JBossTargetSource otherTargetSource = (JBossTargetSource)other;
        return this.target.equals(otherTargetSource.target);
    }

    public String toString() {
        return "JBossTargetSource for target: " + this.target;
    }

    static {
        SecurityAssociation.setServer();
    }
}

