/*
 * Decompiled with CFR 0.152.
 */
package ome.client;

import javax.naming.NamingException;
import ome.client.JBossTargetSource;
import ome.conditions.InternalException;
import ome.system.Principal;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.jndi.JndiObjectTargetSource;

public class ConfigurableJndiObjectFactoryBean
extends JndiObjectFactoryBean {
    protected boolean stateful = false;
    protected Principal principal;
    protected String credentials;

    public void setStateful(boolean isStatless) {
        this.stateful = isStatless;
    }

    public void setPrincipal(Principal securityPrincipal) {
        this.principal = securityPrincipal;
    }

    public void setCredentials(String securityCredentials) {
        this.credentials = securityCredentials;
    }

    public boolean isSingleton() {
        return this.stateful ? false : super.isSingleton();
    }

    public Object getObject() {
        if (this.stateful) {
            try {
                this.afterPropertiesSet();
            }
            catch (NamingException ne) {
                InternalException ie = new InternalException(ne.getMessage());
                ie.setStackTrace(ne.getStackTrace());
                throw ie;
            }
        }
        Object object = super.getObject();
        Advised advised = (Advised)object;
        JBossTargetSource redirector = new JBossTargetSource((JndiObjectTargetSource)advised.getTargetSource(), (java.security.Principal)this.principal, this.credentials);
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class klass : advised.getProxiedInterfaces()) {
            proxyFactory.addInterface(klass);
        }
        proxyFactory.setTargetSource((TargetSource)redirector);
        return proxyFactory.getProxy();
    }
}

