/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.deployment.AspectDeployerMBean;
import org.jboss.aop.deployment.JBossScopedClassLoaderHelper;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;

public class AspectDeployer
extends SubDeployerSupport
implements SubDeployer,
AspectDeployerMBean {
    public AspectDeployer() {
        this.initializeMainDeployer();
    }

    protected void initializeMainDeployer() {
        this.setSuffixes(new String[]{".aop", "-aop.xml"});
        this.setRelativeOrder(100);
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith(".aop") || urlStr.endsWith(".aop/") || urlStr.endsWith("-aop.xml");
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            if (di.watch == null) {
                File file;
                di.watch = di.url.getProtocol().equals("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/jboss-aop.xml")) : di.url;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failed to parse AOP document: ", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        super.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            URL docURL = this.getDocUrl(di);
            ClassLoader scl = this.getScopedClassLoader(di, docURL);
            if (scl != null) {
                this.log.info((Object)("AOP deployment is scoped using classloader " + scl));
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)di.ucl);
            if (!di.isXML) {
                Iterator it = ArchiveBrowser.getBrowser((URL)di.localUrl, (ArchiveBrowser.Filter)new ClassFileFilter());
                AspectAnnotationLoader loader = new AspectAnnotationLoader(AspectManager.instance());
                loader.deployInputStreamIterator(it);
            }
            AspectXmlLoader.deployXML((URL)docURL, (ClassLoader)scl);
            Notification msg = new Notification("AOP Deploy", this, this.getNextNotificationSequenceNumber());
            this.sendNotification(msg);
            this.log.info((Object)("Deployed AOP: " + di.url));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DeploymentException((Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DeploymentInfo di) {
        if (di.state != DeploymentState.STARTED) {
            this.log.debug((Object)("Ignoring request to stop '" + di.url + "', current state: " + di.state));
            return;
        }
        this.log.debug((Object)("undeploying document " + di.url));
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)di.ucl);
            if (!di.isXML) {
                Iterator it = ArchiveBrowser.getBrowser((URL)di.localUrl, (ArchiveBrowser.Filter)new ClassFileFilter());
                AspectAnnotationLoader loader = new AspectAnnotationLoader(AspectManager.instance());
                loader.undeployInputStreamIterator(it);
            }
            URL docURL = this.getDocUrl(di);
            AspectXmlLoader.undeployXML((URL)docURL);
            AspectManager.instance().unregisterClassLoader((ClassLoader)di.ucl);
            Notification msg = new Notification("AOP Undeploy", this, this.getNextNotificationSequenceNumber());
            this.sendNotification(msg);
        }
        catch (Exception ex) {
            this.log.error((Object)"failed to stop", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void destroy(DeploymentInfo di) {
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    private URL getDocUrl(DeploymentInfo di) throws DeploymentException {
        URL docURL = di.localUrl;
        if (!di.isXML) {
            docURL = di.localCl.findResource("META-INF/jboss-aop.xml");
        }
        if (docURL == null) {
            throw new DeploymentException("Failed to find META-INF/jboss-aop.xml");
        }
        return docURL;
    }

    private ClassLoader getScopedClassLoader(DeploymentInfo di, URL docUrl) {
        if (JBossScopedClassLoaderHelper.isScopedClassLoader((ClassLoader)di.ucl)) {
            return di.ucl;
        }
        return null;
    }
}

