/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jndi;

import java.security.Principal;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.jndi.SecurityAssociationActions;
import org.jnp.interfaces.NamingContextFactory;

public class JndiLoginInitialContextFactory
extends NamingContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        Object credentials = env.get("java.naming.security.credentials");
        Object principal = env.get("java.naming.security.principal");
        Principal securityPrincipal = null;
        if (principal instanceof Principal) {
            securityPrincipal = (Principal)principal;
        } else {
            String username = principal.toString();
            securityPrincipal = new SimplePrincipal(username);
        }
        SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials);
        Context iniCtx = super.getInitialContext(env);
        return iniCtx;
    }
}

