/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingDataInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.PendingAction;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class VirtualServerSocket
extends ServerSocket
implements Serializable {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$VirtualServerSocket == null ? (class$org$jboss$remoting$transport$multiplex$VirtualServerSocket = VirtualServerSocket.class$("org.jboss.remoting.transport.multiplex.VirtualServerSocket")) : class$org$jboss$remoting$transport$multiplex$VirtualServerSocket);
    private List acceptingThreads = Collections.synchronizedList(new LinkedList());
    private MultiplexingManager manager;
    private MultiplexingDataInputStream is;
    private MultiplexingDataInputStream cis;
    private Protocol protocol;
    private Socket actualSocket;
    private int timeout;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Socket dummySocket;
    private SocketFactory socketFactory;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$VirtualServerSocket;

    public VirtualServerSocket() throws IOException {
    }

    public VirtualServerSocket(int port) throws IOException {
        this.bind(new InetSocketAddress(port));
        log.debug("created VirtualServerSocket: " + this.toString());
    }

    public VirtualServerSocket(int port, int backlog) throws IOException {
        this(port);
        log.warn("backlog parameter is ignored");
        log.debug("created VirtualServerSocket: " + this.toString());
    }

    public VirtualServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this.bind(new InetSocketAddress(bindAddr, port));
        log.warn("backlog parameter is ignored");
        log.debug("created VirtualServerSocket: " + this.toString());
    }

    public VirtualServerSocket(VirtualSocket socket) throws IOException {
        this.actualSocket = socket.getActualSocket();
        this.manager = socket.getManager();
        this.manager.incrementReferences();
        this.bind(new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort()));
        log.debug("created VirtualServerSocket: " + this.toString());
    }

    public VirtualServerSocket(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout) throws IOException {
        this.connect(remoteAddress, localAddress, timeout);
        log.debug("created VirtualServerSocket: " + this.toString());
    }

    public synchronized Socket accept() throws IOException {
        VirtualSocket virtualSocket;
        log.debug("entering accept()");
        long start = System.currentTimeMillis();
        int timeout = this.getSoTimeout();
        int timeLeft = 0;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkAccept(this.actualSocket.getInetAddress().getHostAddress(), this.actualSocket.getPort());
        }
        Thread currentThread = Thread.currentThread();
        this.acceptingThreads.add(currentThread);
        VirtualSocket virtualSocket2 = null;
        try {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                log.error("timed out");
                throw new SocketTimeoutException("Accept timed out");
            }
            log.debug("timeLeft: " + timeLeft);
            SocketId clientPort = this.protocol.acceptConnect(this.is, timeLeft);
            log.debug("clientPort:  " + clientPort.getPort());
            virtualSocket2 = new VirtualSocket(this.manager, clientPort);
            this.manager.incrementReferences();
            int localPort = virtualSocket2.getLocalVirtualPort();
            this.protocol.answerConnect(new DataOutputStream(virtualSocket2.getOutputStream()), localPort);
            MultiplexingInputStream mis = (MultiplexingInputStream)virtualSocket2.getInputStream();
            MultiplexingDataInputStream mdis = new MultiplexingDataInputStream(mis);
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                log.error("timed out");
                throw new SocketTimeoutException("Accept timed out");
            }
            log.debug("timeLeft: " + timeLeft);
            this.protocol.getConnectVerification(mdis, timeLeft);
            virtualSocket = virtualSocket2;
            Object var14_13 = null;
            this.acceptingThreads.remove(currentThread);
        }
        catch (IOException e) {
            try {
                if (virtualSocket2 != null) {
                    virtualSocket2.close();
                }
                if (this.isClosed()) {
                    throw new SocketException("Socket closed");
                }
                if (e instanceof SocketTimeoutException) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                this.acceptingThreads.remove(currentThread);
                if (this.isClosed()) {
                    if (virtualSocket2 != null) {
                        virtualSocket2.close();
                    }
                    throw new SocketException("Socket closed");
                }
                throw throwable;
            }
        }
        if (this.isClosed()) {
            if (virtualSocket2 != null) {
                virtualSocket2.close();
            }
            throw new SocketException("Socket closed");
        }
        return virtualSocket;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 1);
    }

    public void bind(SocketAddress socketAddress, int backlog) throws IOException {
        if (backlog != 1) {
            log.warn("backlog != 1: ignored");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkListen(inetSocketAddress.getPort());
        }
        if (this.manager == null) {
            this.manager = MultiplexingManager.getaManagerByLocalAddress(inetSocketAddress, this.socketFactory);
            this.actualSocket = this.manager.getSocket();
        }
        try {
            this.bound = true;
            this.is = this.manager.registerServerSocket(this);
            this.cis = new MultiplexingDataInputStream(this.manager.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null));
            this.is.setTimeout(this.timeout);
            this.cis.setTimeout(this.timeout);
            if (this.manager.isConnected()) {
                this.protocol = this.manager.getProtocol();
                this.protocol.registerRemoteServerSocket(this.getSoTimeout());
                this.connected = true;
            }
        }
        catch (IOException e) {
            this.bound = false;
            if (this.manager.isServerSocketRegistered()) {
                this.manager.unRegisterServerSocket(this);
            }
            throw e;
        }
        log.debug(this.toString());
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        if (!this.acceptingThreads.isEmpty()) {
            LinkedList threads = new LinkedList(this.acceptingThreads);
            Iterator it = threads.iterator();
            while (it.hasNext()) {
                Thread t = (Thread)it.next();
                t.interrupt();
                log.debug("interrupting accepting thread: " + t.getName());
            }
            if (!this.acceptingThreads.isEmpty()) {
                this.manager.addToPendingActions(new PendingClose(this));
            }
        }
        if (this.protocol != null) {
            this.protocol.unregisterRemoteServerSocket();
        }
        if (this.manager != null) {
            this.manager.unRegisterServerSocket(this);
        }
    }

    public InetAddress getInetAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getInetAddress();
    }

    public int getLocalPort() {
        if (this.actualSocket == null) {
            return -1;
        }
        return this.actualSocket.getLocalPort();
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.actualSocket == null) {
            if (this.dummySocket == null) {
                this.dummySocket = new Socket();
            }
            return this.dummySocket.getReceiveBufferSize();
        }
        return this.actualSocket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.actualSocket == null) {
            return true;
        }
        return this.actualSocket.getReuseAddress();
    }

    public int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setReceiveBufferSize(size);
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setReuseAddress(on);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = timeout;
        if (this.is != null) {
            this.is.setTimeout(timeout);
        }
        if (this.cis != null) {
            this.cis.setTimeout(timeout);
        }
    }

    public String toString() {
        StringBuffer answer = new StringBuffer().append("VirtualServerSocket[");
        if (!this.isBound()) {
            return answer.append("unbound]").toString();
        }
        answer.append("local address=" + this.getInetAddress() + ":" + this.getLocalPort());
        if (!this.isConnected()) {
            return answer.append("]").toString();
        }
        return answer.append(", remote address=" + this.actualSocket.getInetAddress() + ":" + this.actualSocket.getPort() + "]").toString();
    }

    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, null, this.timeout);
    }

    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        this.connect(remoteAddress, localAddress, this.timeout);
    }

    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, int timeout) throws IOException {
        long start = System.currentTimeMillis();
        int timeLeft = 0;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress remoteInetSocketAddress = (InetSocketAddress)remoteAddress;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (remoteInetSocketAddress.isUnresolved()) {
                security.checkConnect(remoteInetSocketAddress.getHostName(), remoteInetSocketAddress.getPort());
            } else {
                security.checkConnect(remoteInetSocketAddress.getAddress().getHostAddress(), remoteInetSocketAddress.getPort());
            }
        }
        if (this.isConnected()) {
            if (this.getRemoteAddress().equals(remoteInetSocketAddress.getAddress())) {
                return;
            }
            throw new SocketException("already connected");
        }
        if (this.manager == null) {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("connect timed out");
            }
            if (localAddress == null) {
                this.manager = MultiplexingManager.getaManagerByRemoteAddress(remoteInetSocketAddress, timeLeft, this.socketFactory);
            } else {
                InetSocketAddress localInetSocketAddress = (InetSocketAddress)localAddress;
                this.manager = MultiplexingManager.getaManagerByAddressPair(remoteInetSocketAddress, localInetSocketAddress, timeLeft, this.socketFactory);
            }
        }
        this.actualSocket = this.manager.getSocket();
        try {
            try {
                if (!this.isBound()) {
                    log.debug("calling registerServerSocket()");
                    this.is = this.manager.registerServerSocket(this);
                    this.cis = new MultiplexingDataInputStream(this.manager.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null));
                    this.is.setTimeout(this.timeout);
                    this.cis.setTimeout(this.timeout);
                    this.bound = true;
                }
                if (!this.manager.isConnected()) {
                    if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                        throw new SocketTimeoutException("connect timed out");
                    }
                    this.manager.connect(remoteInetSocketAddress, timeLeft);
                    this.protocol = this.manager.getProtocol();
                    if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                        throw new SocketTimeoutException("connect timed out");
                    }
                    this.cis.setTimeout(timeout);
                    this.protocol.connect(this.cis, SocketId.SERVER_SOCKET_ID, timeLeft);
                    if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                        throw new SocketTimeoutException("connect timed out");
                    }
                    this.protocol.verifyConnect(new MultiplexingOutputStream(this.manager, SocketId.SERVER_SOCKET_VERIFY_ID));
                } else {
                    this.protocol = this.manager.getProtocol();
                }
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("connect timed out");
                }
                this.protocol.registerRemoteServerSocket(timeLeft);
            }
            catch (IOException e) {
                log.error("i/o exception in VirtualServerSocket.connect()", e);
                if (this.manager.isServerSocketRegistered()) {
                    this.manager.unRegisterServerSocket(this);
                }
                if (e instanceof SocketTimeoutException) {
                    throw new SocketTimeoutException("connect timed out");
                }
                e.printStackTrace();
                throw e;
            }
            Object var11_10 = null;
            if (this.cis != null) {
                this.cis.setTimeout(this.timeout);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (this.cis != null) {
                this.cis.setTimeout(this.timeout);
            }
            throw throwable;
        }
        this.connected = true;
        log.debug(this.toString());
    }

    public MultiplexingManager getMultiplexingManager() {
        return this.manager;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public InetAddress getRemoteAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getInetAddress();
    }

    public int getRemotePort() {
        if (this.actualSocket == null) {
            return 0;
        }
        return this.actualSocket.getPort();
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    protected void doClose() {
        LinkedList threads = new LinkedList(this.acceptingThreads);
        Iterator it = threads.iterator();
        while (it.hasNext()) {
            Thread t = (Thread)it.next();
            t.interrupt();
            log.debug("interrupting accepting thread: " + t.getName());
            while (this.acceptingThreads.contains(t)) {
                try {
                    log.debug("waiting for accepting thread to catch interrupt: " + t.getName());
                    Thread.sleep(500L);
                    t.interrupt();
                    log.debug("interrupting accepting thread: " + t.getName());
                }
                catch (InterruptedException ignored) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PendingClose
    extends PendingAction {
        public PendingClose(Object o) {
            super(o);
        }

        public void doAction() {
            ((VirtualServerSocket)this.o).doClose();
        }
    }
}

