/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
import org.jboss.remoting.samples.chat.server.ExtendedChatInfo;
import org.jboss.remoting.samples.chat.utility.ShutDownGate;

public class ChatStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$samples$chat$server$ChatStore == null ? (class$org$jboss$remoting$samples$chat$server$ChatStore = ChatStore.class$("org.jboss.remoting.samples.chat.server.ChatStore")) : class$org$jboss$remoting$samples$chat$server$ChatStore);
    private Hashtable extendedChatInfoMap = new Hashtable();
    private ShutDownGate shutDownGate = new ShutDownGate();
    static /* synthetic */ Class class$org$jboss$remoting$samples$chat$server$ChatStore;

    public ShutDownGate getShutDownGate() {
        return this.shutDownGate;
    }

    public void addChat(ExtendedChatInfo eci) throws ShuttingDownException {
        this.shutDownGate.enter();
        String key = eci.getChatInfo().get_key();
        this.extendedChatInfoMap.put(key, eci);
        log.info("adding chat " + key);
        this.shutDownGate.leave();
    }

    ArrayList listChats() throws ShuttingDownException {
        this.shutDownGate.check();
        Collection c = this.extendedChatInfoMap.values();
        ArrayList<ChatInfo> chatArrayList = new ArrayList<ChatInfo>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ExtendedChatInfo eci = (ExtendedChatInfo)it.next();
            ChatInfo ci = eci.getChatInfo();
            ci.set_currentMembers(eci.getMembers().size());
            ci.set_size(eci.getMessages().size());
            chatArrayList.add(ci);
            log.debug("eci.getMembers(): " + eci.getMembers());
        }
        return chatArrayList;
    }

    public ExtendedChatInfo getChat(String key) throws ShuttingDownException {
        this.shutDownGate.check();
        ExtendedChatInfo eci = (ExtendedChatInfo)this.extendedChatInfoMap.get(key);
        return eci;
    }

    public Collection getChatKeySet() {
        return this.extendedChatInfoMap.keySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

