/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.ChatMessage;
import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
import org.jboss.remoting.samples.chat.server.CallbackThread;
import org.jboss.remoting.samples.chat.server.ExtendedChatInfo;
import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
import org.jboss.remoting.samples.chat.utility.ShutDownGate;

public class ChatServer_Impl
implements ServerInvocationHandler {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$samples$chat$server$ChatServer_Impl == null ? (class$org$jboss$remoting$samples$chat$server$ChatServer_Impl = ChatServer_Impl.class$("org.jboss.remoting.samples.chat.server.ChatServer_Impl")) : class$org$jboss$remoting$samples$chat$server$ChatServer_Impl);
    private ExtendedChatInfo extendedChatInfo;
    private Map callbackThreadMap = new HashMap();
    private ShutDownGate shutDownGate;
    private boolean shuttingDown = false;
    static /* synthetic */ Class class$org$jboss$remoting$samples$chat$server$ChatServer_Impl;

    public ChatServer_Impl(ExtendedChatInfo eci, ShutDownGate sdg) {
        this.extendedChatInfo = eci;
        this.shutDownGate = sdg;
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        if (!(invocation.getParameter() instanceof RemoteInvocation)) {
            throw new Exception("invalid request format: expecting NameBasedInvocation");
        }
        RemoteInvocation request = (RemoteInvocation)invocation.getParameter();
        String methodName = request.getMethodName();
        Object[] args = request.getParameters();
        if (methodName.equals("getBackChat")) {
            return this.getBackChat(args);
        }
        if (methodName.equals("getChatInfo")) {
            return this.getChatInfo(args);
        }
        if (methodName.equals("leave")) {
            this.leave(args);
            return null;
        }
        if (methodName.equals("send")) {
            this.send(args);
            return null;
        }
        log.error("unrecognized method name: " + methodName);
        throw new Exception("unrecognized method name: " + methodName);
    }

    protected ArrayList getBackChat(Object[] args) throws ShuttingDownException {
        this.shutDownGate.enter();
        ReadWriteArrayList messages = this.extendedChatInfo.getMessages();
        if (messages == null) {
            System.out.println("messages == null");
            messages = new ReadWriteArrayList();
        }
        ArrayList returnMessages = messages.toArrayList();
        this.shutDownGate.leave();
        return returnMessages;
    }

    protected ChatInfo getChatInfo(Object[] args) throws ShuttingDownException {
        this.shutDownGate.check();
        ChatInfo chatInfo = this.extendedChatInfo.getChatInfo();
        chatInfo.set_currentMembers(this.extendedChatInfo.getMembers().size());
        chatInfo.set_size(this.extendedChatInfo.getMessages().size());
        return chatInfo;
    }

    protected void leave(Object[] args) throws ShuttingDownException {
        ChatMember member = (ChatMember)args[0];
        this.shutDownGate.enter();
        System.out.println("ChatServer.leave(): member leaving: " + member.get_name());
        this.extendedChatInfo.removeMember(member);
        this.shutDownGate.leave();
    }

    protected void send(Object[] args) throws ShuttingDownException {
        ChatMessage mesg = (ChatMessage)args[0];
        this.shutDownGate.enter();
        ReadWriteArrayList messages = this.extendedChatInfo.getMessages();
        messages.add(mesg);
        this.shutDownGate.leave();
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public void setInvoker(ServerInvoker invoker) {
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
        CallbackThread t = new CallbackThread(callbackHandler, this.shutDownGate, this.extendedChatInfo.getMessages());
        this.callbackThreadMap.put(callbackHandler, t);
        t.start();
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
        CallbackThread t = (CallbackThread)this.callbackThreadMap.remove(callbackHandler);
        if (t != null) {
            t.setMemberLeaving();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

