/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class UBMReader
extends FormatReader {
    public static final int HEADER_SIZE = 128;
    private int padding;

    public UBMReader() {
        super("UBM", "pr3");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(128L);
        this.readPlane(this.in, x, y, w, h, this.padding, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.padding = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.seek(44L);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        m.pixelType = 5;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        this.padding = (int)((this.in.length() - (long)FormatTools.getPlaneSize((IFormatReader)this)) / (long)(this.getSizeY() * 4));
        this.addGlobalMeta("Padding bytes", this.padding);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

