/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class SPCReader
extends FormatReader {
    public static final String TAC_RANGE = "SP_TAC_R";
    public static final String TAC_GAIN = "SP_TAC_G";
    private final int adcResShift = 6;
    private ArrayList<String> allFiles;
    protected int nTimebins;
    protected int nChannels;
    protected byte[] Tstore = null;
    ByteBuffer tstoreb;
    protected int storedChannel = -1;
    protected int storedT = -1;
    private int currentPixel;
    private int currentLine;
    private int currentFrame;
    protected int bufLength;
    protected byte[] rawBuf;
    private int nBuffers;
    private int nLines;
    private int nFrames;
    private int nPixels;
    private boolean endOfFrameFlag;
    private int bpp;
    private int binSize;
    private int channel;
    List<Integer> frameClockList;
    List<Integer> endOfFrameList;
    private boolean lineMode;
    private String spcId;

    public SPCReader() {
        super("SPC FIFO Data", new String[]{"spc", "set"});
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
        this.suffixSufficient = true;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .spc file and similarly named .set file";
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(String name, boolean open) {
        if (!SPCReader.checkSuffix((String)name, (String)"spc") && !SPCReader.checkSuffix((String)name, (String)"set")) {
            return false;
        }
        String extension = name.substring(name.lastIndexOf(".") + 1);
        String baseName = name.substring(0, name.lastIndexOf("."));
        if (!new Location(baseName + ".spc").exists()) {
            return false;
        }
        return new Location(baseName + ".set").exists();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        String[] farray = this.allFiles.toArray(new String[this.allFiles.size()]);
        return farray;
    }

    public void reopenFile() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.spcId);
        this.in.order(true);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        Integer sizeT = this.getSizeT();
        this.channel = no / sizeT;
        Integer T = (no -= this.channel * sizeT) / this.nTimebins;
        Integer timebin = no -= T * this.nTimebins;
        this.bpp = 2;
        this.binSize = this.nPixels * this.nLines * this.bpp;
        if (this.Tstore == null) {
            this.Tstore = new byte[this.nPixels * this.nLines * this.bpp * this.nTimebins];
            this.tstoreb = ByteBuffer.wrap(this.Tstore);
            this.tstoreb.order(ByteOrder.LITTLE_ENDIAN);
        }
        if (this.storedT != T || this.storedChannel != this.channel) {
            LOGGER.debug("T =  " + Integer.toString(T));
            Integer frameClockPos = this.frameClockList.get(T);
            Integer endOfFramePos = this.endOfFrameList.get(T + 1);
            Integer frameLength = endOfFramePos - frameClockPos;
            this.in.seek((long)frameClockPos.intValue());
            int noOfBytes = this.in.read(this.rawBuf, 0, frameLength.intValue());
            if (noOfBytes == frameLength) {
                this.currentLine = -1;
                this.currentFrame = -1;
                this.endOfFrameFlag = false;
                this.processBuffer(noOfBytes);
                this.storedT = T;
                this.storedChannel = this.channel;
            }
        }
        Integer iLineSize = this.nPixels * this.bpp;
        Integer oLineSize = w * this.bpp;
        int output = 0;
        if (!this.lineMode) {
            int input = this.binSize * timebin + y * iLineSize + x * this.bpp;
            for (int line = 0; line < h; ++line) {
                System.arraycopy(this.Tstore, input, buf, output, oLineSize);
                input += iLineSize.intValue();
                output += oLineSize.intValue();
            }
        } else {
            ByteBuffer bufb = ByteBuffer.wrap(buf);
            bufb.order(ByteOrder.LITTLE_ENDIAN);
            int input = this.binSize * timebin + x * this.bpp;
            System.arraycopy(this.Tstore, input, buf, output, oLineSize);
            input += iLineSize.intValue();
            for (int line = 1; line < this.nLines; ++line) {
                for (int p = 0; p < oLineSize; p += 2) {
                    Short s = bufb.getShort(output + p);
                    s = (short)(s + this.tstoreb.getShort(input + p));
                    bufb.putShort(output + p, s);
                }
                input += iLineSize.intValue();
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.Tstore = null;
            this.storedChannel = -1;
            this.storedT = -1;
            this.allFiles = null;
            this.frameClockList = new ArrayList<Integer>();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int noOfBytes;
        String workingDirPath;
        super.initFile(id);
        this.allFiles = new ArrayList();
        Location tmpFile = new Location(id).getAbsoluteFile();
        Location workingDir = tmpFile.getParentFile();
        if (workingDir == null) {
            workingDir = new Location(".");
        }
        if (!(workingDirPath = workingDir.getPath()).equals("")) {
            workingDirPath = workingDirPath + File.separator;
        }
        String[] ls = workingDir.list(true);
        if (!new Location(id).exists()) {
            ls = Location.getIdMap().keySet().toArray(new String[0]);
            workingDirPath = "";
        }
        String name = tmpFile.getName();
        String setName = null;
        String spcName = null;
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            setName = tmpFile.getName().substring(0, pos) + ".set";
            spcName = tmpFile.getName().substring(0, pos) + ".spc";
            for (String l : ls) {
                if (l.equalsIgnoreCase(setName)) {
                    setName = l;
                }
                if (!l.equalsIgnoreCase(spcName)) continue;
                spcName = l;
            }
        }
        if (setName == null) {
            throw new FormatException("Failed to find a matching .set file!");
        }
        if (spcName == null) {
            throw new FormatException("Failed to find a matching .spc file!");
        }
        this.frameClockList = new ArrayList<Integer>();
        this.endOfFrameList = new ArrayList<Integer>();
        this.allFiles.add(workingDirPath + setName);
        this.allFiles.add(workingDirPath + spcName);
        this.in = new RandomAccessInputStream(workingDirPath + setName);
        LOGGER.info("Reading info from .set file");
        this.in.order(true);
        this.in.skip(8L);
        Integer setuppos = this.in.readInt();
        Short setupcount = this.in.readShort();
        String module = "";
        try {
            String header = this.in.readString(600);
            int index = header.indexOf("module SPC-");
            module = header.substring(index + 7, index + 14);
        }
        catch (IOException exc) {
            LOGGER.debug("Failed to read header from .set file!", (Throwable)exc);
        }
        if (!(module.equalsIgnoreCase("SPC-134") || module.equalsIgnoreCase("SPC-144") || module.equalsIgnoreCase("SPC-154") || module.equalsIgnoreCase("SPC-830"))) {
            throw new FormatException("Failed to find a matching .set file!");
        }
        this.in.seek((long)setuppos.intValue());
        String setup = this.in.readString((int)setupcount.shortValue());
        this.in.close();
        double tacRange = this.parseSetup(TAC_RANGE, setup);
        double tacGain = this.parseSetup(TAC_GAIN, setup);
        if (tacGain == 0.0 || tacRange == 0.0) {
            throw new FormatException("Failed to parse setup file!");
        }
        double timeBase = 4095.0 * tacRange / (tacGain * 4096.0);
        LOGGER.debug("timeBase = " + Double.toString(timeBase *= 1.0E12));
        this.spcId = workingDirPath + spcName;
        this.in = new RandomAccessInputStream(this.spcId);
        this.in.order(true);
        LOGGER.info("Reading info from .spc file");
        this.in.skip(3L);
        byte routing = this.in.readByte();
        if ((routing & 0x10) != 0) {
            throw new FormatException("Invalid data!");
        }
        this.nChannels = (routing & 0x78) >> 3;
        this.currentPixel = 0;
        this.currentLine = -1;
        this.currentFrame = -1;
        this.rawBuf = new byte[this.bufLength];
        this.endOfFrameFlag = false;
        this.nBuffers = 0;
        this.bufLength = 1024;
        this.rawBuf = new byte[this.bufLength];
        this.nBuffers = 0;
        while ((noOfBytes = this.in.read(this.rawBuf)) != -1) {
            block8: for (int bb = 3; bb < noOfBytes; bb += 4) {
                byte adcL = this.rawBuf[bb];
                byte adcLM = (byte)(adcL & 0xF0);
                switch (adcLM) {
                    case -112: {
                        this.invalidAndMarkInit(bb);
                        continue block8;
                    }
                    case -48: {
                        this.invalidAndMarkInit(bb);
                        continue block8;
                    }
                }
            }
            ++this.nBuffers;
        }
        this.nTimebins = 64;
        this.nFrames = this.currentFrame - 1;
        this.addGlobalMeta("time bins", this.nTimebins);
        this.addGlobalMeta("nChannels", this.nChannels);
        this.addGlobalMeta("time base", timeBase);
        LOGGER.info("Populating metadata");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        if (this.nLines < 530) {
            this.lineMode = false;
            m.sizeY = this.nLines;
        } else {
            LOGGER.info("Single line mode");
            this.lineMode = true;
            m.sizeY = 1;
        }
        Integer maxFrameLength = 0;
        for (int T = 0; T < this.nFrames; ++T) {
            Integer frameLength = this.endOfFrameList.get(T + 1) - this.frameClockList.get(T);
            if (frameLength <= maxFrameLength) continue;
            maxFrameLength = frameLength;
        }
        this.rawBuf = new byte[maxFrameLength.intValue()];
        m.sizeX = this.nPixels;
        m.sizeZ = 1;
        m.sizeT = this.nTimebins * this.nFrames;
        m.sizeC = this.nChannels;
        m.dimensionOrder = "XYZTC";
        m.pixelType = 3;
        m.rgb = false;
        m.littleEndian = true;
        m.imageCount = m.sizeZ * m.sizeC * m.sizeT;
        m.indexed = false;
        m.falseColor = false;
        m.metadataComplete = true;
        m.moduloT.type = "Lifetime";
        m.moduloT.parentType = "Spectra";
        m.moduloT.typeDescription = "TCSPC";
        m.moduloT.start = 0.0;
        m.moduloT.step = timeBase / (double)this.nTimebins;
        m.moduloT.end = m.moduloT.step * (double)(this.nTimebins - 1);
        m.moduloT.unit = "ps";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    private void processBuffer(int noOfBytes) {
        block10: for (int bb = 3; bb < noOfBytes; bb += 4) {
            byte adcL = this.rawBuf[bb];
            byte adcLM = (byte)(adcL & 0xF0);
            switch (adcLM) {
                case -96: {
                    continue block10;
                }
                case 32: {
                    LOGGER.debug(" Got GAP but not invalid!!!");
                    continue block10;
                }
                case 64: {
                    this.photon(bb);
                    continue block10;
                }
                case 0: {
                    this.photon(bb);
                    continue block10;
                }
                case -128: {
                    continue block10;
                }
                case -112: {
                    this.invalidAndMark(bb);
                    continue block10;
                }
                case -48: {
                    this.invalidAndMark(bb);
                    continue block10;
                }
                case -64: {
                    byte routLM = this.rawBuf[bb - 3];
                    continue block10;
                }
                default: {
                    LOGGER.debug("Unrecognised pattern !!!");
                }
            }
        }
    }

    private void invalidAndMark(int blockPtr) {
        byte routM = (byte)(this.rawBuf[blockPtr - 2] & 0xF0);
        switch (routM) {
            case 16: {
                ++this.currentPixel;
                break;
            }
            case 32: {
                if (this.endOfFrameFlag) {
                    this.currentLine = -1;
                    this.endOfFrameFlag = false;
                    ++this.currentFrame;
                }
                ++this.currentLine;
                this.currentPixel = 0;
                break;
            }
            case 64: {
                this.endOfFrameFlag = true;
                break;
            }
            case 96: {
                break;
            }
        }
    }

    private void invalidAndMarkInit(int blockPtr) {
        byte routM = (byte)(this.rawBuf[blockPtr - 2] & 0xF0);
        switch (routM) {
            case 16: {
                ++this.currentPixel;
                break;
            }
            case 32: {
                if (this.currentFrame == 0 && this.currentLine == 1) {
                    this.nPixels = this.currentPixel;
                }
                if (this.endOfFrameFlag) {
                    this.currentLine = -1;
                    this.endOfFrameFlag = false;
                    ++this.currentFrame;
                    Integer position = blockPtr - 3 + this.bufLength * this.nBuffers;
                    this.endOfFrameList.add(position);
                }
                ++this.currentLine;
                this.currentPixel = 0;
                break;
            }
            case 64: {
                LOGGER.debug("Frame clock Init!");
                if (this.currentFrame == 0) {
                    this.nLines = this.currentLine + 1;
                }
                Integer position = blockPtr - 3 + this.bufLength * this.nBuffers;
                this.frameClockList.add(position);
                this.endOfFrameFlag = true;
                break;
            }
            case 96: {
                break;
            }
        }
    }

    private void photon(int blockPtr) {
        int adc = this.rawBuf[blockPtr] & 0xF;
        int currentChannel = (this.rawBuf[blockPtr - 2] & 0xF0) >> 4;
        if ((currentChannel == this.channel || this.nChannels == 1) && this.currentPixel < this.nPixels && this.currentLine > -1 && this.currentLine < this.nLines + 1) {
            Short intensity;
            int pix = this.bpp * (this.currentLine * this.nPixels + this.currentPixel);
            int adcM = (this.rawBuf[blockPtr] & 0xF) << 8;
            int microTime = 4095 - (adcM |= this.rawBuf[blockPtr - 1] & 0xFF);
            int currentBin = microTime >> 6;
            Short s = intensity = Short.valueOf(this.tstoreb.getShort(pix += currentBin * this.binSize));
            Short s2 = intensity = Short.valueOf((short)(intensity + 1));
            this.tstoreb.putShort(pix, intensity);
        }
    }

    private double parseSetup(String tag, String setup) {
        int tagOffset = setup.indexOf(tag);
        String taggedString = setup.substring(tagOffset, tagOffset + 30);
        tagOffset = taggedString.indexOf(44);
        String tagType = taggedString.substring(tagOffset + 1, tagOffset + 2);
        String valueTxt = taggedString.substring(tagOffset + 3, taggedString.indexOf(93));
        double value = 0.0;
        if (tagType.matches("I")) {
            value = Integer.parseInt(valueTxt);
        }
        if (tagType.matches("F")) {
            value = Double.parseDouble(valueTxt);
        }
        return value;
    }
}

