/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OperettaReader
extends FormatReader {
    private static final String[] XML_FILES = new String[]{"Index.idx.xml", "Index.ref.xml", "Index.xml"};
    private static final int XML_TAG = 65500;
    private static final String HARMONY_MAGIC = "Harmony";
    private static final String OPERETTA_MAGIC = "Operett";
    private static final String PHENIX_MAGIC = "Phenix";
    private Plane[][] planes;
    private MinimalTiffReader reader;
    private ArrayList<String> metadataFiles = new ArrayList();
    private transient Location imagesDir;

    public OperettaReader() {
        super("PerkinElmer Operetta", new String[]{"tif", "tiff", "xml"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "Directory with XML file and one .tif/.tiff file per plane";
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        boolean exists = false;
        for (String XML_FILE : XML_FILES) {
            if (!localName.equalsIgnoreCase(XML_FILE)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Location parent = new Location(name).getAbsoluteFile().getParentFile();
            for (String XML_FILE : XML_FILES) {
                Location xml = new Location(parent, XML_FILE);
                if (!xml.exists()) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            return false;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String xml = stream.readString(1024);
        if (xml.indexOf(HARMONY_MAGIC) > 0 || xml.indexOf(OPERETTA_MAGIC) > 0) {
            return true;
        }
        stream.seek(0L);
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        xml = ifd.getIFDTextValue(65500);
        if (xml == null) {
            return false;
        }
        int harmonyIndex = xml.indexOf(HARMONY_MAGIC);
        int operettaIndex = xml.indexOf(OPERETTA_MAGIC);
        return harmonyIndex >= 0 && harmonyIndex < 1024 || operettaIndex >= 0 && operettaIndex < 1024;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.metadataFiles);
        if (!noPixels) {
            Plane[][] planeArray = this.planes;
            int n = planeArray.length;
            for (int i = 0; i < n; ++i) {
                Plane[] well;
                for (Plane p : well = planeArray[i]) {
                    if (p == null || p.filename == null || !new Location(p.filename).exists()) continue;
                    files.add(p.filename);
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.metadataFiles);
        for (Plane p : this.planes[this.getSeries()]) {
            if (p == null || p.filename == null || !new Location(p.filename).exists()) continue;
            files.add(p.filename);
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.planes = null;
            this.metadataFiles.clear();
            this.imagesDir = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        Plane p;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        Arrays.fill(buf, this.getFillColor());
        if (this.getSeries() < this.planes.length && no < this.planes[this.getSeries()].length && (p = this.planes[this.getSeries()][no]) != null && p.filename != null && new Location(p.filename).exists()) {
            if (this.reader == null) {
                this.reader = new MinimalTiffReader();
            }
            try {
                this.reader.setId(p.filename);
            }
            catch (IOException | FormatException e) {
                LOGGER.error("Invalid file " + p.filename, e);
                return buf;
            }
            if (this.reader.getPixelType() != this.getPixelType()) {
                if (this.reader.getPixelType() == 5) {
                    LOGGER.warn("Found invalid 32-bit TIFF in series {}, plane {}: {}", new Object[]{this.getSeries(), no, p.filename});
                    return buf;
                }
                throw new FormatException("Pixel type mismatch in " + p.filename + " (got " + FormatTools.getPixelTypeString((int)this.reader.getPixelType()) + ")");
            }
            if (this.reader.getSizeX() >= this.getSizeX() && this.reader.getSizeY() >= this.getSizeY()) {
                this.reader.openBytes(0, buf, x, y, w, h);
            } else {
                LOGGER.warn("Image dimension mismatch in {}", (Object)p.filename);
                if (x < this.reader.getSizeX() && y < this.reader.getSizeY()) {
                    int realWidth = Math.min(w, this.reader.getSizeX() - x);
                    int realHeight = Math.min(h, this.reader.getSizeY() - y);
                    byte[] realPixels = this.reader.openBytes(0, x, y, realWidth, realHeight);
                    int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
                    int row = realWidth * bpp;
                    int outputRow = w * bpp;
                    for (int yy = 0; yy < realHeight; ++yy) {
                        System.arraycopy(realPixels, yy * row, buf, yy * outputRow, row);
                    }
                }
            }
            this.reader.close();
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String startTime;
        int i;
        if (!OperettaReader.checkSuffix((String)id, (String)"xml")) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            Location xml = new Location(parent, XML_FILES[0]);
            if (!xml.exists()) {
                throw new FormatException("Could not find XML file " + xml.getAbsolutePath());
            }
            this.initFile(xml.getAbsolutePath());
            return;
        }
        super.initFile(id);
        Location currentFile = new Location(this.currentId).getAbsoluteFile();
        this.metadataFiles.add(currentFile.getAbsolutePath());
        Location parent = currentFile.getParentFile();
        if (parent.getName().equalsIgnoreCase("images")) {
            parent = parent.getParentFile();
        }
        Object[] list = parent.list(true);
        Arrays.sort(list);
        for (Object f : list) {
            Location path = new Location(parent, (String)f);
            String pathName = path.getAbsolutePath();
            if (path.isDirectory()) {
                if (((String)f).equals(currentFile.getParentFile().getName())) {
                    LOGGER.trace("Skipping current directory {}", f);
                    continue;
                }
                for (String XML_FILE : XML_FILES) {
                    if (!new Location(path, XML_FILE).exists()) continue;
                    LOGGER.trace("Skipping {} containing {}", f, (Object)XML_FILE);
                }
                Object[] companionFolders = path.list(true);
                Arrays.sort(companionFolders);
                for (Object folder : companionFolders) {
                    LOGGER.trace("Found folder {}", folder);
                    if (OperettaReader.checkSuffix((String)folder, (String)"tiff")) continue;
                    Location metadataLocation = new Location(path, (String)folder);
                    if (!metadataLocation.isDirectory()) {
                        String metadataFile = metadataLocation.getAbsolutePath();
                        if (metadataFile.equals(currentFile.getAbsolutePath())) continue;
                        this.metadataFiles.add(metadataFile);
                        LOGGER.trace("Adding metadata file {}", (Object)metadataFile);
                        continue;
                    }
                    LOGGER.debug("Skipping metadata folder {}", (Object)metadataLocation);
                }
                continue;
            }
            if (OperettaReader.checkSuffix((String)pathName, (String)"tiff") || pathName.equals(currentFile.getAbsolutePath())) continue;
            this.metadataFiles.add(pathName);
            LOGGER.trace("Adding metadata file {}", (Object)pathName);
        }
        OperettaHandler handler = new OperettaHandler();
        try (RandomAccessInputStream xml = new RandomAccessInputStream(id);){
            XMLTools.parseXML((RandomAccessInputStream)xml, (DefaultHandler)((Object)handler));
        }
        ArrayList<Plane> planeList = handler.getPlanes();
        ArrayList<Integer> uniqueRows = new ArrayList<Integer>();
        ArrayList<Integer> uniqueCols = new ArrayList<Integer>();
        ArrayList<String> uniqueWells = new ArrayList<String>();
        ArrayList<Integer> uniqueFields = new ArrayList<Integer>();
        ArrayList<Integer> uniqueZs = new ArrayList<Integer>();
        ArrayList<Integer> uniqueTs = new ArrayList<Integer>();
        ArrayList<Integer> uniqueCs = new ArrayList<Integer>();
        for (Plane p : planeList) {
            String well;
            if (!uniqueRows.contains(p.row)) {
                uniqueRows.add(p.row);
            }
            if (!uniqueCols.contains(p.col)) {
                uniqueCols.add(p.col);
            }
            if (!uniqueFields.contains(p.field)) {
                uniqueFields.add(p.field);
            }
            if (!uniqueZs.contains(p.z)) {
                uniqueZs.add(p.z);
            }
            if (!uniqueCs.contains(p.c)) {
                uniqueCs.add(p.c);
            }
            if (!uniqueTs.contains(p.t)) {
                uniqueTs.add(p.t);
            }
            if (uniqueWells.contains(well = FormatTools.getWellName((int)p.row, (int)p.col))) continue;
            uniqueWells.add(well);
        }
        Object[] rows = uniqueRows.toArray(new Integer[uniqueRows.size()]);
        Object[] cols = uniqueCols.toArray(new Integer[uniqueCols.size()]);
        Object[] fields = uniqueFields.toArray(new Integer[uniqueFields.size()]);
        Object[] zs = uniqueZs.toArray(new Integer[uniqueZs.size()]);
        Object[] cs = uniqueCs.toArray(new Integer[uniqueCs.size()]);
        Object[] ts = uniqueTs.toArray(new Integer[uniqueTs.size()]);
        Arrays.sort(rows);
        Arrays.sort(cols);
        Arrays.sort(fields);
        Arrays.sort(zs);
        Arrays.sort(ts);
        Arrays.sort(cs);
        int seriesCount = uniqueWells.size() * fields.length;
        this.core.clear();
        this.planes = new Plane[seriesCount][zs.length * cs.length * ts.length];
        int nextSeries = 0;
        HashMap<String, Plane> hashToPlane = new HashMap<String, Plane>();
        for (Plane p : planeList) {
            String key = p.row + ":" + p.col + ":" + p.field + ":" + p.c + ":" + p.z + ":" + p.t;
            if (hashToPlane.containsKey(key)) {
                LOGGER.error("Multiple planes found for key {}", (Object)key);
            }
            hashToPlane.put(key, p);
        }
        for (int row = 0; row < rows.length; ++row) {
            for (int col = 0; col < cols.length; ++col) {
                String well = FormatTools.getWellName((int)((Integer)rows[row]), (int)((Integer)cols[col]));
                if (!uniqueWells.contains(well)) continue;
                for (int field = 0; field < fields.length; ++field) {
                    int nextPlane = 0;
                    for (int t = 0; t < ts.length; ++t) {
                        for (int z = 0; z < zs.length; ++z) {
                            for (int c = 0; c < cs.length; ++c) {
                                String key = rows[row] + ":" + cols[col] + ":" + fields[field] + ":" + cs[c] + ":" + zs[z] + ":" + ts[t];
                                if (hashToPlane.containsKey(key)) {
                                    this.planes[nextSeries][nextPlane] = (Plane)hashToPlane.get(key);
                                }
                                ++nextPlane;
                            }
                        }
                    }
                    ++nextSeries;
                }
            }
        }
        this.reader = new MinimalTiffReader();
        for (int i2 = 0; i2 < seriesCount; ++i2) {
            int planeIndex;
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            ms.sizeZ = uniqueZs.size();
            ms.sizeC = uniqueCs.size();
            ms.sizeT = uniqueTs.size();
            ms.dimensionOrder = "XYCZT";
            ms.rgb = false;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            for (planeIndex = 0; planeIndex < this.planes[i2].length && this.planes[i2][planeIndex] == null; ++planeIndex) {
                LOGGER.debug("skipping null plane series = {}, plane = {}", (Object)i2, (Object)planeIndex);
            }
            if (planeIndex >= this.planes[i2].length) {
                if (i2 > 0) {
                    ms.sizeX = ((CoreMetadata)this.core.get((int)(i2 - 1))).sizeX;
                    ms.sizeY = ((CoreMetadata)this.core.get((int)(i2 - 1))).sizeY;
                    ms.pixelType = ((CoreMetadata)this.core.get((int)(i2 - 1))).pixelType;
                    ms.littleEndian = ((CoreMetadata)this.core.get((int)(i2 - 1))).littleEndian;
                    continue;
                }
                LOGGER.warn("Could not find valid plane for series 0");
                continue;
            }
            ms.sizeX = this.planes[i2][planeIndex].x;
            ms.sizeY = this.planes[i2][planeIndex].y;
            String filename = this.planes[i2][planeIndex].filename;
            boolean validFile = false;
            while (!validFile) {
                block80: {
                    if (filename != null && new Location(filename).exists()) {
                        try (RandomAccessInputStream s = new RandomAccessInputStream(filename, 16);){
                            TiffParser parser = new TiffParser(s);
                            parser.setDoCaching(false);
                            IFD firstIFD = parser.getFirstIFD();
                            if (firstIFD != null && firstIFD.getPixelType() != 5) {
                                ms.littleEndian = firstIFD.isLittleEndian();
                                ms.pixelType = firstIFD.getPixelType();
                                validFile = true;
                                break;
                            }
                            break block80;
                        }
                    }
                    LOGGER.debug("Missing TIFF file: {}", (Object)filename);
                }
                ++planeIndex;
                while (planeIndex < this.planes[i2].length && this.planes[i2][planeIndex] == null) {
                    LOGGER.debug("skipping null plane series = {}, plane = {}", (Object)i2, (Object)planeIndex);
                    ++planeIndex;
                }
                if (planeIndex >= this.planes[i2].length) break;
                filename = this.planes[i2][planeIndex].filename;
            }
            if (validFile) continue;
            if (i2 > 0) {
                LOGGER.warn("Could not find valid TIFF file for series {}", (Object)i2);
                ms.littleEndian = ((CoreMetadata)this.core.get((int)0)).littleEndian;
                ms.pixelType = ((CoreMetadata)this.core.get((int)0)).pixelType;
                continue;
            }
            LOGGER.warn("Could not find valid TIFF file for series 0; pixel type may be wrong");
        }
        int firstValidSeries = -1;
        for (i = 0; i < seriesCount; ++i) {
            if (((CoreMetadata)this.core.get((int)i)).sizeX <= 0 || ((CoreMetadata)this.core.get((int)i)).sizeY <= 0) continue;
            firstValidSeries = i;
            break;
        }
        if (firstValidSeries < 0) {
            throw new FormatException("No valid images found");
        }
        for (i = 0; i < seriesCount; ++i) {
            if (((CoreMetadata)this.core.get((int)i)).sizeX != 0 && ((CoreMetadata)this.core.get((int)i)).sizeY != 0) continue;
            ((CoreMetadata)this.core.get((int)i)).sizeX = ((CoreMetadata)this.core.get((int)firstValidSeries)).sizeX;
            ((CoreMetadata)this.core.get((int)i)).sizeY = ((CoreMetadata)this.core.get((int)firstValidSeries)).sizeY;
            ((CoreMetadata)this.core.get((int)i)).pixelType = ((CoreMetadata)this.core.get((int)firstValidSeries)).pixelType;
            ((CoreMetadata)this.core.get((int)i)).littleEndian = ((CoreMetadata)this.core.get((int)firstValidSeries)).littleEndian;
        }
        this.addGlobalMeta("Plate name", handler.getPlateName());
        this.addGlobalMeta("Plate description", handler.getPlateDescription());
        this.addGlobalMeta("Plate ID", handler.getPlateIdentifier());
        this.addGlobalMeta("Measurement ID", handler.getMeasurementID());
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrument, 0);
        String objective = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0});
        store.setObjectiveID(objective, 0, 0);
        if (this.planes[0][0] != null) {
            store.setObjectiveNominalMagnification(Double.valueOf(this.planes[0][0].magnification), 0, 0);
            store.setObjectiveLensNA(Double.valueOf(this.planes[0][0].lensNA), 0, 0);
        }
        store.setPlateID(MetadataTools.createLSID((String)"Plate", (int[])new int[]{0}), 0);
        store.setPlateRows(new PositiveInteger(Integer.valueOf(handler.getPlateRows())), 0);
        store.setPlateColumns(new PositiveInteger(Integer.valueOf(handler.getPlateColumns())), 0);
        String plateAcqID = MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, 0});
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        PositiveInteger fieldCount = FormatTools.getMaxFieldCount((Integer)fields.length);
        if (fieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
        }
        if ((startTime = handler.getMeasurementTime()) != null) {
            store.setPlateAcquisitionStartTime(new Timestamp(startTime), 0, 0);
        }
        int well = 0;
        for (int row = 0; row < rows.length; ++row) {
            for (int col = 0; col < cols.length; ++col) {
                String wellName = FormatTools.getWellName((int)((Integer)rows[row]), (int)((Integer)cols[col]));
                if (!uniqueWells.contains(wellName)) continue;
                store.setWellID(MetadataTools.createLSID((String)"Well", (int[])new int[]{0, well}), 0, well);
                store.setWellRow(new NonNegativeInteger((Integer)rows[row]), 0, well);
                store.setWellColumn(new NonNegativeInteger((Integer)cols[col]), 0, well);
                for (int field = 0; field < fields.length; ++field) {
                    int imageIndex = well * fields.length + field;
                    String wellSampleID = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{0, well, field});
                    store.setWellSampleID(wellSampleID, 0, well, field);
                    store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(imageIndex)), 0, well, field);
                    String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{imageIndex});
                    store.setImageID(imageID, imageIndex);
                    store.setWellSampleImageRef(imageID, 0, well, field);
                    store.setImageInstrumentRef(instrument, imageIndex);
                    store.setObjectiveSettingsID(objective, imageIndex);
                    String name = "Well " + wellName + ", Field " + (field + 1);
                    store.setImageName(name, imageIndex);
                    store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, imageIndex);
                    if (this.planes[imageIndex][0] == null || this.planes[imageIndex][0].absoluteTime == null) continue;
                    store.setImageAcquisitionDate(this.planes[imageIndex][0].absoluteTime, imageIndex);
                    store.setWellSamplePositionX(this.planes[imageIndex][0].positionX, 0, well, field);
                    store.setWellSamplePositionY(this.planes[imageIndex][0].positionY, 0, well, field);
                }
                ++well;
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPlateName(handler.getPlateName(), 0);
            store.setPlateDescription(handler.getPlateDescription(), 0);
            store.setPlateExternalIdentifier(handler.getPlateIdentifier(), 0);
            String experimenterID = MetadataTools.createLSID((String)"Experimenter", (int[])new int[]{0});
            store.setExperimenterID(experimenterID, 0);
            store.setExperimenterLastName(handler.getExperimenterName(), 0);
            for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                store.setImageExperimenterRef(experimenterID, i3);
                Plane first = this.planes[i3][0];
                for (int c = 0; c < this.getSizeC(); ++c) {
                    Plane plane = this.planes[i3][c];
                    if (plane == null) {
                        for (int start = c; plane == null && start < this.planes[i3].length; start += this.getSizeC()) {
                            plane = this.planes[i3][start];
                        }
                    }
                    if (plane == null) continue;
                    if (first == null) {
                        first = plane;
                    }
                    if (plane.channelName != null) {
                        store.setChannelName(plane.channelName, i3, c);
                    }
                    if (plane.acqType != null) {
                        store.setChannelAcquisitionMode(MetadataTools.getAcquisitionMode((String)plane.acqType), i3, c);
                    }
                    if (plane.channelType != null) {
                        store.setChannelContrastMethod(MetadataTools.getContrastMethod((String)plane.channelType), i3, c);
                    }
                    store.setChannelColor(this.getColor(plane.emWavelength), i3, c);
                    store.setChannelEmissionWavelength(FormatTools.getEmissionWavelength((Double)plane.emWavelength), i3, c);
                    store.setChannelExcitationWavelength(FormatTools.getExcitationWavelength((Double)plane.exWavelength), i3, c);
                }
                Plane last = null;
                for (int p = 0; p < this.getImageCount(); ++p) {
                    if (this.planes[i3][p] == null) continue;
                    store.setPlanePositionX(this.planes[i3][p].positionX, i3, p);
                    store.setPlanePositionY(this.planes[i3][p].positionY, i3, p);
                    store.setPlanePositionZ(this.planes[i3][p].positionZ, i3, p);
                    store.setPlaneExposureTime(this.planes[i3][p].exposureTime, i3, p);
                    store.setPlaneDeltaT(this.planes[i3][p].deltaT, i3, p);
                    if (this.getZCTCoords(p)[0] != this.getSizeZ() - 1) continue;
                    last = this.planes[i3][p];
                }
                if (first == null) continue;
                store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX((Double)first.resolutionX), i3);
                store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY((Double)first.resolutionY), i3);
                if (this.getSizeZ() <= 1 || last == null) continue;
                double firstZ = first.positionZ.value(UNITS.MICROMETER).doubleValue();
                double lastZ = last.positionZ.value(UNITS.MICROMETER).doubleValue();
                double averageStep = (lastZ - firstZ) / (double)(this.getSizeZ() - 1);
                store.setPixelsPhysicalSizeZ(FormatTools.getPhysicalSizeZ((Double)averageStep, (Unit)UNITS.MICROMETER), i3);
            }
        }
    }

    private Color getColor(Double emWavelength) {
        if (emWavelength == null) {
            return null;
        }
        if (emWavelength < 450.0) {
            return new Color(255, 0, 255, 255);
        }
        if (emWavelength < 500.0) {
            return new Color(0, 0, 255, 255);
        }
        if (emWavelength < 570.0) {
            return new Color(0, 255, 0, 255);
        }
        if (emWavelength < 590.0) {
            return new Color(255, 255, 0, 255);
        }
        if (emWavelength < 610.0) {
            return new Color(255, 127, 0, 255);
        }
        return new Color(255, 0, 0, 255);
    }

    @Deprecated
    protected AcquisitionMode getAcquisitionMode(String mode) throws FormatException {
        if (mode == null) {
            return null;
        }
        if (mode.equalsIgnoreCase("nipkowconfocal")) {
            return AcquisitionMode.SPINNINGDISKCONFOCAL;
        }
        if (mode.equalsIgnoreCase("confocal")) {
            return AcquisitionMode.LASERSCANNINGCONFOCALMICROSCOPY;
        }
        if (mode.equalsIgnoreCase("nonconfocal")) {
            return AcquisitionMode.WIDEFIELD;
        }
        return MetadataTools.getAcquisitionMode((String)mode);
    }

    class Plane {
        public String filename;
        public int row;
        public int col;
        public int field;
        public int x;
        public int y;
        public int z;
        public int t;
        public int c;
        public String channelName;
        public double resolutionX;
        public double resolutionY;
        public Length positionX;
        public Length positionY;
        public Length positionZ;
        public double emWavelength;
        public double exWavelength;
        public double magnification;
        public double lensNA;
        public Time exposureTime;
        public Time deltaT;
        public Timestamp absoluteTime;
        public String acqType;
        public String channelType;
        public Double[][] orientationMatrix;

        Plane() {
        }

        public void applyMatrix() {
            if (this.positionX == null || this.positionY == null || this.positionZ == null || this.orientationMatrix == null) {
                return;
            }
            double[] v = new double[]{this.positionX.value().doubleValue(), this.positionY.value().doubleValue(), this.positionZ.value().doubleValue()};
            double[] newValues = new double[]{0.0, 0.0, 0.0};
            for (int row = 0; row < this.orientationMatrix.length; ++row) {
                for (int col = 0; col < this.orientationMatrix[row].length; ++col) {
                    if (col < v.length) {
                        int n = row;
                        newValues[n] = newValues[n] + this.orientationMatrix[row][col] * v[col];
                        continue;
                    }
                    int n = row;
                    newValues[n] = newValues[n] + this.orientationMatrix[row][col];
                }
            }
            this.positionX = new Length((Number)newValues[0], this.positionX.unit());
            this.positionY = new Length((Number)newValues[1], this.positionY.unit());
            this.positionZ = new Length((Number)newValues[2], this.positionZ.unit());
        }
    }

    class Channel {
        public int channelID;
        public String channelName;
        public String acqType;
        public String channelType;
        public double resolutionX;
        public double resolutionY;
        public int x;
        public int y;
        public double emWavelength;
        public double exWavelength;
        public double magnification;
        public double lensNA;
        public Time exposureTime;
        public Double[][] orientationMatrix;

        Channel() {
        }

        public void copy(Plane p) {
            if (this.channelID < 0 || this.x == 0 || this.y == 0) {
                return;
            }
            p.channelName = this.channelName;
            p.acqType = this.acqType;
            p.channelType = this.channelType;
            p.resolutionX = this.resolutionX;
            p.resolutionY = this.resolutionY;
            p.x = this.x;
            p.y = this.y;
            p.emWavelength = this.emWavelength;
            p.exWavelength = this.exWavelength;
            p.magnification = this.magnification;
            p.lensNA = this.lensNA;
            p.exposureTime = this.exposureTime;
            p.orientationMatrix = this.orientationMatrix;
        }
    }

    class OperettaHandler
    extends BaseHandler {
        private String currentName;
        private Plane activePlane;
        private Channel activeChannel;
        private String displayName;
        private String plateID;
        private String measurementID;
        private String measurementTime;
        private String plateName;
        private String plateDescription;
        private int plateRows;
        private int plateCols;
        private ArrayList<Plane> planes = new ArrayList();
        private HashMap<Integer, Channel> channels = new HashMap();
        private final StringBuilder currentValue = new StringBuilder();
        private boolean isHarmony = false;
        private String instrumentType = null;

        OperettaHandler() {
        }

        public ArrayList<Plane> getPlanes() {
            return this.planes;
        }

        public String getExperimenterName() {
            return this.displayName;
        }

        public String getPlateIdentifier() {
            return this.plateID;
        }

        public String getMeasurementID() {
            return this.measurementID;
        }

        public String getMeasurementTime() {
            return this.measurementTime;
        }

        public String getPlateName() {
            return this.plateName;
        }

        public String getPlateDescription() {
            return this.plateDescription;
        }

        public int getPlateRows() {
            return this.plateRows;
        }

        public int getPlateColumns() {
            return this.plateCols;
        }

        public String getInstrumentType() {
            return this.instrumentType;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            this.currentValue.append(value);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentValue.setLength(0);
            this.currentName = qName;
            if (qName.equals("Image") && attributes.getValue("id") == null) {
                this.activePlane = new Plane();
            } else if (qName.equals("Entry") && attributes.getValue("ChannelID") != null) {
                int channel = Integer.parseInt(attributes.getValue("ChannelID"));
                this.activeChannel = new Channel();
                this.channels.put(channel, this.activeChannel);
            } else if (qName.equals("EvaluationInputData")) {
                this.isHarmony = attributes.getValue("xmlns").indexOf(OperettaReader.HARMONY_MAGIC) > 0;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            String value = this.currentValue.toString();
            if ("User".equals(this.currentName)) {
                this.displayName = value;
            } else if ("InstrumentType".equals(this.currentName)) {
                this.instrumentType = value;
            } else if ("PlateID".equals(this.currentName)) {
                this.plateID = value;
            } else if ("MeasurementID".equals(this.currentName)) {
                this.measurementID = value;
            } else if ("MeasurementStartTime".equals(this.currentName)) {
                this.measurementTime = value;
            } else if ("Name".equals(this.currentName)) {
                this.plateName = value;
            } else if ("PlateTypeName".equals(this.currentName)) {
                this.plateDescription = value;
            } else if ("PlateRows".equals(this.currentName)) {
                this.plateRows = Integer.parseInt(value);
            } else if ("PlateColumns".equals(this.currentName)) {
                this.plateCols = Integer.parseInt(value);
            } else if (this.activePlane != null || this.activeChannel != null) {
                if ("ImageSizeX".equals(this.currentName)) {
                    int x = Integer.parseInt(value);
                    if (this.activePlane != null) {
                        this.activePlane.x = x;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.x = x;
                    }
                } else if ("ImageSizeY".equals(this.currentName)) {
                    int y = Integer.parseInt(value);
                    if (this.activePlane != null) {
                        this.activePlane.y = y;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.y = y;
                    }
                } else if ("ChannelName".equals(this.currentName)) {
                    if (this.activePlane != null) {
                        this.activePlane.channelName = value;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.channelName = value;
                    }
                } else if ("ImageResolutionX".equals(this.currentName)) {
                    Double resolution = Double.parseDouble(value) * 1000000.0;
                    if (this.activePlane != null) {
                        this.activePlane.resolutionX = resolution;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.resolutionX = resolution;
                    }
                } else if ("ImageResolutionY".equals(this.currentName)) {
                    Double resolution = Double.parseDouble(value) * 1000000.0;
                    if (this.activePlane != null) {
                        this.activePlane.resolutionY = resolution;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.resolutionY = resolution;
                    }
                } else if ("ObjectiveMagnification".equals(this.currentName)) {
                    Double mag = Double.parseDouble(value);
                    if (this.activePlane != null) {
                        this.activePlane.magnification = mag;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.magnification = mag;
                    }
                } else if ("ObjectiveNA".equals(this.currentName)) {
                    Double na = Double.parseDouble(value);
                    if (this.activePlane != null) {
                        this.activePlane.lensNA = na;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.lensNA = na;
                    }
                } else if ("MainEmissionWavelength".equals(this.currentName)) {
                    Double wavelength = Double.parseDouble(value);
                    if (this.activePlane != null) {
                        this.activePlane.emWavelength = wavelength;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.emWavelength = wavelength;
                    }
                } else if ("MainExcitationWavelength".equals(this.currentName)) {
                    Double wavelength = Double.parseDouble(value);
                    if (this.activePlane != null) {
                        this.activePlane.exWavelength = wavelength;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.exWavelength = wavelength;
                    }
                } else if ("ExposureTime".equals(this.currentName)) {
                    Time time = new Time((Number)Double.parseDouble(value), UNITS.SECOND);
                    if (this.activePlane != null) {
                        this.activePlane.exposureTime = time;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.exposureTime = time;
                    }
                } else if ("AcquisitionType".equals(this.currentName)) {
                    if (this.activePlane != null) {
                        this.activePlane.acqType = value;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.acqType = value;
                    }
                } else if ("ChannelType".equals(this.currentName)) {
                    if (this.activePlane != null) {
                        this.activePlane.channelType = value;
                    } else if (this.activeChannel != null) {
                        this.activeChannel.channelType = value;
                    }
                } else if ("OrientationMatrix".equals(this.currentName)) {
                    String[] rows = value.split("]");
                    Double[][] matrix = new Double[rows.length][];
                    for (int i = 0; i < rows.length; ++i) {
                        rows[i] = rows[i].replaceAll("\\[", "").replaceAll(",", " ");
                        String[] values = rows[i].trim().split(" ");
                        matrix[i] = new Double[values.length];
                        for (int j = 0; j < matrix[i].length; ++j) {
                            matrix[i][j] = DataTools.parseDouble((String)values[j]);
                        }
                    }
                    if (matrix.length > 2 && matrix[0].length > 0 && matrix[1].length > 1 && matrix[2].length > 2) {
                        if (this.activePlane != null) {
                            this.activePlane.orientationMatrix = matrix;
                        } else if (this.activeChannel != null) {
                            this.activeChannel.orientationMatrix = matrix;
                        }
                    }
                }
            }
            if (this.activePlane != null) {
                if ("URL".equals(this.currentName)) {
                    if (value.length() > 0) {
                        if (value.startsWith("http")) {
                            this.activePlane.filename = value;
                        } else {
                            Location parent = new Location(OperettaReader.this.currentId).getAbsoluteFile().getParentFile();
                            Location planeFile = new Location(parent, value);
                            if (planeFile.exists()) {
                                this.activePlane.filename = planeFile.getAbsolutePath();
                            } else if (!parent.getName().equalsIgnoreCase("images") && !value.toLowerCase().startsWith("images")) {
                                if (OperettaReader.this.imagesDir == null) {
                                    String[] parentList;
                                    for (String s : parentList = parent.list(true)) {
                                        if (!s.equalsIgnoreCase("images")) continue;
                                        OperettaReader.this.imagesDir = new Location(parent, s);
                                        break;
                                    }
                                    if (OperettaReader.this.imagesDir == null) {
                                        LOGGER.warn("Cannot locate image directory in {}", (Object)parent);
                                    }
                                }
                                if (OperettaReader.this.imagesDir != null) {
                                    this.activePlane.filename = new Location(OperettaReader.this.imagesDir, value).getAbsolutePath();
                                }
                            }
                        }
                    }
                } else if ("Row".equals(this.currentName)) {
                    this.activePlane.row = Integer.parseInt(value) - 1;
                } else if ("Col".equals(this.currentName)) {
                    this.activePlane.col = Integer.parseInt(value) - 1;
                } else if ("FieldID".equals(this.currentName)) {
                    this.activePlane.field = Integer.parseInt(value);
                } else if ("PlaneID".equals(this.currentName)) {
                    this.activePlane.z = Integer.parseInt(value);
                } else if ("TimepointID".equals(this.currentName)) {
                    this.activePlane.t = Integer.parseInt(value);
                } else if ("ChannelID".equals(this.currentName)) {
                    this.activePlane.c = Integer.parseInt(value);
                } else if ("PositionX".equals(this.currentName)) {
                    double meters = Double.parseDouble(value);
                    this.activePlane.positionX = new Length((Number)meters, UNITS.METRE);
                } else if ("PositionY".equals(this.currentName)) {
                    double meters = Double.parseDouble(value);
                    this.activePlane.positionY = new Length((Number)meters, UNITS.METRE);
                } else if ("AbsPositionZ".equals(this.currentName) && !this.isHarmony || "PositionZ".equals(this.currentName) && this.isHarmony) {
                    double meters = Double.parseDouble(value);
                    this.activePlane.positionZ = new Length((Number)meters, UNITS.METRE);
                } else if ("MeasurementTimeOffset".equals(this.currentName)) {
                    this.activePlane.deltaT = new Time((Number)Double.parseDouble(value), UNITS.SECOND);
                } else if ("AbsTime".equals(this.currentName)) {
                    this.activePlane.absoluteTime = new Timestamp(value);
                }
            }
            this.currentName = null;
            if (qName.equals("Image") && this.activePlane != null) {
                Channel c = this.channels.get(this.activePlane.c);
                if (c != null) {
                    c.copy(this.activePlane);
                }
                if (!OperettaReader.PHENIX_MAGIC.equals(this.getInstrumentType())) {
                    this.activePlane.applyMatrix();
                }
                this.planes.add(this.activePlane);
            } else if (qName.equals("Entry")) {
                this.activeChannel = null;
            }
        }
    }
}

