/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.meta.MetadataStore;

public class PictReader
extends FormatReader {
    private static final int PICT_CLIP_RGN = 1;
    private static final int PICT_BITSRECT = 144;
    private static final int PICT_BITSRGN = 145;
    private static final int PICT_PACKBITSRECT = 152;
    private static final int PICT_PACKBITSRGN = 153;
    private static final int PICT_9A = 154;
    private static final int PICT_END = 255;
    private static final int PICT_LONGCOMMENT = 161;
    private static final int PICT_JPEG = 24;
    private static final int PICT_TYPE_1 = 2719;
    private static final int PICT_TYPE_2 = 37264;
    private static final byte[] EXPANSION_TABLE = new byte[2048];
    protected int rowBytes;
    protected Vector strips;
    protected boolean versionOne;
    protected byte[][] lookup;
    private Vector<Long> jpegOffsets = new Vector();

    public PictReader() {
        super("PICT", new String[]{"pict", "pct"});
        this.domains = new String[]{"Graphics"};
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.lookup;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.jpegOffsets.size() > 0) {
            ByteArrayHandle v = new ByteArrayHandle();
            this.in.seek(this.jpegOffsets.get(0).longValue());
            byte[] b = new byte[(int)(this.in.length() - this.in.getFilePointer())];
            this.in.read(b);
            try (RandomAccessInputStream s = new RandomAccessInputStream(b);){
                for (long jpegOffset : this.jpegOffsets) {
                    s.seek(jpegOffset - this.jpegOffsets.get(0));
                    CodecOptions options = new CodecOptions();
                    options.interleaved = this.isInterleaved();
                    options.littleEndian = this.isLittleEndian();
                    v.write(new JPEGCodec().decompress(s, options));
                }
            }
            s = new RandomAccessInputStream((IRandomAccess)v);
            var10_17 = null;
            try {
                s.seek(0L);
                this.readPlane(s, x, y, w, h, buf);
            }
            catch (Throwable throwable) {
                var10_17 = throwable;
                throw throwable;
            }
            finally {
                if (s != null) {
                    if (var10_17 != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable) {
                            var10_17.addSuppressed(throwable);
                        }
                    } else {
                        s.close();
                    }
                }
            }
            return buf;
        }
        if (this.getSizeY() * 4 < this.strips.size() && this.strips.size() / 3 % this.getSizeY() != 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeY = this.strips.size();
        }
        int plane = w * h;
        if (this.lookup != null) {
            for (int i = y; i < y + h; ++i) {
                byte[] row = (byte[])this.strips.get(i);
                int len = Math.min(row.length, w);
                System.arraycopy(row, x, buf, (i - y) * w, len);
            }
        } else if (this.getSizeY() * 3 == this.strips.size() || this.getSizeY() * 4 == this.strips.size()) {
            int nc = this.strips.size() / this.getSizeY();
            byte[] c0 = null;
            byte[] c1 = null;
            byte[] c2 = null;
            for (int i = y; i < h + y; ++i) {
                c0 = (byte[])this.strips.get(i * nc + nc - 3);
                c1 = (byte[])this.strips.get(i * nc + nc - 2);
                c2 = (byte[])this.strips.get(i * nc + nc - 1);
                int baseOffset = (i - y) * w;
                System.arraycopy(c0, x, buf, baseOffset, w);
                System.arraycopy(c1, x, buf, plane + baseOffset, w);
                System.arraycopy(c2, x, buf, 2 * plane + baseOffset, w);
            }
        } else {
            int[] row = null;
            for (int i = y; i < h + y; ++i) {
                row = (int[])this.strips.get(i);
                for (int j = x; j < w + x; ++j) {
                    int base = (i - y) * w + (j - x);
                    buf[base] = (byte)((row[j] & 0x7C00) >> 10);
                    buf[plane + base] = (byte)((row[j] & 0x3E0) >> 5);
                    buf[2 * plane + base] = (byte)(row[j] & 0x1F);
                }
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.rowBytes = 0;
            this.strips = null;
            this.versionOne = false;
            this.lookup = null;
            this.jpegOffsets.clear();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int opcode;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = false;
        this.in.seek(518L);
        m.sizeY = this.in.readShort();
        m.sizeX = this.in.readShort();
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.dimensionOrder = "XYCZT";
        m.imageCount = 1;
        m.falseColor = false;
        m.metadataComplete = true;
        m.interleaved = false;
        m.pixelType = 1;
        this.strips = new Vector();
        this.rowBytes = 0;
        this.lookup = null;
        int verOpcode = this.in.read();
        int verNumber = this.in.read();
        if (verOpcode == 17 && verNumber == 1) {
            this.versionOne = true;
        } else if (verOpcode == 0 && verNumber == 17) {
            this.versionOne = false;
            short verNumber2 = this.in.readShort();
            if (verNumber2 != 767) {
                throw new FormatException("Invalid PICT file : " + verNumber2);
            }
            this.in.skipBytes(6);
            int pixelsPerInchX = this.in.readInt();
            int pixelsPerInchY = this.in.readInt();
            this.in.skipBytes(4);
            short y = this.in.readShort();
            short x = this.in.readShort();
            if (y > 0) {
                m.sizeY = y;
            }
            if (x > 0) {
                m.sizeX = x;
            }
            this.in.skipBytes(4);
        } else {
            throw new FormatException("Invalid PICT file");
        }
        this.addGlobalMeta("Version", this.versionOne ? 1 : 2);
        do {
            if (this.versionOne) {
                opcode = this.in.read();
                continue;
            }
            if ((this.in.getFilePointer() & 1L) != 0L) {
                this.in.skipBytes(1);
            }
            if (this.in.getFilePointer() + 2L >= this.in.length()) break;
            opcode = this.in.readShort() & 0xFFFF;
        } while (this.drivePictDecoder(opcode));
        m.rgb = this.getSizeC() > 1;
        m.indexed = !this.isRGB() && this.lookup != null;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    private boolean drivePictDecoder(int opcode) throws FormatException, IOException {
        LOGGER.debug("drivePictDecoder({}) @ {}", (Object)opcode, (Object)this.in.getFilePointer());
        switch (opcode) {
            case 144: 
            case 145: 
            case 152: 
            case 153: {
                this.rowBytes = this.in.readShort();
                if (this.versionOne || (this.rowBytes & 0x8000) == 0) {
                    this.handleBitmap(opcode);
                    break;
                }
                this.handlePixmap(opcode);
                break;
            }
            case 154: {
                this.handlePixmap(opcode);
                break;
            }
            case 1: {
                short x = this.in.readShort();
                this.in.skipBytes(x - 2);
                break;
            }
            case 161: {
                this.in.skipBytes(2);
                short x = this.in.readShort();
                this.in.skipBytes((int)x);
                break;
            }
            case 255: {
                return false;
            }
            case 2719: 
            case 37264: {
                int x = this.in.read();
                this.in.skipBytes(x);
                break;
            }
            case 24: {
                this.jpegOffsets.add(this.in.getFilePointer() + 2L);
                ((CoreMetadata)this.core.get((int)0)).sizeC = 3;
                ((CoreMetadata)this.core.get((int)0)).rgb = true;
                while ((this.in.readShort() & 0xFFFF) != 65497 && this.in.getFilePointer() < this.in.length()) {
                }
                while (this.in.getFilePointer() < this.in.length()) {
                    while ((this.in.readShort() & 0xFFFF) != 65496 && this.in.getFilePointer() < this.in.length()) {
                    }
                    if (this.in.getFilePointer() >= this.in.length()) continue;
                    this.jpegOffsets.add(this.in.getFilePointer() - 2L);
                }
                ((CoreMetadata)this.core.get((int)0)).interleaved = true;
                break;
            }
            default: {
                if (opcode >= 0) break;
                LOGGER.warn("Invalid opcode: {}", (Object)opcode);
            }
        }
        return this.in.getFilePointer() < this.in.length();
    }

    private void readImageHeader(int opcode) throws IOException {
        if (opcode == 154) {
            this.in.skipBytes(6);
        } else {
            this.rowBytes &= 0x3FFF;
        }
        short tlY = this.in.readShort();
        short tlX = this.in.readShort();
        short brY = this.in.readShort();
        short brX = this.in.readShort();
        if (brX - tlX > 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeX = brX - tlX;
        }
        if (brY - tlY > 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeY = brY - tlY;
        }
        this.in.skipBytes(18);
    }

    private void handleBitmap(int opcode) throws FormatException, IOException {
        this.readImageHeader(opcode);
        this.handlePixmap(1, 1);
    }

    private void handlePixmap(int opcode) throws FormatException, IOException {
        short compCount;
        short pixelSize;
        block7: {
            block6: {
                this.readImageHeader(opcode);
                LOGGER.debug("handlePixmap({})", (Object)opcode);
                pixelSize = this.in.readShort();
                compCount = this.in.readShort();
                this.in.skipBytes(14);
                if (opcode != 154) break block6;
                switch (pixelSize) {
                    case 32: {
                        this.rowBytes = this.getSizeX() * compCount;
                        break block7;
                    }
                    case 16: {
                        this.rowBytes = this.getSizeX() * 2;
                        break block7;
                    }
                    default: {
                        throw new FormatException("Sorry, vector data not supported.");
                    }
                }
            }
            this.in.skipBytes(4);
            short flags = this.in.readShort();
            int count = this.in.readShort();
            this.lookup = new byte[3][++count];
            for (int i = 0; i < count; ++i) {
                this.in.skipBytes(2);
                this.lookup[0][i] = this.in.readByte();
                this.in.skipBytes(1);
                this.lookup[1][i] = this.in.readByte();
                this.in.skipBytes(1);
                this.lookup[2][i] = this.in.readByte();
                this.in.skipBytes(1);
            }
        }
        this.in.skipBytes(18);
        if (opcode == 145 || opcode == 153) {
            this.in.skipBytes(2);
        }
        this.handlePixmap(pixelSize, compCount);
    }

    private void handlePixmap(int pixelSize, int compCount) throws FormatException, IOException {
        LOGGER.debug("handlePixmap({}, {}, {})", new Object[]{this.rowBytes, pixelSize, compCount});
        byte[] uBuf = null;
        int[] uBufI = null;
        int bufSize = this.rowBytes;
        int outBufSize = this.getSizeX();
        byte[] outBuf = null;
        boolean compressed = this.rowBytes >= 8 || pixelSize == 32;
        switch (pixelSize) {
            case 32: {
                if (!compressed) {
                    uBufI = new int[this.getSizeX()];
                    break;
                }
                uBuf = new byte[bufSize];
                break;
            }
            case 16: {
                uBufI = new int[this.getSizeX()];
                break;
            }
            case 8: {
                uBuf = new byte[bufSize];
                break;
            }
            default: {
                outBuf = new byte[outBufSize];
                uBuf = new byte[bufSize];
            }
        }
        if (!compressed) {
            LOGGER.debug("Pixel data is uncompressed (pixelSize={}).", (Object)pixelSize);
            byte[] buf = new byte[bufSize];
            block9: for (int row = 0; row < this.getSizeY(); ++row) {
                this.in.read(buf, 0, this.rowBytes);
                switch (pixelSize) {
                    case 16: {
                        for (int i = 0; i < this.getSizeX(); ++i) {
                            uBufI[i] = DataTools.bytesToShort((byte[])buf, (int)(i * 2), (int)2, (boolean)false);
                        }
                        this.strips.add(uBufI);
                        buf = null;
                        ((CoreMetadata)this.core.get((int)0)).sizeC = 3;
                        continue block9;
                    }
                    case 8: {
                        this.strips.add(buf);
                        continue block9;
                    }
                    default: {
                        this.expandPixels(pixelSize, buf, outBuf, outBuf.length);
                        this.strips.add(outBuf);
                        buf = null;
                    }
                }
            }
        } else {
            LOGGER.debug("Pixel data is compressed (pixelSize={}; compCount={}).", (Object)pixelSize, (Object)compCount);
            byte[] buf = new byte[bufSize + 1 + bufSize / 128];
            for (int row = 0; row < this.getSizeY(); ++row) {
                int rawLen = this.rowBytes > 250 ? this.in.readShort() : this.in.read();
                if (rawLen > buf.length) {
                    rawLen = buf.length;
                }
                if (this.in.length() - this.in.getFilePointer() <= (long)rawLen) {
                    rawLen = (int)(this.in.length() - this.in.getFilePointer() - 1L);
                }
                if (rawLen < 0) {
                    rawLen = 0;
                    this.in.seek(this.in.length() - 1L);
                }
                this.in.read(buf, 0, rawLen);
                if (pixelSize == 16) {
                    uBufI = new int[this.getSizeX()];
                    this.unpackBits(buf, uBufI);
                    this.strips.add(uBufI);
                    ((CoreMetadata)this.core.get((int)0)).sizeC = 3;
                } else {
                    PackbitsCodec c = new PackbitsCodec();
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = this.getSizeX() * 4;
                    uBuf = c.decompress(buf, options);
                }
                if (pixelSize < 8) {
                    this.expandPixels(pixelSize, uBuf, outBuf, outBuf.length);
                    this.strips.add(outBuf);
                    continue;
                }
                if (pixelSize == 8) {
                    this.strips.add(uBuf);
                    continue;
                }
                if (pixelSize != 24 && pixelSize != 32) continue;
                byte[] newBuf = null;
                for (int q = 0; q < compCount; ++q) {
                    int offset = q * this.getSizeX();
                    int len = Math.min(this.getSizeX(), uBuf.length - offset);
                    newBuf = new byte[this.getSizeX()];
                    if (offset < uBuf.length) {
                        System.arraycopy(uBuf, offset, newBuf, 0, len);
                    }
                    this.strips.add(newBuf);
                }
                ((CoreMetadata)this.core.get((int)0)).sizeC = 3;
            }
        }
    }

    private void expandPixels(int bitSize, byte[] ib, byte[] ob, int outLen) throws FormatException {
        LOGGER.debug("expandPixels({}, {}, {}, {})", new Object[]{bitSize, ib.length, ob.length, outLen});
        if (bitSize == 1) {
            int remainder = outLen % 8;
            int max = outLen / 8;
            for (int i = 0; i < max; ++i) {
                if (i < ib.length) {
                    int look = (ib[i] & 0xFF) * 8;
                    System.arraycopy(EXPANSION_TABLE, look, ob, i * 8, 8);
                    continue;
                }
                i = max;
            }
            if (remainder != 0 && max < ib.length) {
                System.arraycopy(EXPANSION_TABLE, (ib[max] & 0xFF) * 8, ob, max * 8, remainder);
            }
            return;
        }
        int count = 8 / bitSize;
        int maskshift = bitSize;
        int pixelshift = 8 - bitSize;
        int tpixelshift = 0;
        int pixelshiftdelta = bitSize;
        if (bitSize != 1 && bitSize != 2 && bitSize != 4) {
            throw new FormatException("Can only expand 1, 2, and 4 bit values");
        }
        int mask = (int)Math.pow(2.0, bitSize) - 1 << 8 - bitSize;
        int i = 0;
        int o = 0;
        while (o < ob.length) {
            int tmask = mask;
            tpixelshift = pixelshift;
            byte v = ib[i];
            for (int t = 0; t < count && o < ob.length; ++t, ++o) {
                ob[o] = (byte)((v & tmask) >>> tpixelshift & 0xFF);
                tmask = (byte)((tmask & 0xFF) >>> maskshift);
                tpixelshift -= pixelshiftdelta;
            }
            ++i;
        }
    }

    private void unpackBits(byte[] ib, int[] ob) {
        LOGGER.debug("unpackBits(...)");
        int i = 0;
        int o = 0;
        while (o < ob.length) {
            if (i + 1 < ib.length) {
                int end;
                byte b;
                if ((b = ib[i++]) >= 0) {
                    end = o + b + 1;
                    while (o < end && o < ob.length && i + 1 < ib.length) {
                        ob[o++] = DataTools.bytesToShort((byte[])ib, (int)i, (int)2, (boolean)false);
                        i += 2;
                    }
                    continue;
                }
                if (b == -128) continue;
                short rep = DataTools.bytesToShort((byte[])ib, (int)i, (int)2, (boolean)false);
                i += 2;
                end = o - b + 1;
                while (o < end && o < ob.length) {
                    ob[o++] = rep;
                }
                continue;
            }
            o = ob.length;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                PictReader.EXPANSION_TABLE[i * 8 + j] = (byte)((i & (int)Math.pow(2.0, 7 - j)) >> 7 - j);
            }
        }
    }
}

