/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CompoundTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerBitSetFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerBooleanFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerByteFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerDateFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerDoubleFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerEnumArrayFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerEnumFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerFloatFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerHDF5TimeDurationFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerIntFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerLongFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerShortFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerStringFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.PaddingUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class HDF5CompoundByteifyerFactory {
    private static List<IHDF5CompoundMemberBytifyerFactory> memberFactories = new ArrayList<IHDF5CompoundMemberBytifyerFactory>(14);

    static {
        memberFactories.add(new HDF5CompoundMemberByteifyerBooleanFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerIntFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerLongFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerShortFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerByteFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerFloatFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerDoubleFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerStringFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerBitSetFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerDateFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerHDF5TimeDurationFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerEnumFactory());
        memberFactories.add(new HDF5CompoundMemberByteifyerEnumArrayFactory());
    }

    HDF5CompoundByteifyerFactory() {
    }

    static Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        for (IHDF5CompoundMemberBytifyerFactory factory : memberFactories) {
            Class<?> javaClassOrNull = factory.tryGetOverrideJavaType(dataClass, rank, elementSize, typeVariantOrNull);
            if (javaClassOrNull == null) continue;
            return javaClassOrNull;
        }
        return null;
    }

    static HDF5MemberByteifyer[] createMemberByteifyers(Class<?> clazz, HDF5ValueObjectByteifyer.IFileAccessProvider fileInfoProvider, CompoundTypeInformation compoundTypeInfoOrNull, HDF5CompoundMemberMapping[] members) {
        HDF5MemberByteifyer[] result = new HDF5MemberByteifyer[members.length];
        int offsetOnDisk = 0;
        int offsetInMemory = 0;
        int i = 0;
        while (i < result.length) {
            HDF5EnumerationType enumTypeOrNullOrNull;
            HDF5CompoundMemberInformation compoundMemberInfoOrNull;
            AccessType accessType = HDF5CompoundByteifyerFactory.getAccessType(clazz);
            HDF5CompoundMemberInformation hDF5CompoundMemberInformation = compoundMemberInfoOrNull = compoundTypeInfoOrNull == null ? null : compoundTypeInfoOrNull.getMember(i);
            Field fieldOrNull = accessType == AccessType.FIELD ? members[i].tryGetField(clazz, compoundMemberInfoOrNull != null) : null;
            Class<?> memberClazzOrNull = fieldOrNull != null ? fieldOrNull.getType() : members[i].tryGetMemberClass();
            IHDF5CompoundMemberBytifyerFactory factory = HDF5CompoundByteifyerFactory.findFactory(memberClazzOrNull, compoundMemberInfoOrNull, members[i].getMemberName());
            HDF5EnumerationType hDF5EnumerationType = enumTypeOrNullOrNull = compoundTypeInfoOrNull == null ? null : compoundTypeInfoOrNull.enumTypes[i];
            if (compoundMemberInfoOrNull != null) {
                offsetOnDisk = compoundMemberInfoOrNull.getOffsetOnDisk();
                offsetInMemory = compoundMemberInfoOrNull.getOffsetInMemory();
            }
            result[i] = HDF5CompoundByteifyerFactory.isDummy(accessType, fieldOrNull) ? new HDF5DummyMemberByteifyer(factory.createBytifyer(accessType, fieldOrNull, members[i], compoundMemberInfoOrNull, enumTypeOrNullOrNull, memberClazzOrNull, i, offsetOnDisk, offsetInMemory, fileInfoProvider)) : factory.createBytifyer(accessType, fieldOrNull, members[i], compoundMemberInfoOrNull, enumTypeOrNullOrNull, memberClazzOrNull, i, offsetOnDisk, offsetInMemory, fileInfoProvider);
            if (compoundMemberInfoOrNull == null) {
                int size = result[i].getSize();
                int elementSize = result[i].getElementSize();
                offsetOnDisk += size;
                offsetInMemory = PaddingUtils.padOffset(offsetInMemory + size, elementSize);
            }
            ++i;
        }
        return result;
    }

    private static boolean isDummy(AccessType accessType, Field fieldOrNull) {
        return accessType == AccessType.FIELD && fieldOrNull == null;
    }

    private static IHDF5CompoundMemberBytifyerFactory findFactory(Class<?> memberClazz, HDF5CompoundMemberInformation memberInfoOrNull, String memberName) {
        if (memberClazz == null) {
            throw new IllegalArgumentException("No type given for member '" + memberName + "'.");
        }
        for (IHDF5CompoundMemberBytifyerFactory factory : memberFactories) {
            if (!factory.canHandle(memberClazz, memberInfoOrNull)) continue;
            return factory;
        }
        if (memberInfoOrNull == null) {
            throw new IllegalArgumentException("The member '" + memberName + "' is of type '" + memberClazz.getCanonicalName() + "' which cannot be handled by any HDFMemberByteifyer.");
        }
        throw new IllegalArgumentException("The member '" + memberName + "' is of type '" + memberClazz.getCanonicalName() + "' [memory] and '" + memberInfoOrNull.getType() + "' [disk] which cannot be handled by any HDFMemberByteifyer.");
    }

    private static AccessType getAccessType(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return AccessType.MAP;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return AccessType.LIST;
        }
        if (Object[].class == clazz) {
            return AccessType.ARRAY;
        }
        return AccessType.FIELD;
    }

    static Object getMap(Object obj, String name) {
        return ((Map)obj).get(name);
    }

    static Object getList(Object obj, int index) {
        return ((List)obj).get(index);
    }

    static Object getArray(Object obj, int index) {
        return ((Object[])obj)[index];
    }

    static void putMap(Object obj, String memberName, Object value) {
        ((Map)obj).put(memberName, value);
    }

    static void setList(Object obj, int index, Object value) {
        ((List)obj).set(index, value);
    }

    static void setArray(Object obj, int index, Object value) {
        ((Object[])obj)[index] = value;
    }

    static enum AccessType {
        FIELD,
        MAP,
        LIST,
        ARRAY;

    }

    private static class HDF5DummyMemberByteifyer
    extends HDF5MemberByteifyer {
        private final HDF5MemberByteifyer delegate;

        public HDF5DummyMemberByteifyer(HDF5MemberByteifyer delegate) {
            super(null, null, 0, 0, 0, false, null);
            this.delegate = delegate;
        }

        @Override
        int getElementSize() {
            return 0;
        }

        @Override
        public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
            return new byte[this.delegate.getSize()];
        }

        @Override
        public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
        }

        @Override
        protected long getMemberStorageTypeId() {
            return this.delegate.getMemberStorageTypeId();
        }

        @Override
        protected long getMemberNativeTypeId() {
            return this.delegate.getMemberNativeTypeId();
        }

        @Override
        public HDF5DataTypeVariant getTypeVariant() {
            return this.delegate.getTypeVariant();
        }

        @Override
        public void insertType(long dataTypeId) {
            this.delegate.insertType(dataTypeId);
        }

        @Override
        public void insertNativeType(long dataTypeId, HDF5 h5, ICleanUpRegistry registry) {
            this.delegate.insertNativeType(dataTypeId, h5, registry);
        }

        @Override
        public int getMaxCharacters() {
            return this.delegate.getMaxCharacters();
        }

        @Override
        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public int getOffsetOnDisk() {
            return this.delegate.getOffsetOnDisk();
        }

        @Override
        public int getOffsetInMemory() {
            return this.delegate.getOffsetInMemory();
        }

        @Override
        public int getTotalSizeOnDisk() {
            return this.delegate.getTotalSizeOnDisk();
        }

        @Override
        public int getTotalSizeInMemory() {
            return this.delegate.getTotalSizeInMemory();
        }

        @Override
        public String getMemberName() {
            return this.delegate.getMemberName();
        }

        @Override
        public String describe() {
            return this.delegate.describe();
        }

        @Override
        public boolean isDummy() {
            return true;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }

    static interface IHDF5CompoundMemberBytifyerFactory {
        public boolean canHandle(Class<?> var1, HDF5CompoundMemberInformation var2);

        public HDF5MemberByteifyer createBytifyer(AccessType var1, Field var2, HDF5CompoundMemberMapping var3, HDF5CompoundMemberInformation var4, HDF5EnumerationType var5, Class<?> var6, int var7, int var8, int var9, HDF5ValueObjectByteifyer.IFileAccessProvider var10);

        public Class<?> tryGetOverrideJavaType(HDF5DataClass var1, int var2, int var3, HDF5DataTypeVariant var4);
    }
}

