/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.graph.selector;

import java.util.Objects;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.collection.DependencyCollectionContext;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.collection.DependencySelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.Dependency;

public final class StaticDependencySelector
implements DependencySelector {
    private final boolean select;

    public StaticDependencySelector(boolean select) {
        this.select = select;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        return this.select;
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        StaticDependencySelector that = (StaticDependencySelector)obj;
        return this.select == that.select;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + (this.select ? 1 : 0);
        return hash;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.select ? "Select all" : "Exclude all");
    }
}

