/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.providers;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.support.NamedLockFactorySupport;

@Singleton
@Named(value="semaphore-local")
public class LocalSemaphoreNamedLockFactory
extends NamedLockFactorySupport {
    public static final String NAME = "semaphore-local";

    @Override
    protected AdaptedSemaphoreNamedLock createLock(String name) {
        Semaphore semaphore = new Semaphore(Integer.MAX_VALUE);
        return new AdaptedSemaphoreNamedLock(name, this, new JVMSemaphore(semaphore));
    }

    private static final class JVMSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final Semaphore semaphore;

        private JVMSemaphore(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        @Override
        public boolean tryAcquire(int perms, long time, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time, unit);
        }

        @Override
        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

