/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.metadata.Metadata;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="static")
public class StaticNameMapper
implements NameMapper {
    public static final String NAME = "static";
    private static final String CONFIG_PROP_NAME = "aether.syncContext.named.static.name";
    private final String name;

    @Inject
    public StaticNameMapper() {
        this(NAME);
    }

    public StaticNameMapper(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        return Collections.singletonList(ConfigUtils.getString(session, this.name, CONFIG_PROP_NAME));
    }
}

