/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.metadata.Metadata;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.ChecksumUtils;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.ConfigUtils;
import org.apache.maven.resolver.internal.ant.org.slf4j.Logger;
import org.apache.maven.resolver.internal.ant.org.slf4j.LoggerFactory;

@Singleton
@Named(value="discriminating")
public class DiscriminatingNameMapper
implements NameMapper {
    public static final String NAME = "discriminating";
    private static final String CONFIG_PROP_DISCRIMINATOR = "aether.syncContext.named.discriminating.discriminator";
    private static final String CONFIG_PROP_HOSTNAME = "aether.syncContext.named.discriminating.hostname";
    private static final String DEFAULT_DISCRIMINATOR_DIGEST = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscriminatingNameMapper.class);
    private final NameMapper nameMapper;
    private final String hostname;

    @Inject
    public DiscriminatingNameMapper(@Named(value="gav") NameMapper nameMapper) {
        this.nameMapper = Objects.requireNonNull(nameMapper);
        this.hostname = this.getHostname();
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        String discriminator = this.createDiscriminator(session);
        return this.nameMapper.nameLocks(session, artifacts, metadatas).stream().map(s -> discriminator + ":" + s).collect(Collectors.toList());
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to get hostname, using '{}'", (Object)DEFAULT_HOSTNAME, (Object)e);
            return DEFAULT_HOSTNAME;
        }
    }

    private String createDiscriminator(RepositorySystemSession session) {
        String discriminator = ConfigUtils.getString(session, null, CONFIG_PROP_DISCRIMINATOR);
        if (discriminator == null || discriminator.isEmpty()) {
            String hostname = ConfigUtils.getString(session, this.hostname, CONFIG_PROP_HOSTNAME);
            File basedir = session.getLocalRepository().getBasedir();
            discriminator = hostname + ":" + basedir;
            try {
                Map<String, Object> checksums = ChecksumUtils.calc(discriminator.getBytes(StandardCharsets.UTF_8), Collections.singletonList("SHA-1"));
                Object checksum = checksums.get("SHA-1");
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                return String.valueOf(checksum);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to calculate discriminator digest, using '{}'", (Object)DEFAULT_DISCRIMINATOR_DIGEST, (Object)e);
                return DEFAULT_DISCRIMINATOR_DIGEST;
            }
        }
        return discriminator;
    }
}

