/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.synccontext.named.StaticNameMapper;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.NamedLockFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.named.providers.NoopNamedLockFactory;

@Singleton
@Named
public final class NamedLockFactorySelector {
    public static final long TIME = Long.getLong("aether.syncContext.named.time", 30L);
    public static final TimeUnit TIME_UNIT = TimeUnit.valueOf(System.getProperty("aether.syncContext.named.time.unit", TimeUnit.SECONDS.name()));
    private static final String FACTORY_NAME = System.getProperty("aether.syncContext.named.factory", "rwlock-local");
    private static final String NAME_MAPPER_NAME = System.getProperty("aether.syncContext.named.nameMapper", "gav");
    private final NamedLockFactory namedLockFactory;
    private final NameMapper nameMapper;

    @Inject
    public NamedLockFactorySelector(Map<String, NamedLockFactory> factories, Map<String, NameMapper> nameMappers) {
        this.namedLockFactory = NamedLockFactorySelector.selectNamedLockFactory(factories);
        this.nameMapper = NamedLockFactorySelector.selectNameMapper(nameMappers);
    }

    public NamedLockFactorySelector() {
        HashMap<String, NamedLockFactory> factories = new HashMap<String, NamedLockFactory>();
        factories.put("noop", new NoopNamedLockFactory());
        factories.put("rwlock-local", new LocalReadWriteLockNamedLockFactory());
        factories.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        this.namedLockFactory = NamedLockFactorySelector.selectNamedLockFactory(factories);
        HashMap<String, NameMapper> nameMappers = new HashMap<String, NameMapper>();
        nameMappers.put("static", new StaticNameMapper());
        nameMappers.put("gav", new GAVNameMapper());
        nameMappers.put("discriminating", new DiscriminatingNameMapper(new GAVNameMapper()));
        this.nameMapper = NamedLockFactorySelector.selectNameMapper(nameMappers);
    }

    public NamedLockFactory getSelectedNamedLockFactory() {
        return this.namedLockFactory;
    }

    public NameMapper getSelectedNameMapper() {
        return this.nameMapper;
    }

    private static NamedLockFactory selectNamedLockFactory(Map<String, NamedLockFactory> factories) {
        NamedLockFactory factory = factories.get(FACTORY_NAME);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: " + FACTORY_NAME + ", known ones: " + factories.keySet());
        }
        return factory;
    }

    private static NameMapper selectNameMapper(Map<String, NameMapper> nameMappers) {
        NameMapper nameMapper = nameMappers.get(NAME_MAPPER_NAME);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: " + NAME_MAPPER_NAME + ", known ones: " + nameMappers.keySet());
        }
        return nameMapper;
    }
}

