/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl;

import java.util.Objects;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.ChecksumFailureException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.TransferResource;
import org.apache.maven.resolver.internal.ant.org.slf4j.Logger;
import org.apache.maven.resolver.internal.ant.org.slf4j.LoggerFactory;

abstract class AbstractChecksumPolicy
implements ChecksumPolicy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TransferResource resource;

    protected AbstractChecksumPolicy(TransferResource resource) {
        this.resource = resource;
    }

    @Override
    public boolean onChecksumMatch(String algorithm, int kind) {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        return true;
    }

    @Override
    public void onChecksumMismatch(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        Objects.requireNonNull(exception, "exception cannot be null");
        if ((kind & 1) == 0) {
            throw exception;
        }
    }

    @Override
    public void onChecksumError(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        Objects.requireNonNull(exception, "exception cannot be null");
        this.logger.debug("Could not validate {} checksum for {}", algorithm, this.resource.getResourceName(), exception);
    }

    @Override
    public void onNoMoreChecksums() throws ChecksumFailureException {
        throw new ChecksumFailureException("Checksum validation failed, no checksums available");
    }

    @Override
    public void onTransferRetry() {
    }
}

