/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.resolver.internal.ant.org.apache.maven.repository.internal.LocalSnapshotMetadata;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.impl.MetadataGenerator;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.installation.InstallRequest;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.metadata.Metadata;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.ConfigUtils;

class LocalSnapshotMetadataGenerator
implements MetadataGenerator {
    private Map<Object, LocalSnapshotMetadata> snapshots;
    private final boolean legacyFormat;
    private final Date timestamp;

    LocalSnapshotMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this.legacyFormat = ConfigUtils.getBoolean(session.getConfigProperties(), false, "maven.metadata.legacy");
        this.timestamp = (Date)ConfigUtils.getObject(session, (Object)new Date(), "maven.startTime");
        this.snapshots = new LinkedHashMap<Object, LocalSnapshotMetadata>();
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = LocalSnapshotMetadata.getKey(artifact);
            LocalSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new LocalSnapshotMetadata(artifact, this.legacyFormat, this.timestamp);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return this.snapshots.values();
    }
}

