/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.Modulo;
import loci.formats.ReaderWrapper;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;
import loci.formats.in.AFIReader;
import loci.formats.in.APLReader;
import loci.formats.in.APNGReader;
import loci.formats.in.AnalyzeReader;
import loci.formats.in.BDReader;
import loci.formats.in.BMPReader;
import loci.formats.in.BrukerReader;
import loci.formats.in.CV7000Reader;
import loci.formats.in.CellSensReader;
import loci.formats.in.CellVoyagerReader;
import loci.formats.in.CellWorxReader;
import loci.formats.in.CellomicsReader;
import loci.formats.in.ColumbusReader;
import loci.formats.in.DNGReader;
import loci.formats.in.DeltavisionReader;
import loci.formats.in.DicomReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.FilePatternReader;
import loci.formats.in.FlexReader;
import loci.formats.in.GelReader;
import loci.formats.in.HamamatsuVMSReader;
import loci.formats.in.HitachiReader;
import loci.formats.in.InCellReader;
import loci.formats.in.InveonReader;
import loci.formats.in.JDCEReader;
import loci.formats.in.JPEG2000Reader;
import loci.formats.in.JPEGReader;
import loci.formats.in.L2DReader;
import loci.formats.in.LIFReader;
import loci.formats.in.LOFReader;
import loci.formats.in.MIASReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.in.MetamorphReader;
import loci.formats.in.MetamorphTiffReader;
import loci.formats.in.MetaxpressTiffReader;
import loci.formats.in.MicroCTReader;
import loci.formats.in.MicromanagerReader;
import loci.formats.in.ND2Reader;
import loci.formats.in.NDPISReader;
import loci.formats.in.NRRDReader;
import loci.formats.in.NiftiReader;
import loci.formats.in.NikonReader;
import loci.formats.in.OIRReader;
import loci.formats.in.OMETiffReader;
import loci.formats.in.OMEXMLReader;
import loci.formats.in.OlympusTileReader;
import loci.formats.in.OperettaReader;
import loci.formats.in.PGMReader;
import loci.formats.in.PrairieReader;
import loci.formats.in.QTReader;
import loci.formats.in.RCPNLReader;
import loci.formats.in.SISReader;
import loci.formats.in.SVSReader;
import loci.formats.in.TecanReader;
import loci.formats.in.TiffDelegateReader;
import loci.formats.in.TissueFAXSReader;
import loci.formats.in.TrestleReader;
import loci.formats.in.VolocityReader;
import loci.formats.in.XLEFReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.tests.testng.Configuration;
import loci.tests.testng.ConfigurationTree;
import loci.tests.testng.TestTools;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Quantity;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class FormatReaderTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatReaderTest.class);
    private static final String SKIP_MESSAGE = "Dataset already tested.";
    public static ConfigurationTree configTree;
    private static List<String> skipFiles;
    private static ArrayList<String> initialDescriptors;
    private BufferedImageReader reader;
    private String id;
    private boolean skip = false;
    private Configuration config;
    private String omexmlDir = System.getProperty("testng.omexmlDirectory");
    private String cacheDir = System.getProperty("testng.cacheDirectory");
    private String fileList = System.getProperty("testng.file-list");
    private float timeMultiplier = 1.0f;
    private boolean inMemory = false;
    private OMEXMLService omexmlService = null;

    public FormatReaderTest(String filename, float multiplier, boolean inMemory) {
        this.id = filename;
        this.timeMultiplier = multiplier;
        this.inMemory = inMemory;
        try {
            ServiceFactory factory = new ServiceFactory();
            this.omexmlService = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException e) {
            LOGGER.warn("OMEXMLService not available", (Throwable)e);
        }
    }

    public String getID() {
        return this.id;
    }

    public String toString() {
        return this.getID();
    }

    @BeforeClass(alwaysRun=true)
    public void setup() throws IOException {
        try {
            this.initFile();
        }
        catch (RuntimeException e) {
            LOGGER.trace("File initialization failed", (Throwable)e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void close() throws IOException {
        this.reader.close();
        HashMap idMap = Location.getIdMap();
        idMap.clear();
        Location.setIdMap((HashMap)idMap);
    }

    @BeforeSuite(alwaysRun=true)
    public void saveFileDescriptorCount() throws IOException {
        initialDescriptors = TestTools.getHandles(true);
    }

    @AfterSuite(alwaysRun=true)
    public void checkFileDescriptorCount() throws IOException {
        ArrayList<String> currentDescriptors = TestTools.getHandles(true);
        long leakedDescriptors = currentDescriptors.size() - initialDescriptors.size();
        if (leakedDescriptors > 0L) {
            currentDescriptors.removeAll(initialDescriptors);
            for (int i = 0; i < currentDescriptors.size(); ++i) {
                String name = new File(currentDescriptors.get(i)).getName();
                if (!name.startsWith("bio-formats-test-") || !name.endsWith(".log")) continue;
                currentDescriptors.remove(i);
                --i;
            }
            leakedDescriptors = currentDescriptors.size();
            if (leakedDescriptors > 0L) {
                LOGGER.warn("Open file handles:");
                for (String f : currentDescriptors) {
                    LOGGER.warn("  {}", (Object)f);
                }
            }
        }
        FormatReaderTest.result("File handle", leakedDescriptors <= 0L, leakedDescriptors + " leaked file handles");
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testBufferedImageDimensions() {
        String testName = "testBufferedImageDimensions";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            BufferedImage b = null;
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                Assert.assertEquals((int)this.reader.getSeries(), (int)i);
                int x = this.reader.getSizeX();
                int y = this.reader.getSizeY();
                int c = this.reader.getRGBChannelCount();
                int type = this.reader.getPixelType();
                int bytes = FormatTools.getBytesPerPixel((int)type);
                int plane = x * y * c * bytes;
                long checkPlane = (long)x * (long)y * (long)c * (long)bytes;
                if (DataTools.indexOf((Object[])this.reader.getDomains(), (Object)"Histology") >= 0) {
                    plane *= 2;
                    checkPlane *= 2L;
                }
                if (c > 4 || plane < 0 || (long)plane != checkPlane || !TestTools.canFitInMemory(checkPlane * 3L)) continue;
                int num = this.reader.getImageCount();
                if (num > 3) {
                    num = 3;
                }
                for (int j = 0; j < num && success; ++j) {
                    int actualType;
                    boolean passType;
                    int actualC;
                    boolean passC;
                    int actualY;
                    boolean passY;
                    boolean passX;
                    b = this.reader.openImage(j);
                    int actualX = b.getWidth();
                    boolean bl = passX = x == actualX;
                    if (!passX) {
                        msg = "X: was " + actualX + ", expected " + x;
                    }
                    boolean bl2 = passY = y == (actualY = b.getHeight());
                    if (!passY) {
                        msg = "Y: was " + actualY + ", expected " + y;
                    }
                    boolean bl3 = passC = c == (actualC = b.getRaster().getNumBands());
                    if (!passC) {
                        msg = "C: was " + actualC + ", expected " + c;
                    }
                    boolean bl4 = passType = type == (actualType = AWTImageTools.getPixelType((BufferedImage)b));
                    if (!passType && actualType == 3 && type == 2) {
                        passType = true;
                    }
                    if (!passType) {
                        msg = "type: was " + actualType + ", expected " + type;
                    }
                    success = passX && passY && passC && passType;
                }
            }
        }
        catch (Throwable t) {
            if (TestTools.isOutOfMemory(t)) {
                FormatReaderTest.result(testName, true, "Image too large");
                return;
            }
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testByteArrayDimensions() {
        String testName = "testByteArrayDimensions";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            byte[] b = null;
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                int x = this.reader.getSizeX();
                int y = this.reader.getSizeY();
                int c = this.reader.getRGBChannelCount();
                int bytes = FormatTools.getBytesPerPixel((int)this.reader.getPixelType());
                int expected = -1;
                try {
                    expected = DataTools.safeMultiply32((int[])new int[]{x, y, c, bytes});
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (!TestTools.canFitInMemory((long)expected * 3L) || expected < 0) continue;
                int num = this.reader.getImageCount();
                if (num > 3) {
                    num = 3;
                }
                for (int j = 0; j < num && success; ++j) {
                    b = this.reader.openBytes(j);
                    boolean bl = success = b.length == expected;
                    if (success) continue;
                    msg = "series #" + i + ", image #" + j + ": was " + b.length + ", expected " + expected;
                }
            }
        }
        catch (Throwable t) {
            if (TestTools.isOutOfMemory(t)) {
                FormatReaderTest.result(testName, true, "Image too large");
                return;
            }
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testThumbnailImageDimensions() {
        String testName = "testThumbnailImageDimensions";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            int seriesCount = this.reader.getSeriesCount();
            if (DataTools.indexOf((Object[])this.reader.getDomains(), (Object)"High-Content Screening (HCS)") >= 0) {
                seriesCount = 1;
            }
            for (int i = 0; i < seriesCount && success; ++i) {
                int actualType;
                boolean passType;
                int actualC;
                boolean passC;
                int actualY;
                boolean passY;
                boolean passX;
                this.reader.setSeries(i);
                int x = this.reader.getThumbSizeX();
                int y = this.reader.getThumbSizeY();
                int c = this.reader.getRGBChannelCount();
                int type = this.reader.getPixelType();
                int bytes = FormatTools.getBytesPerPixel((int)type);
                int fx = this.reader.getSizeX();
                int fy = this.reader.getSizeY();
                if (c > 4 || type == 6 || type == 7 || !TestTools.canFitInMemory((long)fx * (long)fy * (long)c * (long)bytes)) continue;
                BufferedImage b = null;
                try {
                    b = this.reader.openThumbImage(0);
                }
                catch (Throwable e) {
                    if (TestTools.isOutOfMemory(e)) {
                        FormatReaderTest.result(testName, true, "Image too large");
                        return;
                    }
                    throw e;
                }
                int actualX = b.getWidth();
                boolean bl = passX = x == actualX;
                if (!passX) {
                    msg = "series #" + i + ": X: was " + actualX + ", expected " + x;
                }
                boolean bl2 = passY = y == (actualY = b.getHeight());
                if (!passY) {
                    msg = "series #" + i + ": Y: was " + actualY + ", expected " + y;
                }
                boolean bl3 = passC = c == (actualC = b.getRaster().getNumBands());
                if (!passC) {
                    msg = "series #" + i + ": C: was " + actualC + ", expected < " + c;
                }
                boolean bl4 = passType = type == (actualType = AWTImageTools.getPixelType((BufferedImage)b));
                if (!passType && actualType == 3 && type == 2) {
                    passType = true;
                }
                if (!passType) {
                    msg = "series #" + i + ": type: was " + actualType + ", expected " + type;
                }
                success = passX && passY && passC && passType;
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testThumbnailByteArrayDimensions() {
        String testName = "testThumbnailByteArrayDimensions";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                int x = this.reader.getThumbSizeX();
                int y = this.reader.getThumbSizeY();
                int c = this.reader.getRGBChannelCount();
                int type = this.reader.getPixelType();
                int bytes = FormatTools.getBytesPerPixel((int)type);
                int expected = x * y * c * bytes;
                int fx = this.reader.getSizeX();
                int fy = this.reader.getSizeY();
                if (c > 4 || type == 6 || type == 7 || !TestTools.canFitInMemory((long)fx * (long)fy * (long)c * (long)bytes * 20L)) continue;
                byte[] b = null;
                try {
                    b = this.reader.openThumbBytes(0);
                }
                catch (Throwable e) {
                    if (TestTools.isOutOfMemory(e)) {
                        FormatReaderTest.result(testName, true, "Image too large");
                        return;
                    }
                    throw e;
                }
                boolean bl = success = b.length == expected;
                if (success) continue;
                msg = "series #" + i + ": was " + b.length + ", expected " + expected;
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testImageCount() {
        String testName = "testImageCount";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                int imageCount = this.reader.getImageCount();
                int z = this.reader.getSizeZ();
                int c = this.reader.getEffectiveSizeC();
                int t = this.reader.getSizeT();
                success = imageCount == z * c * t;
                msg = "series #" + i + ": imageCount=" + imageCount + ", z=" + z + ", c=" + c + ", t=" + t;
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testTileWidth() {
        String testName = "testTileWidth";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                int width = this.reader.getOptimalTileWidth();
                success = width > 0;
                msg = "series #" + i + ": tile width = " + width;
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testTileHeight() {
        String testName = "testTileHeight";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                int height = this.reader.getOptimalTileHeight();
                success = height > 0;
                msg = "series #" + i + ": tile height = " + height;
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "xml", "fast", "automated"})
    public void testOMEXML() {
        String testName = "testOMEXML";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        String msg = null;
        try {
            MetadataRetrieve retrieve = (MetadataRetrieve)this.reader.getMetadataStore();
            boolean success = this.omexmlService.isOMEXMLMetadata((Object)retrieve);
            if (!success) {
                msg = TestTools.shortClassName(retrieve);
            }
            for (int i = 0; i < this.reader.getSeriesCount() && msg == null; ++i) {
                IFormatReader r;
                this.reader.setSeries(i);
                String type = FormatTools.getPixelTypeString((int)this.reader.getPixelType());
                if (this.reader.getSizeX() != ((Integer)retrieve.getPixelsSizeX(i).getValue()).intValue()) {
                    msg = String.format("SizeX (expected %d, actually %d)", this.reader.getSizeX(), (int)((Integer)retrieve.getPixelsSizeX(i).getValue()));
                }
                if (this.reader.getSizeY() != ((Integer)retrieve.getPixelsSizeY(i).getValue()).intValue()) {
                    msg = String.format("SizeY (expected %d, actually %d)", this.reader.getSizeY(), (int)((Integer)retrieve.getPixelsSizeY(i).getValue()));
                }
                if (this.reader.getSizeZ() != ((Integer)retrieve.getPixelsSizeZ(i).getValue()).intValue()) {
                    msg = String.format("SizeZ (expected %d, actually %d)", this.reader.getSizeZ(), (int)((Integer)retrieve.getPixelsSizeZ(i).getValue()));
                }
                if (this.reader.getSizeC() != ((Integer)retrieve.getPixelsSizeC(i).getValue()).intValue()) {
                    msg = String.format("SizeC (expected %d, actually %d)", this.reader.getSizeC(), (int)((Integer)retrieve.getPixelsSizeC(i).getValue()));
                }
                if (this.reader.getSizeT() != ((Integer)retrieve.getPixelsSizeT(i).getValue()).intValue()) {
                    msg = String.format("SizeT (expected %d, actually %d)", this.reader.getSizeT(), (int)((Integer)retrieve.getPixelsSizeT(i).getValue()));
                }
                if ((r = this.reader.unwrap()) instanceof ReaderWrapper) {
                    r = ((ReaderWrapper)r).unwrap();
                }
                if (!(r instanceof OMETiffReader)) {
                    boolean littleEndian = false;
                    if (retrieve.getPixelsBigEndian(i) != null) {
                        littleEndian = retrieve.getPixelsBigEndian(i) == false;
                    } else if (retrieve.getPixelsBinDataCount(i) == 0) {
                        boolean bl = littleEndian = retrieve.getPixelsBinDataBigEndian(i, 0) == false;
                    }
                    if (this.reader.isLittleEndian() != littleEndian) {
                        msg = "BigEndian";
                    }
                }
                if (!this.reader.getDimensionOrder().equals(retrieve.getPixelsDimensionOrder(i).toString())) {
                    msg = "DimensionOrder";
                }
                if (type.equalsIgnoreCase(retrieve.getPixelsType(i).toString())) continue;
                msg = "PixelType";
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            msg = t.getMessage();
        }
        FormatReaderTest.result(testName, msg == null, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testConsistentReader() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testConsistentReader";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        String format = this.config.getReader();
        BufferedImageReader r = this.reader;
        if (r instanceof ImageReader) {
            r = ((ImageReader)r).getReader();
        } else if (r instanceof ReaderWrapper) {
            try {
                r = ((ReaderWrapper)r).unwrap();
            }
            catch (FormatException formatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String realFormat = TestTools.shortClassName(r);
        FormatReaderTest.result(testName, realFormat.equals(format), realFormat);
    }

    @Test(groups={"all", "xml", "automated"})
    public void testSaneOMEXML() {
        String testName = "testSaneOMEXML";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        if (!this.config.hasValidXML()) {
            LOGGER.debug("Skipping valid XML test");
            FormatReaderTest.result(testName, true);
            return;
        }
        String msg = this.checkOMEXML((IFormatReader)this.reader);
        FormatReaderTest.result(testName, msg == null, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"all", "xml", "automated"})
    public void testUnflattenedSaneOMEXML() {
        String testName = "testUnflattenedSaneOMEXML";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        if (!this.config.hasValidXML()) {
            LOGGER.debug("Skipping valid XML test");
            FormatReaderTest.result(testName, true);
            return;
        }
        String msg = null;
        IFormatReader unflattenedReader = null;
        try {
            unflattenedReader = this.setupReader(false, true);
            msg = this.checkOMEXML(unflattenedReader);
        }
        catch (Exception e) {
            msg = e.getMessage();
            LOGGER.debug(testName, (Throwable)e);
        }
        finally {
            try {
                if (unflattenedReader != null) {
                    unflattenedReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("Could not close reader", (Throwable)e);
            }
        }
        FormatReaderTest.result(testName, msg == null, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testSeriesCount() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "SeriesCount";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        FormatReaderTest.result(testName, this.reader.getSeriesCount() == this.config.getSeriesCount(), "got " + this.reader.getSeriesCount() + ", expected " + this.config.getSeriesCount());
    }

    @Test(groups={"all", "fast", "automated"})
    public void testSizeX() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "SizeX";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getSizeX() == this.config.getSizeX()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getSizeX() + ", actual " + this.reader.getSizeX() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testSizeY() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "SizeY";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getSizeY() == this.config.getSizeY()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getSizeY() + ", actual " + this.reader.getSizeY() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testSizeZ() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "SizeZ";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getSizeZ() != this.config.getSizeZ()) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getSizeZ() + ", actual " + this.reader.getSizeZ() + ")");
            }
            Modulo moduloZ = this.reader.getModuloZ();
            int moduloLength = moduloZ.length();
            String type = this.config.getModuloZType();
            Double start = this.config.getModuloZStart();
            Double step = this.config.getModuloZStep();
            Double end = this.config.getModuloZEnd();
            if (!this.isEqual(type, moduloZ.type) && moduloLength > 1) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo type " + type + ", actual " + moduloZ.type + ")");
            }
            if (!(this.isAlmostEqual(start, moduloZ.start) || moduloLength <= 1 && start == null)) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo start " + start + ", actual " + moduloZ.start + ")");
            }
            if (!(this.isAlmostEqual(step, moduloZ.step) || moduloLength <= 1 && step == null)) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo step " + step + ", actual " + moduloZ.step + ")");
            }
            if (this.isAlmostEqual(end, moduloZ.end) || moduloLength <= 1 && end == null) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo end " + end + ", actual " + moduloZ.end + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testSizeC() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "SizeC";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getSizeC() != this.config.getSizeC()) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getSizeC() + ", actual " + this.reader.getSizeC() + ")");
            }
            Modulo moduloC = this.reader.getModuloC();
            int moduloLength = moduloC.length();
            String type = this.config.getModuloCType();
            Double start = this.config.getModuloCStart();
            Double step = this.config.getModuloCStep();
            Double end = this.config.getModuloCEnd();
            if (!this.isEqual(type, moduloC.type) && moduloLength > 1) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo type " + type + ", actual " + moduloC.type + ")");
            }
            if (!(this.isAlmostEqual(start, moduloC.start) || moduloLength <= 1 && start == null)) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo start " + start + ", actual " + moduloC.start + ")");
            }
            if (!(this.isAlmostEqual(step, moduloC.step) || moduloLength <= 1 && step == null)) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo step " + step + ", actual " + moduloC.step + ")");
            }
            if (this.isAlmostEqual(end, moduloC.end) || moduloLength <= 1 && end == null) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo end " + end + ", actual " + moduloC.end + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testSizeT() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "SizeT";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getSizeT() != this.config.getSizeT()) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getSizeT() + ", actual " + this.reader.getSizeT() + ")");
            }
            Modulo moduloT = this.reader.getModuloT();
            int moduloLength = moduloT.length();
            String type = this.config.getModuloTType();
            Double start = this.config.getModuloTStart();
            Double step = this.config.getModuloTStep();
            Double end = this.config.getModuloTEnd();
            if (!this.isEqual(type, moduloT.type) && moduloLength > 1) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo type " + type + ", actual " + moduloT.type + ")");
            }
            if (!(this.isAlmostEqual(start, moduloT.start) || moduloLength <= 1 && start == null)) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo start " + start + ", actual " + moduloT.start + ")");
            }
            if (!(this.isAlmostEqual(step, moduloT.step) || moduloLength <= 1 && step == null)) {
                FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo step " + step + ", actual " + moduloT.step + ")");
            }
            if (this.isAlmostEqual(end, moduloT.end) || moduloLength <= 1 && end == null) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected modulo end " + end + ", actual " + moduloT.end + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testDimensionOrder() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "DimensionOrder";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            String realOrder = this.reader.getDimensionOrder();
            String expectedOrder = this.config.getDimensionOrder();
            if (realOrder.equals(expectedOrder)) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (got " + realOrder + ", expected " + expectedOrder + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testIsInterleaved() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "Interleaved";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.isInterleaved() == this.config.isInterleaved()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.isInterleaved() + ", actual " + this.reader.isInterleaved() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testIndexed() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "Indexed";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.isIndexed() == this.config.isIndexed()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.isIndexed() + ", actual " + this.reader.isIndexed() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testFalseColor() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "FalseColor";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.isFalseColor() == this.config.isFalseColor()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.isFalseColor() + ", actual " + this.reader.isFalseColor() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testRGB() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "RGB";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.isRGB() == this.config.isRGB()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.isRGB() + ", actual " + this.reader.isRGB() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testThumbSizeX() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ThumbSizeX";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getThumbSizeX() == this.config.getThumbSizeX()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getThumbSizeX() + ", actual " + this.reader.getThumbSizeX() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testThumbSizeY() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ThumbSizeY";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getThumbSizeY() == this.config.getThumbSizeY()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getThumbSizeY() + ", actual " + this.reader.getThumbSizeY() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testPixelType() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "PixelType";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getPixelType() == FormatTools.pixelTypeFromString((String)this.config.getPixelType())) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.getPixelType() + ", actual " + FormatTools.getPixelTypeString((int)this.reader.getPixelType()) + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testLittleEndian() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "LittleEndian";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.isLittleEndian() == this.config.isLittleEndian()) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + this.config.isLittleEndian() + ", actual " + this.reader.isLittleEndian() + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    private boolean isEqual(String expected, String real) {
        if (expected == null && real == null) {
            return true;
        }
        if ("null".equals(expected) && real == null) {
            return true;
        }
        if (expected == null) {
            return false;
        }
        return expected.trim().equals(real.trim());
    }

    private boolean isAlmostEqual(Double d1, Double d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        if (d1.isNaN() && d2.isNaN()) {
            return true;
        }
        return Math.abs(d1 - d2) <= 1.0E-6;
    }

    private boolean isAlmostEqual(Quantity q1, Quantity q2) {
        if (q1 == null && q2 == null) {
            return true;
        }
        if (q1 == null || q2 == null) {
            return false;
        }
        if (q1.unit() != q2.unit()) {
            return false;
        }
        return this.isAlmostEqual(q1.value().doubleValue(), q2.value().doubleValue());
    }

    @Test(groups={"all", "fast", "automated"})
    public void testPhysicalSizeX() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "PhysicalSizeX";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            Length expectedSize = this.config.getPhysicalSizeX();
            Length realSize = retrieve.getPixelsPhysicalSizeX(i);
            if (this.isAlmostEqual((Quantity)realSize, (Quantity)expectedSize)) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + expectedSize + ", actual " + realSize + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testPhysicalSizeY() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "PhysicalSizeY";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            Length expectedSize = this.config.getPhysicalSizeY();
            Length realSize = retrieve.getPixelsPhysicalSizeY(i);
            if (this.isAlmostEqual((Quantity)realSize, (Quantity)expectedSize)) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + expectedSize + ", actual " + realSize + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testPhysicalSizeZ() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "PhysicalSizeZ";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            Length expectedSize = this.config.getPhysicalSizeZ();
            Length realSize = retrieve.getPixelsPhysicalSizeZ(i);
            if (this.isAlmostEqual((Quantity)realSize, (Quantity)expectedSize)) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + expectedSize + ", actual " + realSize + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testTimeIncrement() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "TimeIncrement";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            Time expectedIncrement = this.config.getTimeIncrement();
            Time realIncrement = retrieve.getPixelsTimeIncrement(i);
            if (this.isAlmostEqual((Quantity)expectedIncrement, (Quantity)realIncrement)) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (expected " + expectedIncrement + ", actual " + realIncrement + ")");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testLightSources() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "LightSources";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            for (int c = 0; c < this.config.getChannelCount(); ++c) {
                String expectedLightSource = this.config.getLightSource(c);
                String realLightSource = null;
                try {
                    realLightSource = retrieve.getChannelLightSourceSettingsID(i, c);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (expectedLightSource == null && realLightSource == null || (expectedLightSource == null || expectedLightSource.equals(realLightSource)) && (realLightSource == null || realLightSource.equals(expectedLightSource))) continue;
                FormatReaderTest.result(testName, false, "Series " + i + " channel " + c + " (expected " + expectedLightSource + ", actual " + realLightSource + ")");
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testChannelNames() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ChannelNames";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            for (int c = 0; c < this.config.getChannelCount(); ++c) {
                String realName = retrieve.getChannelName(i, c);
                String expectedName = this.config.getChannelName(c);
                if (this.isEqual(expectedName, realName)) continue;
                FormatReaderTest.result(testName, false, "Series " + i + " channel " + c + " (got '" + realName + "', expected '" + expectedName + "')");
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testExposureTimes() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ExposureTimes";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.reader.setSeries(i);
            this.config.setSeries(i);
            if (this.reader.getImageCount() != retrieve.getPlaneCount(i)) continue;
            for (int c = 0; c < this.config.getChannelCount(); ++c) {
                if (!this.config.hasExposureTime(c)) continue;
                Time exposureTime = this.config.getExposureTime(c);
                for (int p = 0; p < this.reader.getImageCount(); ++p) {
                    int[] zct = this.reader.getZCTCoords(p);
                    if (zct[1] != c || p >= retrieve.getPlaneCount(i)) continue;
                    Time planeExposureTime = retrieve.getPlaneExposureTime(i, p);
                    if (exposureTime == null && planeExposureTime == null || exposureTime != null && planeExposureTime != null && exposureTime.equals((Object)planeExposureTime)) continue;
                    FormatReaderTest.result(testName, false, "Series " + i + " plane " + p + " channel " + c + " (got " + planeExposureTime + ", expected " + exposureTime + ")");
                }
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testDeltaT() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "DeltaT";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            boolean bothNotNull;
            this.config.setSeries(i);
            String expectedDate = this.config.getDate();
            String date = null;
            if (retrieve.getImageAcquisitionDate(i) != null) {
                date = (String)retrieve.getImageAcquisitionDate(i).getValue();
            }
            boolean bothNull = date == null && expectedDate == null;
            boolean bl = bothNotNull = date != null && expectedDate != null;
            if (!bothNull && !bothNotNull || bothNotNull && !expectedDate.equals(date)) {
                FormatReaderTest.result(testName, false, "series " + i + " (expected " + expectedDate + ", actual " + date + ")");
                return;
            }
            for (int p = 0; p < this.reader.getImageCount(); ++p) {
                Double seconds;
                Time deltaT = null;
                try {
                    deltaT = retrieve.getPlaneDeltaT(i, p);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                Double expectedDeltaT = this.config.getDeltaT(p);
                if (deltaT == null && expectedDeltaT == null) continue;
                if (deltaT == null) {
                    FormatReaderTest.result(testName, false, "missing series " + i + ", plane " + p);
                    return;
                }
                if (expectedDeltaT == null || !(Math.abs((seconds = Double.valueOf(deltaT.value(UNITS.SECOND).doubleValue())) - expectedDeltaT) > 1.0E-6)) continue;
                FormatReaderTest.result(testName, false, "series " + i + ", plane " + p + " (expected " + expectedDeltaT + ", actual " + seconds + ")");
                return;
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testPlanePositions() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "PlanePositions";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            for (int p = 0; p < this.reader.getImageCount(); ++p) {
                Length posX = null;
                Length posY = null;
                Length posZ = null;
                try {
                    posX = retrieve.getPlanePositionX(i, p);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    posY = retrieve.getPlanePositionY(i, p);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    posZ = retrieve.getPlanePositionZ(i, p);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                Double expectedX = this.config.getPositionX(p);
                Double expectedY = this.config.getPositionY(p);
                Double expectedZ = this.config.getPositionZ(p);
                String expectedXUnit = this.config.getPositionXUnit(p);
                String expectedYUnit = this.config.getPositionYUnit(p);
                String expectedZUnit = this.config.getPositionZUnit(p);
                if (posX != null || expectedX != null) {
                    if (posX == null) {
                        FormatReaderTest.result(testName, false, "missing X position for series " + i + ", plane " + p);
                        return;
                    }
                    if (expectedX != null && expectedXUnit != null) {
                        Double x = posX.value().doubleValue();
                        if (!expectedXUnit.equals(posX.unit().getSymbol())) {
                            FormatReaderTest.result(testName, false, "X position unit series " + i + ", plane " + p + " (expected " + expectedXUnit + ", actual " + posX.unit().getSymbol() + ")");
                            return;
                        }
                        if (Math.abs(x - expectedX) > 1.0E-6) {
                            FormatReaderTest.result(testName, false, "X position series " + i + ", plane " + p + " (expected " + expectedX + ", actual " + x + ")");
                            return;
                        }
                    }
                }
                if (posY != null || expectedY != null) {
                    if (posY == null) {
                        FormatReaderTest.result(testName, false, "missing Y position for series " + i + ", plane " + p);
                        return;
                    }
                    if (expectedY != null && expectedYUnit != null) {
                        Double y = posY.value().doubleValue();
                        if (!expectedYUnit.equals(posY.unit().getSymbol())) {
                            FormatReaderTest.result(testName, false, "Y position unit series " + i + ", plane " + p + " (expected " + expectedYUnit + ", actual " + posY.unit().getSymbol() + ")");
                            return;
                        }
                        if (Math.abs(y - expectedY) > 1.0E-6) {
                            FormatReaderTest.result(testName, false, "Y position series " + i + ", plane " + p + " (expected " + expectedY + ", actual " + y + ")");
                            return;
                        }
                    }
                }
                if (posZ == null && expectedZ == null) continue;
                if (posZ == null) {
                    FormatReaderTest.result(testName, false, "missing Z position for series " + i + ", plane " + p);
                    return;
                }
                if (expectedZ == null || expectedZUnit == null) continue;
                Double z = posZ.value().doubleValue();
                if (!expectedZUnit.equals(posZ.unit().getSymbol())) {
                    FormatReaderTest.result(testName, false, "Z position unit series " + i + ", plane " + p + " (expected " + expectedZUnit + ", actual " + posZ.unit().getSymbol() + ")");
                    return;
                }
                if (!(Math.abs(z - expectedZ) > 1.0E-6)) continue;
                FormatReaderTest.result(testName, false, "Z position series " + i + ", plane " + p + " (expected " + expectedZ + ", actual " + z + ")");
                return;
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testEmissionWavelengths() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "EmissionWavelengths";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            for (int c = 0; c < this.config.getChannelCount(); ++c) {
                Length realWavelength = retrieve.getChannelEmissionWavelength(i, c);
                Length expectedWavelength = this.config.getEmissionWavelength(c);
                if (realWavelength == null && expectedWavelength == null || this.isAlmostEqual((Quantity)expectedWavelength, (Quantity)realWavelength)) continue;
                FormatReaderTest.result(testName, false, "Series " + i + " channel " + c + " (expected " + expectedWavelength + ", actual " + realWavelength + ")");
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testExcitationWavelengths() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ExcitationWavelengths";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            for (int c = 0; c < this.config.getChannelCount(); ++c) {
                Length realWavelength = retrieve.getChannelExcitationWavelength(i, c);
                Length expectedWavelength = this.config.getExcitationWavelength(c);
                if (this.isAlmostEqual((Quantity)expectedWavelength, (Quantity)realWavelength)) continue;
                FormatReaderTest.result(testName, false, "Series " + i + " channel " + c + " (expected " + expectedWavelength + ", actual " + realWavelength + ")");
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testDetectors() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "Detectors";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            for (int c = 0; c < this.config.getChannelCount(); ++c) {
                String expectedDetector = this.config.getDetector(c);
                String realDetector = null;
                try {
                    realDetector = retrieve.getDetectorSettingsID(i, c);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (expectedDetector == null && realDetector == null || expectedDetector != null && expectedDetector.equals(realDetector) || realDetector != null && realDetector.equals(expectedDetector)) continue;
                FormatReaderTest.result(testName, false, "Series " + i + " channel " + c + " (expected " + expectedDetector + ", actual " + realDetector + ")");
            }
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testImageNames() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ImageNames";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            String realName = retrieve.getImageName(i);
            String expectedName = this.config.getImageName();
            if (this.isEqual(expectedName, realName)) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (got '" + realName + "', expected '" + expectedName + "')");
        }
        FormatReaderTest.result(testName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"all", "fast", "automated"})
    public void testUnflattenedImageNames() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testUnflattenedImageNames";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        IFormatReader resolutionReader = this.setupReader(false, true);
        try {
            IMetadata retrieve = (IMetadata)resolutionReader.getMetadataStore();
            if (resolutionReader.getSeriesCount() != this.config.getSeriesCount(false)) {
                success = false;
                msg = "incorrect unflattened series count";
            }
            for (int i = 0; i < resolutionReader.getSeriesCount() && success; ++i) {
                String unflattenedName;
                this.config.setSeries(i, false);
                String realName = retrieve.getImageName(i);
                String expectedName = this.config.getImageName();
                if (this.isEqual(expectedName, realName) || this.isEqual(unflattenedName = this.config.getUnflattenedImageName(), realName)) continue;
                msg = "Series " + i + " (got '" + realName + "', expected '" + expectedName + "' or '" + unflattenedName + "')";
                success = false;
            }
        }
        finally {
            try {
                resolutionReader.close();
            }
            catch (IOException e) {
                success = false;
                msg = "Could not close reader";
            }
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testImageDescriptions() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "ImageDescriptions";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            this.config.setSeries(i);
            String realDescription = retrieve.getImageDescription(i);
            if (realDescription != null) {
                realDescription = realDescription.trim();
            }
            if (!this.config.hasImageDescription()) continue;
            String expectedDescription = this.config.getImageDescription();
            if (expectedDescription != null) {
                expectedDescription = expectedDescription.trim();
            }
            if (expectedDescription.equals(realDescription) || realDescription == null && expectedDescription.equals("null")) continue;
            FormatReaderTest.result(testName, false, "Series " + i + " (got '" + realDescription + "', expected '" + expectedDescription + "')");
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testHCSMetadata() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "HCS";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        IMetadata retrieve = (IMetadata)this.reader.getMetadataStore();
        for (int s = 0; s < this.reader.getSeriesCount(); ++s) {
            int p;
            this.config.setSeries(s);
            String failureSuffix = " incorrect for series " + s;
            int plate = this.config.getPlate();
            if (plate >= retrieve.getPlateCount()) {
                FormatReaderTest.result(testName, false, "Plate index" + failureSuffix);
            } else if (plate < -1) {
                if (retrieve.getPlateCount() <= 0) continue;
                boolean allEmpty = true;
                for (p = 0; p < retrieve.getPlateCount(); ++p) {
                    if (retrieve.getWellCount(p) <= 0) continue;
                    boolean emptyWell = true;
                    for (int w = 0; w < retrieve.getWellCount(p); ++w) {
                        if (retrieve.getWellSampleCount(p, w) <= 0) continue;
                        emptyWell = false;
                        break;
                    }
                    if (emptyWell) break;
                    allEmpty = false;
                    break;
                }
                if (allEmpty) continue;
                FormatReaderTest.result(testName, false, "Plate index" + failureSuffix);
                continue;
            }
            boolean foundWell = false;
            block3: for (p = 0; p < retrieve.getPlateCount(); ++p) {
                if (plate >= 0 && plate != p) continue;
                for (int w = 0; w < retrieve.getWellCount(p); ++w) {
                    int row = this.config.getWellRow();
                    int col = this.config.getWellColumn();
                    if (row == retrieve.getWellRow(p, w).getNumberValue().intValue() && col == retrieve.getWellColumn(p, w).getNumberValue().intValue()) {
                        String wellSampleID;
                        int plateAcqCount;
                        int plateAcq;
                        foundWell = true;
                        int wellSample = this.config.getWellSample();
                        String image = retrieve.getImageID(s);
                        if (wellSample >= retrieve.getWellSampleCount(p, w) || wellSample < 0 || !image.equals(retrieve.getWellSampleImageRef(p, w, wellSample))) {
                            FormatReaderTest.result(testName, false, "WellSample index" + failureSuffix);
                        }
                        Length positionX = retrieve.getWellSamplePositionX(p, w, wellSample);
                        Length positionY = retrieve.getWellSamplePositionY(p, w, wellSample);
                        Length configX = this.config.getWellSamplePositionX();
                        Length configY = this.config.getWellSamplePositionY();
                        if (!(positionX == null && configX == null || positionX != null && positionX.equals((Object)configX))) {
                            FormatReaderTest.result(testName, false, "WellSample position X" + failureSuffix);
                        }
                        if (!(positionY == null && configY == null || positionY != null && positionY.equals((Object)configY))) {
                            FormatReaderTest.result(testName, false, "WellSample position Y" + failureSuffix);
                        }
                        if ((plateAcq = this.config.getPlateAcquisition()) >= (plateAcqCount = retrieve.getPlateAcquisitionCount(p))) {
                            FormatReaderTest.result(testName, false, "PlateAcquisition index" + failureSuffix);
                        } else if (plateAcq < 0 && plateAcqCount > 0) {
                            wellSampleID = retrieve.getWellSampleID(p, w, wellSample);
                            for (int pa = 0; pa < plateAcqCount; ++pa) {
                                int wsCount = retrieve.getWellSampleRefCount(p, pa);
                                for (int wsRef = 0; wsRef < wsCount; ++wsRef) {
                                    String wellSampleRef = retrieve.getPlateAcquisitionWellSampleRef(p, pa, wsRef);
                                    if (!wellSampleID.equals(wellSampleRef)) continue;
                                    FormatReaderTest.result(testName, false, "PlateAcquisition-WellSample link" + failureSuffix);
                                }
                            }
                        } else if (plateAcq >= 0 && plateAcqCount > 0) {
                            wellSampleID = retrieve.getWellSampleID(p, w, wellSample);
                            boolean foundWellSampleRef = false;
                            for (int wsRef = 0; wsRef < retrieve.getWellSampleRefCount(p, plateAcq); ++wsRef) {
                                String wellSampleRef = retrieve.getPlateAcquisitionWellSampleRef(p, plateAcq, wsRef);
                                if (!wellSampleID.equals(wellSampleRef)) continue;
                                foundWellSampleRef = true;
                                break;
                            }
                            if (!foundWellSampleRef) {
                                FormatReaderTest.result(testName, false, "PlateAcquisition missing WellSampleRef" + failureSuffix);
                            }
                        }
                    }
                    if (foundWell) continue block3;
                }
            }
            if (foundWell || plate < 0) continue;
            FormatReaderTest.result(testName, false, "Well indexes" + failureSuffix);
        }
        FormatReaderTest.result(testName, true);
    }

    @Test(groups={"all", "xml", "automated"})
    public void testEqualOMEXML() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testEqualOMEXML";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            MetadataStore store = this.reader.getMetadataStore();
            success = this.omexmlService.isOMEXMLMetadata((Object)store);
            if (!success) {
                msg = TestTools.shortClassName(store);
            }
            String file = this.reader.getCurrentFile() + ".ome.xml";
            if (success) {
                String dir;
                if (!new File(file).exists() && this.omexmlDir != null && new File(this.omexmlDir).exists() && (dir = System.getProperty("testng.directory")) != null && !new File(file = this.reader.getCurrentFile().replace(dir, this.omexmlDir) + ".ome.xml").exists()) {
                    file = this.reader.getCurrentFile().replace(dir, this.omexmlDir);
                    file = file.substring(0, file.lastIndexOf(".")) + ".ome.xml";
                }
                if (new File(file).exists()) {
                    String xml = DataTools.readFile((String)file);
                    OMEXMLMetadata base = this.omexmlService.createOMEXMLMetadata(xml);
                    success = this.omexmlService.isEqual(base, (OMEXMLMetadata)store);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            msg = t.getMessage();
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all"})
    public void testPerformance() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testPerformance";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            int properMem = this.config.getMemory();
            double properTime = this.config.getAccessTimeMillis();
            if (properMem <= 0 || properTime <= 0.0) {
                success = true;
                msg = "no configuration";
            } else {
                Runtime r = Runtime.getRuntime();
                System.gc();
                Thread.sleep(1000L);
                System.gc();
                long m1 = r.totalMemory() - r.freeMemory();
                long t1 = System.currentTimeMillis();
                int totalPlanes = 0;
                int seriesCount = this.reader.getSeriesCount();
                for (int i = 0; i < seriesCount; ++i) {
                    this.reader.setSeries(i);
                    int imageCount = this.reader.getImageCount();
                    totalPlanes += imageCount;
                    int planeSize = FormatTools.getPlaneSize((IFormatReader)this.reader);
                    if (planeSize < 0) continue;
                    byte[] buf = new byte[planeSize];
                    for (int j = 0; j < imageCount; ++j) {
                        try {
                            this.reader.openBytes(j, buf);
                            continue;
                        }
                        catch (FormatException e) {
                            LOGGER.info("", (Throwable)e);
                            continue;
                        }
                        catch (IOException e) {
                            LOGGER.info("", (Throwable)e);
                            continue;
                        }
                        catch (Throwable e) {
                            if (TestTools.isOutOfMemory(e)) {
                                FormatReaderTest.result(testName, true, "Image too large");
                                return;
                            }
                            throw e;
                        }
                    }
                }
                long t2 = System.currentTimeMillis();
                System.gc();
                Thread.sleep(1000L);
                System.gc();
                long m2 = r.totalMemory() - r.freeMemory();
                double actualTime = (double)(t2 - t1) / (double)totalPlanes;
                int actualMem = (int)(m2 - m1 >> 20);
                if (actualTime - (double)this.timeMultiplier * properTime > 250.0) {
                    success = false;
                    msg = "got " + actualTime + " ms, expected " + properTime + " ms";
                } else if (actualMem > properMem + 20) {
                    success = false;
                    msg = "used " + actualMem + " MB; expected <= " + properMem + " MB";
                }
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"all", "type", "automated"})
    public void testRequiredDirectories() {
        if (!this.initFile()) {
            return;
        }
        if (this.reader.getFormat().startsWith("CellH5")) {
            throw new SkipException(SKIP_MESSAGE);
        }
        String testName = "testRequiredDirectories";
        String file = this.reader.getCurrentFile();
        LOGGER.debug("testRequiredDirectories({})", (Object)file);
        int directories = -1;
        try {
            directories = this.reader.getRequiredDirectories(this.reader.getUsedFiles());
        }
        catch (Exception e) {
            LOGGER.warn("Could not retrieve directory count", (Throwable)e);
        }
        LOGGER.debug("directories = {}", (Object)directories);
        if (directories < 0) {
            FormatReaderTest.result(testName, false, "Invalid directory count (" + directories + ")");
        } else {
            String[] usedFiles = this.reader.getUsedFiles();
            String[] newFiles = new String[usedFiles.length];
            String commonParent = new Location(usedFiles[0]).getAbsoluteFile().getParent();
            for (int i = 1; i < usedFiles.length; ++i) {
                while (!usedFiles[i].startsWith(commonParent)) {
                    commonParent = commonParent.substring(0, commonParent.lastIndexOf(File.separator));
                }
            }
            LOGGER.debug("commonParent = {}", (Object)commonParent);
            String split = File.separatorChar == '\\' ? "\\\\" : File.separator;
            LOGGER.debug("split = {}", (Object)split);
            String[] f = commonParent.split(split);
            StringBuilder toRemove = new StringBuilder();
            for (int i = 0; i < f.length - directories - 1; ++i) {
                toRemove.append(f[i]);
                if (i >= f.length - directories - 2) continue;
                toRemove.append(split);
            }
            String newFile = null;
            for (int i = 0; i < usedFiles.length; ++i) {
                newFiles[i] = usedFiles[i].replace(toRemove.toString(), "");
                LOGGER.debug("mapping {} to {}", (Object)newFiles[i], (Object)usedFiles[i]);
                Location.mapId((String)newFiles[i], (String)usedFiles[i]);
                if (!usedFiles[i].equals(file)) continue;
                newFile = newFiles[i];
            }
            if (newFile == null) {
                newFile = newFiles[0];
            }
            LOGGER.debug("newFile = {}", (Object)newFile);
            ImageReader check = new ImageReader();
            check.setMetadataOptions((MetadataOptions)new DynamicMetadataOptions());
            try {
                check.setId(newFile);
                int nFiles = check.getUsedFiles().length;
                FormatReaderTest.result(testName, nFiles == usedFiles.length, "Found " + nFiles + "; expected " + usedFiles.length);
            }
            catch (Exception e) {
                LOGGER.info("Initialization failed", (Throwable)e);
                FormatReaderTest.result(testName, false, e.getMessage());
            }
            finally {
                try {
                    check.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not close reader", (Throwable)e);
                }
                for (int i = 0; i < newFiles.length; ++i) {
                    Location.mapId((String)newFiles[i], null);
                }
            }
        }
    }

    @Test(groups={"all", "type", "automated"})
    public void testSaneUsedFiles() {
        if (!this.initFile()) {
            return;
        }
        String file = this.reader.getCurrentFile();
        String testName = "testSaneUsedFiles";
        boolean success = true;
        String msg = null;
        try {
            Object[] base = this.reader.getUsedFiles();
            HashSet uniqueFiles = new HashSet();
            Collections.addAll(uniqueFiles, base);
            if (uniqueFiles.size() < base.length) {
                success = false;
                msg = "Used files list contains duplicates";
            }
            if (!(this.reader.getFormat().equals("Bio-Rad PIC") || this.reader.getFormat().equals("Metamorph STK") || this.reader.getFormat().equals("Evotec Flex") || this.reader.getFormat().equals("PerkinElmer") || this.reader.getFormat().equals("Micro-Manager") || this.reader.getFormat().equals("BDV") || this.reader.getFormat().equals("Zeiss AxioVision TIFF") || ((String)base[0]).equals(file))) {
                success = false;
                msg = "Used files list does not start with getCurrentFile";
            }
            if (success) {
                Arrays.sort(base);
                ImageReader r = new ImageReader();
                int maxFiles = Math.min(base.length, 100);
                if (DataTools.indexOf((Object[])this.reader.getDomains(), (Object)"High-Content Screening (HCS)") >= 0 || file.toLowerCase().endsWith(".czi")) {
                    maxFiles = Math.min(maxFiles, 10);
                }
                for (int i = 0; i < maxFiles && success; ++i) {
                    if (this.reader.getFormat().equals("InCell 1000/2000") && !((String)base[i]).toLowerCase().endsWith(".xdce") && !((String)base[i]).toLowerCase().endsWith(".xml") || ((String)base[i]).toLowerCase().endsWith(".bfoptions") || this.reader.getFormat().equals("Molecular Devices JDCE") && !((String)base[i]).toLowerCase().endsWith(".jdce") || this.reader.getFormat().equals("PerkinElmer Operetta") || file.toLowerCase().endsWith(".mvd2") && !((String)base[i]).toLowerCase().endsWith(".mvd2") || (file.toLowerCase().endsWith("fid") || file.toLowerCase().endsWith("acqp")) && !((String)base[i]).toLowerCase().endsWith("fid") && !((String)base[i]).toLowerCase().endsWith("acqp") && this.reader.getFormat().equals("Bruker") || this.reader.getFormat().equals("Olympus APL") && ((String)base[i]).toLowerCase().endsWith("tif") || this.reader.getFormat().equals("Micro-Manager") && (((String)base[i]).toLowerCase().endsWith(".ome.tiff") || ((String)base[i]).toLowerCase().endsWith(".ome.tif")) || this.reader.getFormat().equals("DICOM") && !((String)base[i]).equals(file) || this.reader.getFormat().equals("QuickTime") && !((String)base[i]).equals(file) || this.reader.getFormat().equals("Aperio AFI") && ((String)base[i]).toLowerCase().endsWith(".svs") || this.reader.getFormat().equals("BD Pathway") && (((String)base[i]).endsWith(".adf") || ((String)base[i]).endsWith(".txt")) || ((String)base[i]).endsWith(".roi") || this.reader.getFormat().equals("Hamamatsu VMS") && !((String)base[i]).toLowerCase().endsWith(".vms") || this.reader.getFormat().equals("CellVoyager") || this.reader.getFormat().equals("Leica Image File Format") || this.reader.getFormat().equals("Inveon") || this.reader.getFormat().equals("File pattern") || this.reader.getFormat().equals("MicroCT") && !((String)base[i]).toLowerCase().endsWith(".vff") || this.reader.getFormat().equals("Image-Pro Sequence") && file.toLowerCase().endsWith(".ips") || this.reader.getFormat().equals("Yokogawa CV7000") || this.reader.getFormat().equals("CellWorx") || this.reader.getFormat().equals("MetaXpress TIFF") || file.toLowerCase().endsWith(".nhdr") || ((String)base[i]).toLowerCase().endsWith(".nhdr") || this.reader.getFormat().equals("OME-TIFF") && file.toLowerCase().endsWith(".companion.ome") && !OMETiffReader.checkSuffix((String)base[i], (String[])OMETiffReader.OME_TIFF_SUFFIXES) || this.reader.getFormat().equals("Cellomics C01") && ((String)base[i]).toLowerCase().endsWith(".mdb") || this.reader.getFormat().equals("TissueFAXS") && !((String)base[i]).toLowerCase().endsWith(".aqproj") || this.reader.getFormat().equals("Tecan Spark Cyto") && !((String)base[i]).toLowerCase().endsWith(".db") || this.reader.getFormat().equals("Olympus .omp2info") && !((String)base[i]).toLowerCase().endsWith(".omp2info") || this.reader.getFormat().equals("CellSens VSI") && (!((String)base[i]).toLowerCase().endsWith(".vsi") && !((String)base[i]).toLowerCase().endsWith(".ets") || ((String)base[i]).toLowerCase().endsWith(".ets") && !((String)base[i]).toLowerCase().startsWith("frame")) || this.reader.getFormat().equals("Extended leica file") && (((String)base[i]).toLowerCase().endsWith("xlif") || ((String)base[i]).toLowerCase().endsWith("lof") || ((String)base[i]).toLowerCase().endsWith("xlcf") || ((String)base[i]).toLowerCase().endsWith("jpeg") || ((String)base[i]).toLowerCase().endsWith("tif") || ((String)base[i]).toLowerCase().endsWith("tiff") || ((String)base[i]).toLowerCase().endsWith("bmp") || ((String)base[i]).toLowerCase().endsWith("jpg") || ((String)base[i]).toLowerCase().endsWith("png"))) continue;
                    r.setId((String)base[i]);
                    Object[] comp = r.getUsedFiles();
                    if (((String)base[i]).toLowerCase().endsWith(".lsm") && comp.length == 1) {
                        r.close();
                        continue;
                    }
                    if (file.toLowerCase().endsWith(".dv") && ((String)base[i]).toLowerCase().endsWith(".log")) {
                        r.close();
                        continue;
                    }
                    if (this.reader.getFormat().equals("Hitachi")) {
                        r.close();
                        continue;
                    }
                    if (this.reader.getFormat().equals("Trestle")) {
                        r.close();
                        continue;
                    }
                    if (this.reader.getFormat().equals("Olympus APL") && ((String)base[i]).toLowerCase().endsWith(".tif")) {
                        r.close();
                        continue;
                    }
                    if (this.reader.getFormat().equals("Li-Cor L2D") && !((String)base[i]).toLowerCase().endsWith("l2d")) {
                        r.close();
                        continue;
                    }
                    if (this.reader.getFormat().equals("Prairie TIFF") && ((String)base[i]).toLowerCase().endsWith(".tif") && r.getFormat().equals("OME-TIFF")) {
                        r.close();
                        continue;
                    }
                    if (this.reader.getFormat().equals("Hamamatsu NDPIS") && r.getFormat().equals("Hamamatsu NDPI")) {
                        r.close();
                        continue;
                    }
                    if (((String)base[i]).endsWith(".bmp") && this.reader.getFormat().equals("BD Pathway")) {
                        r.close();
                        continue;
                    }
                    if (comp.length != base.length) {
                        success = false;
                        msg = (String)base[i] + " (file list length was " + comp.length + "; expected " + base.length + ")";
                    }
                    if (success) {
                        Arrays.sort(comp);
                    }
                    for (int j = 0; j < comp.length && success; ++j) {
                        if (((String)comp[j]).equals(base[j]) || ((String)base[j]).equals(new Location((String)comp[j]).getCanonicalPath())) continue;
                        success = false;
                        msg = (String)base[i] + "(file @ " + j + " was '" + (String)comp[j] + "', expected '" + (String)base[j] + "')";
                    }
                    r.close();
                }
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"all", "xml", "fast", "automated"})
    public void testValidXML() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testValidXML";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        if (!this.config.hasValidXML()) {
            LOGGER.debug("Skipping valid XML test");
            FormatReaderTest.result(testName, true);
            return;
        }
        String format = this.config.getReader();
        boolean success = true;
        try {
            MetadataStore store = this.reader.getMetadataStore();
            MetadataRetrieve retrieve = this.omexmlService.asRetrieve(store);
            String xml = this.omexmlService.getOMEXML(retrieve);
            ConfigurationTree configurationTree = configTree;
            synchronized (configurationTree) {
                success = xml != null && this.omexmlService.validateOMEXML(xml);
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success);
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.info("", (Throwable)e);
        }
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testUnflattenedPixelsHashes() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testUnflattenedPixelsHashes";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            IFormatReader resolutionReader = this.setupReader(false, true);
            if (resolutionReader.getSeriesCount() != this.config.getSeriesCount(false)) {
                success = false;
                msg = "incorrect unflattened series count";
            }
            for (int i = 0; i < resolutionReader.getSeriesCount() && success; ++i) {
                resolutionReader.setSeries(i);
                Assert.assertEquals((int)resolutionReader.getSeries(), (int)i);
                for (int r = 0; r < resolutionReader.getResolutionCount() && success; ++r) {
                    resolutionReader.setResolution(r);
                    Assert.assertEquals((int)resolutionReader.getResolution(), (int)r);
                    try {
                        this.config.setResolution(i, r);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.config.setSeries(resolutionReader.getCoreIndex());
                    }
                    long planeSize = -1L;
                    try {
                        planeSize = DataTools.safeMultiply32((int[])new int[]{resolutionReader.getSizeX(), resolutionReader.getSizeY(), resolutionReader.getRGBChannelCount(), FormatTools.getBytesPerPixel((int)resolutionReader.getPixelType())});
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    if (planeSize < 0L || !TestTools.canFitInMemory(planeSize)) continue;
                    String md5 = TestTools.md5(resolutionReader.openBytes(0));
                    String expected1 = this.config.getMD5();
                    String expected2 = this.config.getAlternateMD5();
                    if (expected1 == null && expected2 == null || md5.equals(expected1) || md5.equals(expected2)) continue;
                    success = false;
                    msg = "series " + i + ", resolution " + r;
                }
            }
            resolutionReader.close();
        }
        catch (Throwable t) {
            if (TestTools.isOutOfMemory(t)) {
                FormatReaderTest.result(testName, true, "Image too large");
                return;
            }
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testPixelsHashes() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testPixelsHashes";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                this.config.setSeries(i);
                long planeSize = -1L;
                try {
                    planeSize = DataTools.safeMultiply32((int[])new int[]{this.reader.getSizeX(), this.reader.getSizeY(), this.reader.getEffectiveSizeC(), this.reader.getRGBChannelCount(), FormatTools.getBytesPerPixel((int)this.reader.getPixelType())});
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (planeSize <= 0L || !TestTools.canFitInMemory(planeSize)) continue;
                String md5 = TestTools.md5(this.reader.openBytes(0));
                String expected1 = this.config.getMD5();
                String expected2 = this.config.getAlternateMD5();
                if (expected1 == null && expected2 == null || md5.equals(expected1) || md5.equals(expected2)) continue;
                success = false;
                msg = "series " + i + ", md5 " + md5 + ", expected " + expected1 + " or " + expected2;
            }
        }
        catch (Throwable t) {
            if (TestTools.isOutOfMemory(t)) {
                FormatReaderTest.result(testName, true, "Image too large");
                return;
            }
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testUnflattenedSubimagePixelsHashes() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testUnflattenedSubimagePixelsHashes";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            IFormatReader resolutionReader = this.setupReader(false, true);
            if (resolutionReader.getSeriesCount() != this.config.getSeriesCount(false)) {
                success = false;
                msg = "incorrect unflattened series count";
            }
            for (int i = 0; i < resolutionReader.getSeriesCount() && success; ++i) {
                resolutionReader.setSeries(i);
                Assert.assertEquals((int)resolutionReader.getSeries(), (int)i);
                for (int r = 0; r < resolutionReader.getResolutionCount() && success; ++r) {
                    resolutionReader.setResolution(r);
                    Assert.assertEquals((int)resolutionReader.getResolution(), (int)r);
                    try {
                        this.config.setResolution(i, r);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.config.setSeries(resolutionReader.getCoreIndex());
                    }
                    int w = Math.min(512, resolutionReader.getSizeX());
                    int h = Math.min(512, resolutionReader.getSizeY());
                    String expected1 = this.config.getTileMD5();
                    String expected2 = this.config.getTileAlternateMD5();
                    String md5 = null;
                    try {
                        md5 = TestTools.md5(resolutionReader.openBytes(0, 0, 0, w, h));
                    }
                    catch (Throwable e) {
                        if (TestTools.isOutOfMemory(e)) {
                            FormatReaderTest.result(testName, true, "Image too large");
                            return;
                        }
                        LOGGER.warn("", e);
                    }
                    if (md5 == null && expected1 == null && expected2 == null) {
                        success = true;
                        continue;
                    }
                    if (md5.equals(expected1) || md5.equals(expected2) || expected1 == null && expected2 == null) continue;
                    success = false;
                    msg = "series " + i + ", resolution " + r + ", md5 " + md5 + ", expected " + expected1 + " or " + expected2;
                }
            }
            resolutionReader.close();
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "pixels", "automated"})
    public void testSubimagePixelsHashes() {
        if (this.config == null) {
            throw new SkipException("No config tree");
        }
        String testName = "testSubimagePixelsHashes";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            for (int i = 0; i < this.reader.getSeriesCount() && success; ++i) {
                this.reader.setSeries(i);
                this.config.setSeries(i);
                int w = Math.min(512, this.reader.getSizeX());
                int h = Math.min(512, this.reader.getSizeY());
                String expected1 = this.config.getTileMD5();
                String expected2 = this.config.getTileAlternateMD5();
                String md5 = null;
                try {
                    md5 = TestTools.md5(this.reader.openBytes(0, 0, 0, w, h));
                }
                catch (Throwable e) {
                    if (TestTools.isOutOfMemory(e)) {
                        FormatReaderTest.result(testName, true, "Image too large");
                        return;
                    }
                    throw e;
                }
                if (md5 == null && expected1 == null && expected2 == null) {
                    success = true;
                    continue;
                }
                if (md5.equals(expected1) || md5.equals(expected2) || expected1 == null && expected2 == null) continue;
                success = false;
                msg = "series " + i + ", md5 " + md5 + ", expected " + expected1 + " or " + expected2;
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testIsThisTypeConsistent() {
        boolean isThisTypeNotOpen;
        String file;
        boolean isThisTypeOpen;
        String testName = "testIsThisTypeConsistent";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        FormatReaderTest.result(testName, (isThisTypeOpen = this.reader.isThisType(file = this.reader.getCurrentFile(), true)) == (isThisTypeNotOpen = this.reader.isThisType(file, false)) || isThisTypeOpen && !isThisTypeNotOpen, "open = " + isThisTypeOpen + ", !open = " + isThisTypeNotOpen);
    }

    @Test(groups={"all", "fast", "automated"})
    public void testIsThisType() {
        String testName = "testIsThisType";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        boolean success = true;
        String msg = null;
        try {
            BufferedImageReader r = this.reader;
            while (r instanceof ReaderWrapper) {
                r = ((ReaderWrapper)r).getReader();
            }
            if (r instanceof ImageReader) {
                ImageReader ir = (ImageReader)r;
                r = ir.getReader();
                IFormatReader[] readers = ir.getReaders();
                String[] used = this.reader.getUsedFiles();
                block3: for (int i = 0; i < used.length && success; ++i) {
                    if (!used[i].toLowerCase().endsWith(".wpi") && r instanceof CV7000Reader || !used[i].toLowerCase().endsWith(".pattern") && r instanceof FilePatternReader || !used[i].toLowerCase().endsWith(".lif") && r instanceof LIFReader || !used[i].toLowerCase().endsWith(".vff") && r instanceof MicroCTReader || !used[i].toLowerCase().endsWith(".htd") && r instanceof CellWorxReader || used[i].toLowerCase().endsWith(".mdb") && r instanceof CellomicsReader) continue;
                    for (int j = 0; j < readers.length; ++j) {
                        boolean expected;
                        boolean result;
                        if (r instanceof AFIReader && (readers[j] instanceof AFIReader || readers[j] instanceof SVSReader) || (readers[j] instanceof NDPISReader || r instanceof NDPISReader) && used[i].toLowerCase().endsWith(".ndpi") || readers[j] instanceof JPEGReader && r instanceof HamamatsuVMSReader && used[i].toLowerCase().endsWith(".jpg") || !(result = readers[j].isThisType(used[i])) && used[i].toLowerCase().endsWith(".bfoptions") || !result && readers[j] instanceof OMETiffReader && r.getCurrentFile().toLowerCase().endsWith(".companion.ome") && !OMETiffReader.checkSuffix((String)used[i], (String[])OMETiffReader.OME_TIFF_SUFFIXES) || result && readers[j] instanceof TiffDelegateReader || r instanceof NRRDReader && !used[i].toLowerCase().endsWith(".nhdr") && !used[i].toLowerCase().endsWith(".nrrd") || result && readers[j] instanceof NRRDReader || result && r instanceof NiftiReader && readers[j] instanceof AnalyzeReader || result && r instanceof MetamorphReader && readers[j] instanceof MetamorphTiffReader || result && readers[j] instanceof L2DReader || r instanceof L2DReader && readers[j] instanceof GelReader || readers[j] instanceof L2DReader || result && r instanceof JPEG2000Reader && readers[j] instanceof ND2Reader || result && r instanceof APLReader && readers[j] instanceof SISReader || !result && r instanceof APLReader && readers[j] instanceof APLReader || result && r instanceof PrairieReader && readers[j] instanceof OMETiffReader || result && r instanceof ColumbusReader && (readers[j] instanceof OMETiffReader || readers[j] instanceof FlexReader) || result && r instanceof MicromanagerReader && readers[j] instanceof OMETiffReader || !result && r instanceof MicromanagerReader && readers[j] instanceof MicromanagerReader && (used[i].toLowerCase().endsWith(".ome.tif") || used[i].toLowerCase().endsWith(".ome.tiff")) || result && r instanceof TrestleReader && (readers[j] instanceof JPEGReader || readers[j] instanceof PGMReader || readers[j] instanceof TiffDelegateReader) || result && (r instanceof HitachiReader || readers[j] instanceof HitachiReader && (r instanceof TiffDelegateReader || r instanceof JPEGReader || r instanceof BMPReader)) || result && r instanceof BDReader && readers[j] instanceof BMPReader || !result && readers[j] instanceof BDReader && (used[i].endsWith(".bmp") || used[i].endsWith(".adf") || used[i].endsWith(".txt") || used[i].endsWith(".roi")) || !result && r instanceof VolocityReader && readers[j] instanceof VolocityReader || !result && r instanceof InCellReader && readers[j] instanceof InCellReader && !used[i].toLowerCase().endsWith(".xdce") || !result && r instanceof BrukerReader && readers[j] instanceof BrukerReader && !used[i].toLowerCase().equals("acqp") && !used[i].toLowerCase().equals("fid") || result && r instanceof VolocityReader || result && r instanceof NikonReader && readers[j] instanceof DNGReader || !result && r instanceof DicomReader && readers[j] instanceof DicomReader || !result && readers[j] instanceof MIASReader || !result && !used[i].toLowerCase().endsWith(".vms") && r instanceof HamamatsuVMSReader || !result && i > 0 && r instanceof QTReader || r instanceof CellVoyagerReader && (!result || readers[j] instanceof OMEXMLReader) && used[i].toLowerCase().endsWith(".ome.xml") || !result && r instanceof InveonReader || !result && r instanceof OperettaReader || result && r instanceof RCPNLReader && readers[j] instanceof DeltavisionReader || result && r instanceof CellWorxReader && readers[j] instanceof MetaxpressTiffReader || !result && readers[j] instanceof TissueFAXSReader && !used[i].toLowerCase().endsWith(".aqproj") || !result && readers[j] instanceof TecanReader && !used[i].toLowerCase().endsWith(".db") || result && r instanceof TecanReader && !used[i].toLowerCase().endsWith(".db") || result && r instanceof OlympusTileReader && readers[j] instanceof OIRReader || !result && r instanceof OlympusTileReader && !used[i].toLowerCase().endsWith(".omp2info") || !result && r instanceof CellSensReader && (!used[i].endsWith(".vsi") && !used[i].endsWith(".ets") || used[i].endsWith(".ets") && !used[i].startsWith("frame")) || !result && r instanceof JDCEReader && !used[i].endsWith(".jdce") || result && r instanceof JDCEReader && readers[j] instanceof MetamorphTiffReader || !result && readers[j] instanceof XLEFReader && (used[i].endsWith(".xlif") || used[i].endsWith(".xlcf") || used[i].endsWith(".tif") || used[i].endsWith(".tiff") || used[i].endsWith(".lof") || used[i].endsWith(".jpg") || used[i].endsWith(".png") || used[i].endsWith(".bmp")) || !result && readers[j] instanceof LOFReader && (used[i].endsWith(".xlif") || used[i].endsWith(".xlcf") || used[i].endsWith(".tif")) || result && r instanceof XLEFReader && (readers[j] instanceof LOFReader || readers[j] instanceof APNGReader || readers[j] instanceof BMPReader || readers[j] instanceof JPEGReader)) continue;
                        boolean bl = expected = r == readers[j];
                        if (result == expected) continue;
                        success = false;
                        if (result) {
                            msg = TestTools.shortClassName(readers[j]) + " flagged \"" + used[i] + "\" but so did " + TestTools.shortClassName(r);
                            continue block3;
                        }
                        msg = TestTools.shortClassName(readers[j]) + " skipped \"" + used[i] + "\"";
                        continue block3;
                    }
                }
            } else {
                success = false;
                msg = "Reader " + r.getClass().getName() + " is not an ImageReader";
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatReaderTest.result(testName, success, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(groups={"all", "automated", "memoizer"})
    public void testMemoFileUsage() {
        Object memo;
        String testName = "testMemoFileUsage";
        if (!this.initFile()) {
            FormatReaderTest.result(testName, false, "initFile");
        }
        File memoFile = null;
        File memoDir = null;
        try {
            String tmpdir = System.getProperty("java.io.tmpdir");
            memoDir = new File(tmpdir, UUID.randomUUID().toString() + ".memo");
            memoDir.mkdir();
            memo = new Memoizer(0L, memoDir);
            memo.setId(this.reader.getCurrentFile());
            memo.close();
            memoFile = memo.getMemoFile(this.reader.getCurrentFile());
            if (!memo.isSavedToMemo()) {
                FormatReaderTest.result(testName, false, "Memo file not saved");
            }
            memo.setId(this.reader.getCurrentFile());
            if (!memo.isLoadedFromMemo()) {
                FormatReaderTest.result(testName, false, "Memo file could not be loaded");
            }
            memo.openBytes(0, 0, 0, 1, 1);
            memo.close();
            String cacheDir = configTree.getCacheDirectory();
            if (cacheDir != null) {
                LOGGER.debug("Loading memo from populated cache");
                File dir = new File(cacheDir);
                if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
                    FormatReaderTest.result(testName, false, "Cached memo directory does not exist");
                }
                File currentFile = new File(this.reader.getCurrentFile());
                String relativeName = "." + currentFile.getName() + ".bfmemo";
                File expectedMemo = new File(cacheDir, currentFile.getParent());
                if ((expectedMemo = new File(expectedMemo, relativeName)).exists()) {
                    memo = new Memoizer(0L, dir);
                    memo.skipSave(true);
                    memo.setId(this.reader.getCurrentFile());
                    if (!memo.isLoadedFromMemo()) {
                        FormatReaderTest.result(testName, false, "Existing memo file could not be loaded");
                    }
                    memo.openBytes(0, 0, 0, 1, 1);
                    memo.close();
                } else {
                    LOGGER.warn("Missing memo file {}; passing test anyway", (Object)expectedMemo);
                }
            }
            FormatReaderTest.result(testName, true);
            return;
        }
        catch (Throwable t) {
            if (TestTools.isOutOfMemory(t)) {
                FormatReaderTest.result(testName, true, "Image too large");
                return;
            }
            LOGGER.warn("", t);
            FormatReaderTest.result(testName, false, t.getMessage());
            return;
        }
        finally {
            if (memoFile != null) {
                try {
                    RandomAccessInputStream s = new RandomAccessInputStream(memoFile.getAbsolutePath());
                    memo = null;
                    try {
                        LOGGER.debug("memo file size for {} = {} bytes", (Object)new Location(this.reader.getCurrentFile()).getAbsolutePath(), (Object)s.length());
                    }
                    catch (Throwable throwable) {
                        memo = throwable;
                        throw throwable;
                    }
                    finally {
                        if (s != null) {
                            if (memo != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)memo).addSuppressed(throwable);
                                }
                            } else {
                                s.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("memo file size not available");
                }
                memoFile.delete();
                while (!memoFile.getParentFile().equals(memoDir)) {
                    memoFile = memoFile.getParentFile();
                    memoFile.delete();
                }
            }
            if (memoDir != null) {
                memoDir.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"config"})
    public void writeConfigFile() throws IOException {
        this.setupReader();
        if (!this.initFile(false)) {
            return;
        }
        String file = this.reader.getCurrentFile();
        try {
            File parentDir;
            String parent = new Location(file).getParent();
            String configDir = configTree.getConfigDirectory();
            String rootDir = configTree.getRootDirectory();
            if (configDir != null && !(parentDir = new File(parent = parent.replace(rootDir, configDir))).exists()) {
                parentDir.mkdirs();
            }
            File f = new File(parent, ".bioformats");
            LOGGER.info("Generating configuration: {}", (Object)f);
            Configuration newConfig = new Configuration((IFormatReader)this.reader, f.getAbsolutePath());
            newConfig.saveToFile();
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            assert (false);
        }
        finally {
            this.reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"cache"})
    public void writeCacheFile() throws IOException {
        this.setupReader();
        if (!this.initFile(false)) {
            return;
        }
        String cacheDir = configTree.getCacheDirectory();
        if (cacheDir == null) {
            LOGGER.info("No cache directory specified");
            return;
        }
        try {
            Memoizer memo = new Memoizer(0L, new File(cacheDir));
            assert (memo.generateMemo(this.reader.getCurrentFile()));
            File memoFile = memo.getMemoFile(this.reader.getCurrentFile());
            LOGGER.info("Saved memo file to {}", (Object)memoFile);
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            assert (false);
        }
        finally {
            this.reader.close();
        }
    }

    @Test(groups={"config-xml"})
    public void writeXML() {
        block3: {
            this.setupReader();
            if (!this.initFile(false)) {
                return;
            }
            String file = this.reader.getCurrentFile();
            LOGGER.info("Generating XML: {}", (Object)file);
            try {
                Location l = new Location(file);
                File f = new File(l.getParent(), l.getName() + ".ome.xml");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
                MetadataStore store = this.reader.getMetadataStore();
                MetadataRetrieve retrieve = this.omexmlService.asRetrieve(store);
                String xml = this.omexmlService.getOMEXML(retrieve);
                writer.write(xml);
                writer.close();
                this.reader.close();
            }
            catch (Throwable t) {
                LOGGER.info("", t);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Test(groups={"file-list"})
    public void saveFileScanList() {
        block3: {
            try {
                File f = new File(this.fileList);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), "UTF-8");
                if (f.length() == 0L) {
                    writer.write(System.getProperty("testng.directory"));
                    writer.write("\n");
                }
                writer.write(this.id);
                writer.write("\n");
                writer.close();
            }
            catch (Throwable t) {
                LOGGER.info("", t);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void setupReader() {
        this.setupReader(true, false);
    }

    private IFormatReader setupReader(boolean flattened, boolean initialize) {
        ImageReader ir = null;
        if (flattened) {
            ir = new ImageReader();
            ir = new BufferedImageReader((IFormatReader)new Memoizer((IFormatReader)ir, 100L, new File("")));
            ir.setMetadataOptions((MetadataOptions)new DynamicMetadataOptions(MetadataLevel.NO_OVERLAYS));
        } else {
            ir = new BufferedImageReader((IFormatReader)new ImageReader());
            ir.setFlattenedResolutions(false);
        }
        OMEXMLMetadata store = null;
        try {
            store = this.omexmlService.createOMEXMLMetadata();
        }
        catch (ServiceException e) {
            LOGGER.warn("Could not parse OME-XML", (Throwable)e);
        }
        ir.setMetadataStore((MetadataStore)store);
        ir.setNormalized(true);
        ir.setOriginalMetadataPopulated(false);
        ir.setMetadataFiltered(true);
        if (initialize) {
            try {
                ir.setId(this.id);
            }
            catch (IOException | FormatException e) {
                LOGGER.error("Could not initialize " + this.id, e);
            }
        }
        if (flattened) {
            this.reader = (BufferedImageReader)ir;
        }
        return ir;
    }

    private boolean initFile() {
        return this.initFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initFile(boolean removeDuplicateFiles) {
        if (this.skip) {
            throw new SkipException(SKIP_MESSAGE);
        }
        if (this.config == null) {
            try {
                ConfigurationTree configurationTree = configTree;
                synchronized (configurationTree) {
                    this.config = configTree.get(this.id);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.reader == null) {
            this.setupReader();
        }
        String absPath = new Location(this.id).getAbsolutePath();
        if (this.reader.getCurrentFile() != null && (absPath.equals(new Location(this.reader.getCurrentFile()).getAbsolutePath()) || DataTools.indexOf((Object[])this.reader.getUsedFiles(), (Object)absPath) >= 0)) {
            return true;
        }
        int ndx = skipFiles.indexOf(this.id);
        if (ndx >= 0 && removeDuplicateFiles) {
            LOGGER.info("Skipping {}", (Object)this.id);
            skipFiles.remove(ndx);
            this.skip = true;
            throw new SkipException(SKIP_MESSAGE);
        }
        if (this.config == null && removeDuplicateFiles) {
            throw new RuntimeException(this.id + " not configured.");
        }
        LOGGER.info("Initializing {}: ", (Object)this.id);
        try {
            boolean single;
            boolean reallyInMemory = false;
            if (this.inMemory && this.reader.isSingleFile(this.id)) {
                HashMap idMap = Location.getIdMap();
                idMap.clear();
                Location.setIdMap((HashMap)idMap);
                reallyInMemory = TestTools.mapFile(this.id);
            }
            this.reader.setId(this.id);
            String[] used = this.reader.getUsedFiles();
            boolean base = false;
            for (int i = 0; i < used.length; ++i) {
                if (this.id.equals(used[i])) {
                    base = true;
                    continue;
                }
                skipFiles.add(used[i]);
                if (!reallyInMemory) continue;
                TestTools.mapFile(used[i]);
            }
            boolean bl = single = used.length == 1;
            if (single && base) {
                LOGGER.debug("OK");
            } else {
                LOGGER.debug("{} {}", (Object)used.length, (Object)(single ? "file" : "files"));
            }
            if (!base) {
                LOGGER.error("Used files list does not include base file");
            }
        }
        catch (Throwable t) {
            LOGGER.error("", t);
            return false;
        }
        return true;
    }

    private static void result(String testName, boolean success) {
        FormatReaderTest.result(testName, success, null);
    }

    private static void result(String testName, boolean success, String msg) {
        if (success) {
            LOGGER.debug("\t{}: PASSED ({})", new Object[]{testName, msg == null ? "" : msg});
        } else {
            LOGGER.error("\t{}: FAILED ({})", new Object[]{testName, msg == null ? "" : msg});
        }
        if (msg == null) {
            assert (success);
        } else assert (success) : msg;
    }

    private String checkOMEXML(IFormatReader reader) {
        String msg = null;
        try {
            MetadataRetrieve retrieve = (MetadataRetrieve)reader.getMetadataStore();
            boolean success = this.omexmlService.isOMEXMLMetadata((Object)retrieve);
            if (!success) {
                msg = TestTools.shortClassName(retrieve);
            }
            if (reader.getSeriesCount() != retrieve.getImageCount()) {
                msg = "ImageCount (series=" + reader.getSeriesCount() + ", image=" + retrieve.getImageCount() + ")";
            }
            for (int i = 0; i < reader.getSeriesCount() && msg == null; ++i) {
                int samplesPerPixel;
                int nChannelComponents;
                int sizeC = (Integer)retrieve.getPixelsSizeC(i).getValue();
                if (sizeC != (nChannelComponents = retrieve.getChannelCount(i)) * (samplesPerPixel = ((Integer)retrieve.getChannelSamplesPerPixel(i, 0).getValue()).intValue())) {
                    msg = "ChannelComponent";
                }
                Time deltaT = null;
                Time exposure = null;
                Integer z = null;
                Integer c = null;
                Integer t = null;
                if (retrieve.getPlaneCount(i) > 0) {
                    deltaT = retrieve.getPlaneDeltaT(i, 0);
                    exposure = retrieve.getPlaneExposureTime(i, 0);
                    z = (Integer)retrieve.getPlaneTheZ(i, 0).getValue();
                    c = (Integer)retrieve.getPlaneTheC(i, 0).getValue();
                    t = (Integer)retrieve.getPlaneTheT(i, 0).getValue();
                }
                if (!(deltaT == null && exposure == null || z != null && c != null && t != null)) {
                    msg = "PlaneTiming";
                }
                String date = null;
                if (retrieve.getImageAcquisitionDate(i) != null) {
                    date = (String)retrieve.getImageAcquisitionDate(i).getValue();
                }
                this.config.setSeries(i);
                String configDate = this.config.getDate();
                if (date == null || date.equals(configDate)) continue;
                date = date.trim();
                long acquiredDate = new Timestamp(date).asInstant().getMillis();
                long saneDate = new Timestamp("1990-01-01T00:00:00").asInstant().getMillis();
                long fileDate = new Location(reader.getCurrentFile()).getAbsoluteFile().lastModified();
                if (acquiredDate >= saneDate || fileDate < saneDate) continue;
                msg = "CreationDate (date=" + date + " acquiredDate=" + acquiredDate + " fileDate=" + fileDate + " saneDate=" + saneDate + ")";
            }
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            msg = t.getMessage();
        }
        return msg;
    }

    static {
        skipFiles = new LinkedList<String>();
    }
}

