/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import thredds.inventory.DateExtractor;
import thredds.inventory.MFile;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateFromString;

public class DateExtractorFromName
implements DateExtractor {
    private String dateFormatMark;
    private boolean useName;

    public DateExtractorFromName(String dateFormatMark, boolean useName) {
        this.dateFormatMark = dateFormatMark;
        this.useName = useName;
    }

    @Override
    public Date getDate(MFile mfile) {
        if (this.useName) {
            return DateFromString.getDateUsingDemarkatedCount(mfile.getName(), this.dateFormatMark, '#');
        }
        return DateFromString.getDateUsingDemarkatedMatch(mfile.getPath(), this.dateFormatMark, '#');
    }

    @Override
    public CalendarDate getCalendarDate(MFile mfile) {
        Date d = this.getDate(mfile);
        return d == null ? null : CalendarDate.of(d);
    }

    @Override
    public CalendarDate getCalendarDateFromPath(String path) {
        Date d;
        if (this.useName) {
            Path p = Paths.get(path, new String[0]);
            d = DateFromString.getDateUsingDemarkatedCount(p.getFileName().toString(), this.dateFormatMark, '#');
        } else {
            d = DateFromString.getDateUsingDemarkatedMatch(path, this.dateFormatMark, '#');
        }
        return d == null ? null : CalendarDate.of(d);
    }

    public String toString() {
        return "DateExtractorFromName{dateFormatMark='" + this.dateFormatMark + '\'' + ", useName=" + this.useName + '}';
    }
}

