/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.TimingStatistics;
import org.perf4j.helpers.AcceptableRangeConfiguration;
import org.perf4j.helpers.StatsValueRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsExposingMBean
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String DEFAULT_MBEAN_NAME = "org.perf4j:type=StatisticsExposingMBean,name=Perf4J";
    public static final String OUT_OF_RANGE_NOTIFICATION_TYPE = "org.perf4j.threshold.exceeded";
    protected ObjectName mBeanName;
    protected MBeanInfo managementInterface;
    protected Collection<String> tagsToExpose;
    protected Map<AcceptableRangeConfiguration, Boolean> acceptableRanges;
    protected ExecutorService outOfRangeNotifierThread;
    protected long outOfRangeNotificationSeqNo;
    protected GroupedTimingStatistics currentTimingStatistics;
    protected Pattern attributeNamePattern = Pattern.compile("(.*)(Mean|StdDev|Min|Max|Count|TPS)");

    public StatisticsExposingMBean(String mBeanName, Collection<String> tagsToExpose, Collection<AcceptableRangeConfiguration> acceptableRanges) {
        if (mBeanName == null) {
            mBeanName = DEFAULT_MBEAN_NAME;
        }
        try {
            this.mBeanName = new ObjectName(mBeanName);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException(mone);
        }
        if (acceptableRanges == null || acceptableRanges.isEmpty()) {
            this.acceptableRanges = Collections.emptyMap();
        } else {
            this.acceptableRanges = new LinkedHashMap<AcceptableRangeConfiguration, Boolean>();
            for (AcceptableRangeConfiguration acceptableRange : acceptableRanges) {
                this.acceptableRanges.put(acceptableRange, Boolean.TRUE);
                if (this.attributeNamePattern.matcher(acceptableRange.getAttributeName()).matches()) continue;
                throw new IllegalArgumentException("Acceptable range attribute name " + acceptableRange.getAttributeName() + " invalid - must match pattern " + this.attributeNamePattern.pattern());
            }
            this.outOfRangeNotifierThread = Executors.newSingleThreadExecutor();
        }
        this.tagsToExpose = new ArrayList<String>(tagsToExpose);
        this.managementInterface = this.createMBeanInfoFromTagNames(tagsToExpose);
        this.currentTimingStatistics = new GroupedTimingStatistics();
    }

    public synchronized void updateCurrentTimingStatistics(GroupedTimingStatistics currentTimingStatistics) {
        if (currentTimingStatistics == null) {
            throw new IllegalArgumentException("timing statistics may not be null");
        }
        this.currentTimingStatistics = currentTimingStatistics;
        this.sendNotificationsIfValuesNotAcceptable();
    }

    public void exposeTag(String tagName) {
        this.tagsToExpose.add(tagName);
        this.managementInterface = this.createMBeanInfoFromTagNames(this.tagsToExpose);
    }

    public boolean removeTag(String tagName) {
        boolean retVal = this.tagsToExpose.remove(tagName);
        this.managementInterface = this.createMBeanInfoFromTagNames(this.tagsToExpose);
        return retVal;
    }

    @Override
    public synchronized Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Matcher matcher = this.attributeNamePattern.matcher(attribute);
        if (matcher.matches()) {
            String tagName = matcher.group(1);
            String statisticName = matcher.group(2);
            TimingStatistics timingStats = (TimingStatistics)this.currentTimingStatistics.getStatisticsByTag().get(tagName);
            long windowLength = this.currentTimingStatistics.getStopTime() - this.currentTimingStatistics.getStartTime();
            return this.getStatsValueRetrievers().get(statisticName).getStatsValue(timingStats, windowLength);
        }
        throw new AttributeNotFoundException("No attribute named " + attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Statistics attributes are not writable");
    }

    @Override
    public synchronized AttributeList getAttributes(String[] attributeNames) {
        AttributeList retVal = new AttributeList();
        for (String attributeName : attributeNames) {
            try {
                retVal.add(new Attribute(attributeName, this.getAttribute(attributeName)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if ("exposeTag".equals(actionName)) {
            this.exposeTag(params[0].toString());
            return null;
        }
        if ("removeTag".equals(actionName)) {
            return this.removeTag(params[0].toString());
        }
        throw new UnsupportedOperationException("Unsupported operation: " + actionName);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.managementInterface;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.managementInterface.getNotifications();
    }

    protected Map<String, StatsValueRetriever> getStatsValueRetrievers() {
        return StatsValueRetriever.DEFAULT_RETRIEVERS;
    }

    protected MBeanInfo createMBeanInfoFromTagNames(Collection<String> tagNames) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[tagNames.size() * this.getStatsValueRetrievers().size()];
        int i = 0;
        for (String tagName : tagNames) {
            for (Map.Entry<String, StatsValueRetriever> statNameAndValueRetriever : this.getStatsValueRetrievers().entrySet()) {
                String statName = statNameAndValueRetriever.getKey();
                StatsValueRetriever statsValueRetriever = statNameAndValueRetriever.getValue();
                attributes[i++] = new MBeanAttributeInfo(tagName + statName, statsValueRetriever.getValueClass().getName(), "Returns " + statName + " for tag " + tagName, true, false, false);
            }
        }
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("exposeTag", "Allows the caller to add a monitored tag at runtime", new MBeanParameterInfo[]{new MBeanParameterInfo("tagName", String.class.getName(), "The name of the tag to expose")}, "void", 1), new MBeanOperationInfo("removeTag", "Allows the caller to remove a monitored tag at runtime", new MBeanParameterInfo[]{new MBeanParameterInfo("tagName", String.class.getName(), "The name of the tag to remove")}, "boolean", 1)};
        MBeanNotificationInfo[] notificationInfos = this.acceptableRanges.isEmpty() ? new MBeanNotificationInfo[]{} : new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{OUT_OF_RANGE_NOTIFICATION_TYPE}, Notification.class.getName(), "Notification sent if any statistics move outside of the specified acceptable ranges")};
        return new MBeanInfo(this.getClass().getName(), "Timing Statistics", attributes, null, operations, notificationInfos);
    }

    protected void sendNotificationsIfValuesNotAcceptable() {
        for (Map.Entry<AcceptableRangeConfiguration, Boolean> acceptableRangeAndWasGood : this.acceptableRanges.entrySet()) {
            double attributeValue;
            AcceptableRangeConfiguration acceptableRange = acceptableRangeAndWasGood.getKey();
            boolean lastCheckWasGood = acceptableRangeAndWasGood.getValue();
            try {
                attributeValue = ((Number)this.getAttribute(acceptableRange.getAttributeName())).doubleValue();
            }
            catch (Exception e) {
                continue;
            }
            boolean isValueInRange = acceptableRange.isInRange(attributeValue);
            acceptableRangeAndWasGood.setValue(isValueInRange);
            if (!lastCheckWasGood || isValueInRange) continue;
            this.sendOutOfRangeNotification(attributeValue, acceptableRange);
        }
    }

    protected void sendOutOfRangeNotification(final double attributeValue, final AcceptableRangeConfiguration acceptableRange) {
        this.outOfRangeNotifierThread.execute(new Runnable(){

            public void run() {
                String errorMessage = "Attribute value " + attributeValue + " not in range " + acceptableRange;
                StatisticsExposingMBean.this.sendNotification(new Notification(StatisticsExposingMBean.OUT_OF_RANGE_NOTIFICATION_TYPE, StatisticsExposingMBean.this.mBeanName, ++StatisticsExposingMBean.this.outOfRangeNotificationSeqNo, System.currentTimeMillis(), errorMessage));
            }
        });
    }
}

