/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.ZipHandle;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TecanReader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TecanReader.class);
    private static final String[] SPREADSHEET_KEYS = new String[]{"Application:", "Device", "Firmware", "System", "User", "Smooth mode", "Part of Plate"};
    private int plateRows = 0;
    private int plateColumns = 0;
    private transient String plateName = null;
    private ArrayList<Image> images = new ArrayList();
    private transient MinimalTiffReader helperReader = null;
    private transient ArrayList<Channel> channels = new ArrayList();
    private String imageDirectory = null;
    private ArrayList<String> extraFiles = new ArrayList();
    private Integer maxField = 1;
    private Integer maxCycle = 1;

    public TecanReader() {
        super("Tecan Spark Cyto", new String[]{"db"});
        this.hasCompanionFiles = true;
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.datasetDescription = "SQLite database, TIFF files, optional analysis output";
        this.suffixSufficient = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        if (!TecanReader.checkSuffix(name, "db")) {
            return false;
        }
        if (!open) {
            return super.isThisType(name, open);
        }
        try (Connection conn = this.openConnection(name);){
            this.findPlateDimensions(conn);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 3;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getCurrentFile());
        files.addAll(this.extraFiles);
        for (Image img : this.images) {
            if (!img.result && !img.overlay && noPixels) continue;
            files.add(this.getImageFile(img.file));
        }
        Object[] rtn = files.toArray(new String[files.size()]);
        Arrays.sort(rtn);
        return rtn;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getCurrentFile());
        files.addAll(this.extraFiles);
        for (Image img : this.images) {
            if (img.series != this.getSeries() || !img.result && !img.overlay && noPixels) continue;
            files.add(this.getImageFile(img.file));
        }
        Object[] rtn = files.toArray(new String[files.size()]);
        Arrays.sort(rtn);
        return rtn;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helperReader != null) {
            this.helperReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.images.clear();
            this.channels.clear();
            this.imageDirectory = null;
            this.plateRows = 0;
            this.plateColumns = 0;
            this.plateName = null;
            this.helperReader = null;
            this.extraFiles.clear();
            this.maxField = 1;
            this.maxCycle = 1;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        Arrays.fill(buf, this.getFillColor());
        Image img = this.lookupImage(this.getSeries(), no, false, false);
        if (img != null && img.file != null) {
            if (this.helperReader == null) {
                this.helperReader = new MinimalTiffReader();
            }
            String filePath = this.getImageFile(img.file);
            LOGGER.debug("Reading plane {} in series {} from {}", no, this.getSeries(), filePath);
            this.helperReader.setId(filePath);
            if (this.helperReader.getImageCount() > 1) {
                LOGGER.warn("File {} has {} planes", (Object)img.file, (Object)this.helperReader.getImageCount());
            }
            this.helperReader.openBytes(0, buf, x, y, w, h2);
        }
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        parent = parent.getParentFile();
        Location imageDir = new Location(parent, "Images");
        if (!imageDir.exists() || !imageDir.isDirectory()) {
            throw new IOException("Cannot find expected 'Images' directory");
        }
        this.imageDirectory = imageDir.getAbsolutePath();
        Location export = new Location(parent, "Export");
        if (export.exists() && export.isDirectory()) {
            this.findAllFiles(export, this.extraFiles);
        }
        HashMap<Integer, String> wellLabels = null;
        try (Connection conn = this.openConnection();){
            this.findPlateDimensions(conn);
            wellLabels = this.getWellLabels(conn);
            this.findImages(conn, wellLabels);
        }
        catch (SQLException e) {
            throw new IOException("Could not assemble plate", e);
        }
        for (Image img : this.images) {
            img.series *= this.maxField.intValue();
            img.series += img.field - 1;
            img.plane += (img.cycle - 1) * this.channels.size();
        }
        this.core.clear();
        this.helperReader = new MinimalTiffReader();
        for (int w = 0; w < wellLabels.size(); ++w) {
            Image firstImage = this.lookupImage(w * this.maxField, 0, false, false);
            if (firstImage == null) {
                throw new FormatException("Could not find first file");
            }
            this.helperReader.setId(this.getImageFile(firstImage.file));
            for (int f = 0; f < this.maxField; ++f) {
                this.core.add(this.helperReader.getCoreMetadataList().get(0));
                ((CoreMetadata)this.core.get((int)(this.core.size() - 1))).sizeC *= this.channels.size();
                ((CoreMetadata)this.core.get((int)(this.core.size() - 1))).sizeT = this.maxCycle;
                ((CoreMetadata)this.core.get((int)(this.core.size() - 1))).imageCount *= this.channels.size() * this.maxCycle;
            }
        }
        this.findExtraMetadata();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        store.setPlateName(this.plateName, 0);
        store.setPlateRows(new PositiveInteger(this.plateRows), 0);
        store.setPlateColumns(new PositiveInteger(this.plateColumns), 0);
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        store.setPlateAcquisitionMaximumFieldCount(new PositiveInteger(this.maxField), 0, 0);
        int nextWell = 0;
        int nextImage = 0;
        for (int row = 0; row < this.plateRows; ++row) {
            for (int col = 0; col < this.plateColumns; ++col) {
                store.setWellID(MetadataTools.createLSID("Well", 0, nextWell), 0, nextWell);
                store.setWellRow(new NonNegativeInteger(row), 0, nextWell);
                store.setWellColumn(new NonNegativeInteger(col), 0, nextWell);
                String label = this.makeWellLabel(row, col);
                if (!wellLabels.containsValue(label)) {
                    ++nextWell;
                    continue;
                }
                for (int field = 0; field < this.maxField; ++field) {
                    String wellSampleID = MetadataTools.createLSID("WellSample", 0, nextWell, field);
                    store.setWellSampleID(wellSampleID, 0, nextWell, field);
                    store.setWellSampleIndex(new NonNegativeInteger(nextImage), 0, nextWell, field);
                    String imageID = MetadataTools.createLSID("Image", nextImage);
                    store.setImageID(imageID, nextImage);
                    store.setWellSampleImageRef(imageID, 0, nextWell, field);
                    store.setImageName("Well " + label + " Field " + (field + 1), nextImage);
                    store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, nextImage);
                    ++nextImage;
                }
                ++nextWell;
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                if (this.channels != null) {
                    for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                        store.setChannelName(this.channels.get((int)c).name, i, c);
                    }
                }
                Image firstImage = this.lookupImage(i, 0, false, false);
                if (firstImage.pixelSize != null) {
                    store.setPixelsPhysicalSizeX(firstImage.pixelSize, i);
                    store.setPixelsPhysicalSizeY(firstImage.pixelSize, i);
                }
                if (firstImage.timestamp != null) {
                    store.setImageAcquisitionDate(new Timestamp(DateTools.formatDate(firstImage.timestamp, "yyyy-MM-dd HH:mm:ss.SSSSSS")), i);
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    Image img = this.lookupImage(i, p, false, false);
                    if (img.exposureTime == null) continue;
                    store.setPlaneExposureTime(img.exposureTime, i, p);
                }
            }
        }
    }

    private Connection openConnection() throws IOException {
        return this.openConnection(this.getCurrentFile());
    }

    private Connection openConnection(String file2) throws IOException {
        Connection conn = null;
        try {
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            conn = config.createConnection("jdbc:sqlite:" + new Location(file2).getAbsolutePath());
        }
        catch (SQLException e) {
            LOGGER.warn("Could not read from database");
            throw new IOException(e);
        }
        return conn;
    }

    private void findExtraMetadata() {
        try (Connection conn = this.openConnection();){
            block130: {
                Object serialNumber;
                PreparedStatement instrument = conn.prepareStatement("SELECT InstrumentSerial FROM InstrumentConfig ORDER BY Id");
                try (ResultSet instruments = instrument.executeQuery();){
                    if (instruments.next()) {
                        serialNumber = instruments.getString(1);
                        this.addGlobalMeta("Serial number", serialNumber);
                    }
                }
                PreparedStatement completionTime = conn.prepareStatement("SELECT CompletedAt FROM Workspace ORDER BY Id");
                ResultSet workspace = completionTime.executeQuery();
                serialNumber = null;
                try {
                    if (workspace.next()) {
                        this.addGlobalMeta("Date/Time", workspace.getString(1));
                    }
                }
                catch (Throwable throwable) {
                    serialNumber = throwable;
                    throw throwable;
                }
                finally {
                    if (workspace != null) {
                        if (serialNumber != null) {
                            try {
                                workspace.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serialNumber).addSuppressed(throwable);
                            }
                        } else {
                            workspace.close();
                        }
                    }
                }
                PreparedStatement acquisitionSetting = conn.prepareStatement("SELECT ObjectiveTypeId, IntrawellPatternId, SettleTimeInMs FROM AcquisitionSetting ORDER BY Id");
                try (ResultSet acquisition = acquisitionSetting.executeQuery();){
                    if (!acquisition.next()) break block130;
                    int objectiveTypeId = acquisition.getInt(1);
                    int intrawellPatternId = acquisition.getInt(2);
                    this.addGlobalMeta("Settle time [ms]", acquisition.getDouble(3));
                    PreparedStatement objectiveType = conn.prepareStatement("SELECT Name FROM ObjectiveType WHERE Id=?");
                    objectiveType.setInt(1, objectiveTypeId);
                    try (ResultSet objective = objectiveType.executeQuery();){
                        if (objective.next()) {
                            this.addGlobalMeta("Objective", objective.getString(1));
                        }
                    }
                    PreparedStatement wellPattern = conn.prepareStatement("SELECT Name FROM IntrawellPattern INNER JOIN IntrawellPatternType ON IntrawellPattern.IntrawellPatternTypeId=IntrawellPatternType.Id WHERE IntrawellPattern.Id=?");
                    wellPattern.setInt(1, intrawellPatternId);
                    try (ResultSet wellPatternType = wellPattern.executeQuery();){
                        if (wellPatternType.next()) {
                            this.addGlobalMeta("Pattern", wellPatternType.getString(1));
                        }
                    }
                }
            }
            PreparedStatement application = conn.prepareStatement("SELECT Name FROM AnalysisSetting INNER JOIN ApplicationType ON AnalysisSetting.ApplicationTypeId=ApplicationType.Id");
            try (ResultSet applicationType = application.executeQuery();){
                if (applicationType.next()) {
                    this.addGlobalMeta("Application type", applicationType.getString(1));
                }
            }
            PreparedStatement labels = conn.prepareStatement("SELECT DISTINCT OutputName FROM ImagingResult INNER JOIN DataLabel ON ImagingResult.DataLabelId=DataLabel.Id");
            try (ResultSet labelNames = labels.executeQuery();){
                while (labelNames.next()) {
                    this.addGlobalMetaList("Label Name", labelNames.getString(1));
                }
            }
            PreparedStatement method = conn.prepareStatement("SELECT MethodName, SerializedMethod FROM MethodSnapshot ORDER BY Id");
            try (ResultSet methods = method.executeQuery();){
                if (methods.next()) {
                    String methodName = methods.getString(1);
                    String methodXML = methods.getString(2);
                    this.addGlobalMeta("Method name", methodName);
                    try {
                        methodXML = methodXML.substring(methodXML.indexOf("<MethodStrip"));
                        Element root = XMLTools.parseDOM(methodXML).getDocumentElement();
                        NodeList channelSettings = root.getElementsByTagName("tadodssdf:FluorescenceImagingChannelSetting");
                        NodeList plateStrips = root.getElementsByTagName("PlateStrip");
                        NodeList plateDefinitions = root.getElementsByTagName("MicroplateDefinition");
                        if (plateStrips.getLength() > 0) {
                            Element plateStrip = (Element)plateStrips.item(0);
                            this.addGlobalMeta("Lid lifter", plateStrip.getAttribute("LidType"));
                            this.addGlobalMeta("Humidity Cassette", plateStrip.getAttribute("HumidityCassetteType"));
                        }
                        if (plateDefinitions.getLength() > 0) {
                            Element plateDef = (Element)plateDefinitions.item(0);
                            this.addGlobalMeta("Plate", plateDef.getAttribute("DisplayName") + " " + plateDef.getAttribute("Comment"));
                        }
                        StringBuffer channelNames = new StringBuffer();
                        for (int i = 0; i < channelSettings.getLength(); ++i) {
                            NodeList crosstalkCorrections;
                            Element channel = (Element)channelSettings.item(i);
                            String enabled = channel.getAttribute("IsEnabled");
                            String name = channel.getAttribute("Name");
                            if (!Boolean.parseBoolean(enabled)) continue;
                            if (channelNames.length() > 0) {
                                channelNames.append(", ");
                            }
                            channelNames.append(name);
                            int index = this.lookupChannelIndex(name);
                            if (index < 0 || (crosstalkCorrections = channel.getElementsByTagName("tadodssdf:CrosstalkSettings.CrosstalkCorrectionDict")).getLength() <= 0) continue;
                            Element crosstalkCorrection = (Element)crosstalkCorrections.item(0);
                            NodeList dict = crosstalkCorrection.getElementsByTagName("x:Int16");
                            StringBuffer crosstalk = new StringBuffer();
                            for (int d = 0; d < dict.getLength(); ++d) {
                                if (crosstalk.length() > 0) {
                                    crosstalk.append(", ");
                                }
                                Element component = (Element)dict.item(d);
                                crosstalk.append(component.getAttribute("x:Key"));
                                crosstalk.append(": ");
                                crosstalk.append(component.getTextContent());
                                crosstalk.append("%");
                            }
                            this.addGlobalMeta("Channel #" + (index + 1) + " Cross-talk settings", crosstalk.toString());
                        }
                        this.addGlobalMeta("Channels", channelNames.toString());
                    }
                    catch (ParserConfigurationException | SAXException e) {
                        LOGGER.debug("Could not parse XML", e);
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            LOGGER.warn("Could not read all extra metadata", e);
        }
        for (int c = 0; c < this.channels.size(); ++c) {
            String prefix = "Channel #" + (c + 1) + " ";
            Channel channel = this.channels.get(c);
            this.addGlobalMeta(prefix + "Name", channel.originalName);
            this.addGlobalMeta(prefix + "LED Intensity [%]", channel.intensity);
            this.addGlobalMeta(prefix + "Focus offset [\u00b5m]", channel.focusOffset);
            this.addGlobalMeta(prefix + "Exposure time [\u00b5s]", channel.exposureTime);
        }
        for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
            this.setSeries(s2);
            for (int p = 0; p < this.getImageCount(); ++p) {
                Image img = this.lookupImage(s2, p, false, false);
                String prefix = "Plane #" + (p + 1) + " ";
                this.addSeriesMeta(prefix + "Position on Micro Plate", this.makeWellLabel(img.wellRow, img.wellColumn));
                this.addSeriesMeta(prefix + "File creation time", img.timestamp);
                String[] fileTokens = img.file.split("_");
                this.addSeriesMeta(prefix + "Data", fileTokens[fileTokens.length - 2]);
            }
        }
        this.setSeries(0);
        this.parseSpreadsheet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSpreadsheet() {
        try {
            String spreadsheet = null;
            for (String file2 : this.extraFiles) {
                if (!TecanReader.checkSuffix(file2, "xlsx")) continue;
                spreadsheet = file2;
                break;
            }
            if (spreadsheet == null) {
                return;
            }
            String sharedStringsXML = null;
            String firstSheetXML = null;
            try (ZipInputStream z = new ZipInputStream(new FileInputStream(spreadsheet));){
                do {
                    byte[] b;
                    ZipHandle handle;
                    ZipEntry ze;
                    if ((ze = z.getNextEntry()) == null) {
                        break;
                    }
                    if (ze.getName().equals("xl/sharedStrings.xml")) {
                        handle = new ZipHandle(spreadsheet, ze);
                        try {
                            b = new byte[(int)handle.length()];
                            handle.read(b);
                            sharedStringsXML = new String(b, "UTF-8").trim();
                        }
                        finally {
                            handle.close();
                        }
                    } else {
                        if (!ze.getName().equals("xl/worksheets/sheet1.xml")) continue;
                        handle = new ZipHandle(spreadsheet, ze);
                        try {
                            b = new byte[(int)handle.length()];
                            handle.read(b);
                            firstSheetXML = new String(b, "UTF-8").trim();
                        }
                        finally {
                            handle.close();
                        }
                    }
                } while (sharedStringsXML == null || firstSheetXML == null);
            }
            if (sharedStringsXML != null && firstSheetXML != null) {
                Element sharedStrings = XMLTools.parseDOM(sharedStringsXML).getDocumentElement();
                NodeList strings = sharedStrings.getElementsByTagName("t");
                Element worksheet = XMLTools.parseDOM(firstSheetXML).getDocumentElement();
                NodeList cells = worksheet.getElementsByTagName("c");
                String key = null;
                String value = "";
                for (int i = 0; i < cells.getLength(); ++i) {
                    int cellValueIndex;
                    Element cell = (Element)cells.item(i);
                    if (cell.getFirstChild() == null || (cellValueIndex = Integer.parseInt(cell.getFirstChild().getTextContent())) < 0 || cellValueIndex >= strings.getLength()) continue;
                    String cellValue = strings.item(cellValueIndex).getTextContent();
                    if (DataTools.indexOf(SPREADSHEET_KEYS, cellValue) >= 0) {
                        key = cellValue;
                        continue;
                    }
                    if (key != null) {
                        this.addGlobalMeta(key, value + " " + cellValue);
                        key = null;
                        value = "";
                        continue;
                    }
                    for (String knownKey : SPREADSHEET_KEYS) {
                        int index;
                        if (!cellValue.startsWith(knownKey) && !cellValue.startsWith(knownKey + ":") || (index = cellValue.indexOf(":")) <= 0) continue;
                        key = cellValue.substring(0, index);
                        value = cellValue.substring(index + 1).trim();
                    }
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.debug("Could not parse spreadsheet", e);
        }
        catch (NumberFormatException n) {
            LOGGER.debug("Unexpected spreadsheet contents", n);
        }
    }

    private String makeWellLabel(int row, int col) {
        return (char)(row + 65) + String.valueOf(col + 1);
    }

    private void findPlateDimensions(Connection conn) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("SELECT Name, Rows, Columns FROM PlateDefinition ORDER BY Id");
        try (ResultSet plates = statement.executeQuery();){
            if (plates.next()) {
                this.plateName = plates.getString(1);
                this.plateRows = plates.getInt(2);
                this.plateColumns = plates.getInt(3);
            }
            if (plates.next()) {
                LOGGER.warn("Found more than one plate; only using the first one");
            }
        }
    }

    private HashMap<Integer, String> getWellLabels(Connection conn) throws SQLException {
        HashMap<Integer, String> labels = new HashMap<Integer, String>();
        PreparedStatement statement = conn.prepareStatement("SELECT Id, AlphanumericCoordinate FROM SelectedWell");
        try (ResultSet wells = statement.executeQuery();){
            while (wells.next()) {
                labels.put(wells.getInt(1), wells.getString(2));
            }
        }
        return labels;
    }

    private void findImages(Connection conn, HashMap<Integer, String> wells) throws SQLException {
        PreparedStatement imageQuery = conn.prepareStatement("SELECT ImageTypeId, ImagingResultId, RelativePath, PixelSizeInNm FROM Image ORDER BY Id");
        PreparedStatement wellLinkQuery = conn.prepareStatement("SELECT SelectedWellId, CycleIndex FROM ImagingResult INNER JOIN ResultContext ON ImagingResult.ResultContextId=ResultContext.Id WHERE ImagingResult.Id=?");
        PreparedStatement typeQuery = conn.prepareStatement("SELECT ChannelTypeId, IsResult, IsOverlay, Name FROM ImageType WHERE Id = ?");
        PreparedStatement acquisitionType = conn.prepareStatement("SELECT Name, CreatedAt FROM ImagingResultType INNER JOIN ImagingResult ON ImagingResultType.Id=ImagingResult.ImagingResultTypeId WHERE ImagingResult.Id=?");
        PreparedStatement channelQuery = conn.prepareStatement("SELECT Name, ExposureTimeInUs, FocusOffsetInUm, LedIntensityInPercent FROM ChannelType INNER JOIN AcquisitionChannelSetting ON AcquisitionChannelSetting.ChannelTypeId=ChannelType.Id WHERE ChannelType.Id=?");
        try (ResultSet allImages = imageQuery.executeQuery();){
            while (allImages.next()) {
                Image img = new Image();
                img.file = allImages.getString(3);
                img.pixelSize = FormatTools.getPhysicalSize(allImages.getDouble(4), "nm");
                LOGGER.debug("processing image file = {}", (Object)img.file);
                String imageTypeId = allImages.getString(1);
                String resultId = allImages.getString(2);
                typeQuery.setInt(1, Integer.parseInt(imageTypeId));
                int channelTypeId = 0;
                try (ResultSet imageType = typeQuery.executeQuery();){
                    imageType.next();
                    channelTypeId = imageType.getInt(1);
                    img.result = imageType.getBoolean(2);
                    img.overlay = imageType.getBoolean(3);
                    img.channelName = imageType.getString(4);
                }
                acquisitionType.setInt(1, Integer.parseInt(resultId));
                String acqTypeName = null;
                String acqTimestamp = null;
                try (ResultSet acqType = acquisitionType.executeQuery();){
                    acqType.next();
                    acqTypeName = acqType.getString(1);
                    acqTimestamp = acqType.getString(2);
                }
                if ("Raw".equals(acqTypeName) && !img.result && !img.overlay) {
                    channelQuery.setInt(1, channelTypeId);
                    var17_25 = null;
                    try (ResultSet channel = channelQuery.executeQuery();){
                        if (channel.next()) {
                            img.channelName = img.channelName + " " + channel.getString(1);
                            if (this.lookupChannelIndex(img.channelName) < 0) {
                                Channel c = new Channel(img.channelName);
                                c.originalName = channel.getString(1);
                                c.exposureTime = channel.getDouble(2);
                                c.focusOffset = channel.getDouble(3);
                                c.intensity = channel.getDouble(4);
                                this.channels.add(c);
                            }
                            img.plane = this.lookupChannelIndex(img.channelName);
                            img.exposureTime = FormatTools.getTime(channel.getDouble(2), "\u00b5s");
                            img.timestamp = acqTimestamp;
                        }
                    }
                    catch (Throwable throwable) {
                        var17_25 = throwable;
                        throw throwable;
                    }
                }
                Integer[] ids = this.getWellLink(wellLinkQuery, resultId);
                String wellLabel = wells.get(ids[0]);
                img.wellRow = wellLabel.charAt(0) - 65;
                img.wellColumn = Integer.parseInt(wellLabel.substring(1)) - 1;
                img.series = ids[0] - 1;
                img.cycle = Math.max(1, ids[1]);
                this.maxCycle = Math.max(img.cycle, this.maxCycle);
                this.maxField = Math.max(img.field, this.maxField);
                this.images.add(img);
            }
        }
        PreparedStatement objectQuery = conn.prepareStatement("SELECT ImagingResultId, Path FROM ObjectList ORDER BY Id");
        try (ResultSet objects = objectQuery.executeQuery();){
            while (objects.next()) {
                String resultId = objects.getString(1);
                String path = objects.getString(2);
                LOGGER.debug("processing object {}", (Object)path);
                Integer[] ids = this.getWellLink(wellLinkQuery, resultId);
                if (ids == null) continue;
                String wellLabel = wells.get(ids[0]);
                Image img = new Image();
                img.wellRow = wellLabel.charAt(0) - 65;
                img.wellColumn = Integer.parseInt(wellLabel.substring(1)) - 1;
                img.series = ids[0] - 1;
                img.cycle = Math.max(1, ids[1]);
                img.result = true;
                img.file = path;
                this.images.add(img);
            }
        }
    }

    private Integer[] getWellLink(PreparedStatement linkQuery, String imagingResultID) throws SQLException {
        linkQuery.setInt(1, Integer.parseInt(imagingResultID));
        try (ResultSet wellLink = linkQuery.executeQuery();){
            wellLink.next();
            Integer[] integerArray = new Integer[]{wellLink.getInt(1), wellLink.getInt(2)};
            return integerArray;
        }
    }

    private Image lookupImage(int series, int plane, boolean overlay, boolean result) {
        for (Image img : this.images) {
            if (img.series != series || img.plane != plane || img.overlay != overlay || img.result != result) continue;
            return img;
        }
        return null;
    }

    private int lookupChannelIndex(String name) {
        for (int i = 0; i < this.channels.size(); ++i) {
            if (!this.channels.get((int)i).name.equals(name) && !this.channels.get((int)i).originalName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private String getImageFile(String file2) {
        String sanitized = File.separator + file2;
        try {
            sanitized = File.separator + file2.replaceAll("\\\\", File.separator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new Location(this.imageDirectory + sanitized).getAbsolutePath();
    }

    private void findAllFiles(Location root, ArrayList<String> files) {
        if (root.isDirectory()) {
            String[] list;
            for (String file2 : list = root.list(true)) {
                Location path = new Location(root, file2);
                this.findAllFiles(path, files);
            }
        } else {
            files.add(root.getAbsolutePath());
        }
    }

    class Channel {
        public String name;
        public String originalName;
        public int index = -1;
        public double intensity;
        public double focusOffset;
        public double exposureTime;

        public Channel(String name) {
            this.name = name;
        }
    }

    class Image {
        public String file;
        public int wellRow = -1;
        public int wellColumn = -1;
        public int field = 1;
        public int cycle = -1;
        public int series = -1;
        public int plane = -1;
        public Length pixelSize;
        public Time exposureTime;
        public String channelName;
        public boolean overlay = false;
        public boolean result = false;
        public String timestamp;

        Image() {
        }
    }
}

