/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import ome.xml.meta.MetadataConverter;

public class ChannelSeparator
extends ReaderWrapper {
    private byte[] lastImage;
    private int lastImageIndex = -1;
    private int lastImageSeries = -1;
    private int lastImageX = -1;
    private int lastImageY = -1;
    private int lastImageWidth = -1;
    private int lastImageHeight = -1;

    public static ChannelSeparator makeChannelSeparator(IFormatReader r) {
        if (r instanceof ChannelSeparator) {
            return (ChannelSeparator)r;
        }
        return new ChannelSeparator(r);
    }

    public ChannelSeparator() {
    }

    public ChannelSeparator(IFormatReader r) {
        super(r);
    }

    public int getOriginalIndex(int no) {
        int originalCount;
        int imageCount = this.getImageCount();
        if (imageCount == (originalCount = this.reader.getImageCount())) {
            return no;
        }
        int[] coords = this.getZCTCoords(no);
        coords[1] = coords[1] / this.reader.getRGBChannelCount();
        return this.reader.getIndex(coords[0], coords[1], coords[2]);
    }

    @Override
    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.reader.isRGB() && !this.reader.isIndexed() ? this.reader.getRGBChannelCount() * this.reader.getImageCount() : this.reader.getImageCount();
    }

    @Override
    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = super.getDimensionOrder();
        if (this.reader.isRGB() && !this.reader.isIndexed()) {
            String newOrder = "XYC";
            newOrder = order.indexOf(90) > order.indexOf(84) ? newOrder + "TZ" : newOrder + "ZT";
            return newOrder;
        }
        return order;
    }

    @Override
    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.isIndexed() && !this.isFalseColor() && this.getSizeC() > 1;
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        byte[] buf = DataTools.allocate(w, h2, FormatTools.getBytesPerPixel(this.getPixelType()));
        return this.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        FormatTools.checkPlaneNumber(this, no);
        if (this.reader.isRGB() && !this.reader.isIndexed()) {
            int c = this.getSizeC() / this.reader.getEffectiveSizeC();
            int source = this.getOriginalIndex(no);
            int channel = no % c;
            int series = this.getCoreIndex();
            int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
            if (source != this.lastImageIndex || series != this.lastImageSeries || x != this.lastImageX || y != this.lastImageY || w != this.lastImageWidth || h2 != this.lastImageHeight) {
                long planeSize;
                int strips = 1;
                Runtime rt = Runtime.getRuntime();
                long availableMemory = rt.freeMemory();
                if (availableMemory < (planeSize = DataTools.safeMultiply64(w, h2, bpp, c)) || planeSize > Integer.MAX_VALUE) {
                    strips = (int)Math.sqrt(h2);
                }
                int stripHeight = h2 / strips;
                int lastStripHeight = stripHeight + (h2 - stripHeight * strips);
                byte[] strip = strips == 1 ? buf : new byte[stripHeight * w * bpp];
                for (int i = 0; i < strips; ++i) {
                    this.lastImage = this.reader.openBytes(source, x, y + i * stripHeight, w, i == strips - 1 ? lastStripHeight : stripHeight);
                    this.lastImageIndex = source;
                    this.lastImageSeries = series;
                    this.lastImageX = x;
                    this.lastImageY = y + i * stripHeight;
                    this.lastImageWidth = w;
                    int n = this.lastImageHeight = i == strips - 1 ? lastStripHeight : stripHeight;
                    if (strips != 1 && lastStripHeight != stripHeight && i == strips - 1) {
                        strip = new byte[lastStripHeight * w * bpp];
                    }
                    ImageTools.splitChannels(this.lastImage, strip, channel, c, bpp, false, this.isInterleaved(), strips == 1 ? w * h2 * bpp : strip.length);
                    if (strips == 1) continue;
                    System.arraycopy(strip, 0, buf, i * stripHeight * w * bpp, strip.length);
                }
            } else {
                ImageTools.splitChannels(this.lastImage, buf, channel, c, bpp, false, this.isInterleaved(), w * h2 * bpp);
            }
            return buf;
        }
        return this.reader.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        int source = this.getOriginalIndex(no);
        byte[] thumb = this.reader.openThumbBytes(source);
        int c = this.getSizeC() / this.reader.getEffectiveSizeC();
        int channel = no % c;
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        return ImageTools.splitChannels(thumb, channel, c, bpp, false, this.reader.isInterleaved());
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lastImage = null;
            this.lastImageIndex = -1;
            this.lastImageSeries = -1;
            this.lastImageX = -1;
            this.lastImageY = -1;
            this.lastImageWidth = -1;
            this.lastImageHeight = -1;
        }
    }

    @Override
    public int getIndex(int z, int c, int t2) {
        return FormatTools.getIndex(this, z, c, t2);
    }

    @Override
    public int getIndex(int z, int c, int t2, int moduloZ, int moduloC, int moduloT) {
        return FormatTools.getIndex(this, z, c, t2, moduloZ, moduloC, moduloT);
    }

    @Override
    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }

    @Override
    public int[] getZCTModuloCoords(int index) {
        return FormatTools.getZCTModuloCoords(this, index);
    }

    @Override
    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelSeparator does not support pre-compressed tile access");
    }

    @Override
    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelSeparator does not support pre-compressed tile access");
    }

    @Override
    public Codec getTileCodec(int no) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelSeparator does not support pre-compressed tile access");
    }

    @Override
    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelSeparator does not support pre-compressed tile access");
    }

    @Override
    public Class<?> getNativeDataType() {
        return byte[].class;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
        this.lastImageX = -1;
        this.lastImageY = -1;
        this.lastImageWidth = -1;
        this.lastImageHeight = -1;
        MetadataStore store = this.getMetadataStore();
        boolean pixelsPopulated = false;
        if (store instanceof MetadataRetrieve) {
            MetadataRetrieve retrieve = (MetadataRetrieve)((Object)store);
            for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
                int cIndex;
                this.setSeries(s2);
                int rgbChannels = this.getSizeC() / this.reader.getEffectiveSizeC();
                if (rgbChannels == 1) continue;
                for (int c = 0; c < this.reader.getEffectiveSizeC() && (cIndex = c * rgbChannels) < retrieve.getChannelCount(s2); ++c) {
                    if (!pixelsPopulated) {
                        MetadataTools.populatePixelsOnly(store, this);
                        pixelsPopulated = true;
                    }
                    for (int i = 1; i < rgbChannels; ++i) {
                        MetadataConverter.convertChannels(retrieve, s2, cIndex, store, s2, cIndex + i, false);
                    }
                }
            }
            this.setSeries(0);
        }
    }
}

