/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class TillVisionReader
extends FormatReader {
    private static final byte[] MARKER_0 = new byte[]{-128, 3, 0};
    private static final byte[] MARKER_1 = new byte[]{-127, 3, 0};
    private static final byte[] MARKER_2 = new byte[]{67, 73, 109, 97, 103, 101, 3, 0};
    private static final byte[] MARKER_3 = new byte[]{-125, 3, 0};
    private static final byte[] DESCRIPTION_MARKER = new byte[]{0, 0, 0, 0, 0, -1};
    private static final String[] DATE_FORMATS = new String[]{"mm/dd/yy HH:mm:ss aa", "mm/dd/yy HH:mm:ss aa", "mm/dd/yy", "HH:mm:ss aa", "HH:mm:ss aa"};
    private String[] pixelsFiles;
    private transient RandomAccessInputStream pixelsStream;
    private Map<Integer, Double> exposureTimes;
    private boolean embeddedImages;
    private long[] embeddedOffset;
    private String[] infFiles;
    private final List<String> imageNames = new ArrayList<String>();
    private final List<String> types = new ArrayList<String>();
    private final List<String> dates = new ArrayList<String>();

    public TillVisionReader() {
        super("TillVision", new String[]{"vws", "pst", "inf"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .vws file and possibly one similarly-named directory";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (TillVisionReader.checkSuffix(name, "vws") || TillVisionReader.checkSuffix(name, "pst")) {
            return true;
        }
        String pstFile = name;
        if (name.indexOf(46) != -1) {
            pstFile = pstFile.substring(0, pstFile.lastIndexOf("."));
        }
        pstFile = pstFile + ".pst";
        return new Location(pstFile).exists();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int plane = FormatTools.getPlaneSize(this);
        if (this.embeddedImages) {
            this.in.seek(this.embeddedOffset[this.getCoreIndex()] + (long)(no * plane));
            this.readPlane(this.in, x, y, w, h2, buf);
        } else {
            this.pixelsStream = new RandomAccessInputStream(this.pixelsFiles[this.getCoreIndex()]);
            if ((long)((no + 1) * plane) <= this.pixelsStream.length()) {
                this.pixelsStream.seek(no * plane);
                this.readPlane(this.pixelsStream, x, y, w, h2, buf);
            }
            this.pixelsStream.close();
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.pixelsStream != null) {
                this.pixelsStream.close();
            }
            this.pixelsStream = null;
            this.pixelsFiles = null;
            this.infFiles = null;
            this.embeddedOffset = null;
            this.embeddedImages = false;
            this.exposureTimes = null;
            this.imageNames.clear();
            this.types.clear();
            this.dates.clear();
        }
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return !new Location(id.replaceAll(".vws", ".pst")).exists();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        if (!noPixels && this.pixelsFiles[this.getCoreIndex()] != null) {
            files.add(this.pixelsFiles[this.getCoreIndex()]);
        }
        if (this.infFiles[this.getCoreIndex()] != null) {
            files.add(this.infFiles[this.getCoreIndex()]);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        void var11_31;
        if (!TillVisionReader.checkSuffix(id, "vws")) {
            Location pst = new Location(id).getAbsoluteFile();
            String name = pst.getParentFile().getName();
            Location parent = pst.getParentFile().getParentFile();
            Location vwsFile = new Location(parent, name.replaceAll(".pst", ".vws"));
            if (vwsFile.exists() && !vwsFile.isDirectory()) {
                id = vwsFile.getAbsolutePath();
            } else if (vwsFile.isDirectory()) {
                parent = pst.getParentFile();
                String[] list = parent.list(true);
                boolean foundVWS = false;
                for (Object object : list) {
                    if (!TillVisionReader.checkSuffix((String)object, "vws")) continue;
                    id = new Location(parent, (String)object).getAbsolutePath();
                    foundVWS = true;
                    break;
                }
                if (!foundVWS) {
                    throw new FormatException("Could not find .vws file.");
                }
            } else {
                throw new FormatException("Could not find .vws file.");
            }
        }
        super.initFile(id);
        this.exposureTimes = new HashMap<Integer, Double>();
        POIService poi = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        poi.initialize(id);
        Vector<String> documents = poi.getDocumentList();
        int nImages = 0;
        Hashtable<String, Object> tmpSeriesMetadata = new Hashtable<String, Object>();
        for (String name : documents) {
            LOGGER.debug("Reading {}", (Object)name);
            if (!name.equals("Root Entry" + File.separator + "Contents")) continue;
            RandomAccessInputStream s2 = poi.getDocumentStream(name);
            Throwable throwable = null;
            try {
                long offset;
                int n;
                s2.order(true);
                boolean specialCImage = false;
                boolean bl = false;
                Long[] cimages = null;
                Location dir = new Location(id).getAbsoluteFile().getParentFile();
                String[] list = dir.list(true);
                boolean hasPST = false;
                for (String f : list) {
                    if (!TillVisionReader.checkSuffix(f, "pst")) continue;
                    hasPST = true;
                    break;
                }
                if (!hasPST) {
                    cimages = this.findImages(s2);
                    int n2 = cimages.length;
                    if (n2 == 0) {
                        s2.seek(13L);
                        short len = s2.readShort();
                        String type = s2.readString(len);
                        if (type.equals("CImage")) {
                            n = 1;
                            cimages = new Long[]{s2.getFilePointer() + 6L};
                            specialCImage = true;
                        }
                    }
                    this.embeddedImages = n > 0;
                }
                LOGGER.debug("Images are {}embedded", (Object)(this.embeddedImages ? "" : "not "));
                if (this.embeddedImages) {
                    this.core.clear();
                    this.embeddedOffset = new long[n];
                    for (int i = 0; i < n; ++i) {
                        CoreMetadata ms = new CoreMetadata();
                        this.core.add(ms);
                        s2.seek(cimages[i]);
                        int len = s2.read();
                        String imageName = s2.readString(len);
                        this.imageNames.add(imageName);
                        if (specialCImage) {
                            s2.seek(1280L);
                        } else {
                            while (!s2.readString(2).equals("sB")) {
                                s2.seek(s2.getFilePointer() - 1L);
                            }
                        }
                        s2.skipBytes(20);
                        ms.sizeX = s2.readInt();
                        ms.sizeY = s2.readInt();
                        ms.sizeZ = s2.readInt();
                        ms.sizeC = s2.readInt();
                        ms.sizeT = s2.readInt();
                        ms.pixelType = this.convertPixelType(s2.readInt());
                        this.embeddedOffset[i] = specialCImage ? s2.getFilePointer() + 27L : s2.getFilePointer() + 31L;
                    }
                    if (this.in != null) {
                        this.in.close();
                    }
                    this.in = poi.getDocumentStream(name);
                    break;
                }
                s2.seek(0L);
                int lowerBound = 0;
                int upperBound = 4096;
                while (s2.getFilePointer() < s2.length() - 2L) {
                    LOGGER.debug("  Looking for image at {}", (Object)s2.getFilePointer());
                    s2.order(false);
                    int nextOffset = this.findNextOffset(s2);
                    if (nextOffset < 0 || (long)nextOffset >= s2.length()) break;
                    s2.seek(nextOffset);
                    s2.skipBytes(3);
                    int len = s2.readShort();
                    if (len <= 0) continue;
                    this.imageNames.add(s2.readString(len));
                    if (s2.getFilePointer() + 8L >= s2.length()) break;
                    s2.skipBytes(6);
                    s2.order(true);
                    len = s2.readShort();
                    if (nImages == 0 && len > upperBound * 2 && len < upperBound * 4) {
                        lowerBound = 512;
                        upperBound = 16384;
                    }
                    if (len < lowerBound || len > upperBound) continue;
                    s2.skipBytes(len);
                }
                s2.seek(0L);
                s2.order(true);
                while (s2.getFilePointer() < s2.length() - 2L && (offset = (long)this.findNextOffset(s2, DESCRIPTION_MARKER)) >= 0L && offset < s2.length() - 2L) {
                    s2.seek(offset);
                    short len = s2.readShort();
                    if (len <= 0 || len > 4096) continue;
                    String description = s2.readString(len);
                    LOGGER.debug("Description: {}", (Object)description);
                    String dateTime = "";
                    String[] lines = description.split("[\r\n]");
                    boolean validLine = false;
                    for (String line : lines) {
                        int colon = (line = line.trim()).indexOf(58);
                        if (colon == -1 || line.startsWith(";")) continue;
                        validLine = true;
                        String key = line.substring(0, colon).trim();
                        String value = line.substring(colon + 1).trim();
                        String metaKey = "Series " + nImages + " " + key;
                        this.addMeta(metaKey, value, tmpSeriesMetadata);
                        if (key.equals("Start time of experiment")) {
                            dateTime = dateTime + " " + value;
                            continue;
                        }
                        if (key.equals("Date")) {
                            dateTime = value + " " + dateTime;
                            continue;
                        }
                        if (key.equals("Exposure time [ms]")) {
                            double exp = Double.parseDouble(value) / 1000.0;
                            this.exposureTimes.put(nImages, exp);
                            continue;
                        }
                        if (!key.equals("Image type")) continue;
                        this.types.add(value);
                    }
                    if (!(dateTime = dateTime.trim()).equals("")) {
                        boolean success = false;
                        for (String format : DATE_FORMATS) {
                            try {
                                dateTime = DateTools.formatDate(dateTime, format, ".");
                                success = true;
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        this.dates.add(success ? dateTime : "");
                    }
                    if (!validLine) continue;
                    ++nImages;
                }
            }
            catch (Throwable specialCImage) {
                throwable = specialCImage;
                throw specialCImage;
            }
            finally {
                if (s2 == null) continue;
                if (throwable != null) {
                    try {
                        s2.close();
                    }
                    catch (Throwable i) {
                        throwable.addSuppressed(i);
                    }
                    continue;
                }
                s2.close();
            }
        }
        Location directory = new Location(this.currentId).getAbsoluteFile().getParentFile();
        ArrayList<String> pixelsFile = new ArrayList<String>(nImages);
        if (!this.embeddedImages) {
            if (nImages == 0) {
                throw new FormatException("No images found.");
            }
            String[] files = directory.list(true);
            String name = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1, this.currentId.lastIndexOf("."));
            for (String f : files) {
                Location pst;
                if (!TillVisionReader.checkSuffix(f, "pst") || !(pst = new Location(directory, f)).isDirectory() || !f.startsWith(name)) continue;
                Object[] subfiles = pst.list(true);
                Arrays.sort(subfiles);
                for (Object q : subfiles) {
                    if (!TillVisionReader.checkSuffix((String)q, "pst")) continue;
                    String path = f + File.separator + (String)q;
                    if (pixelsFile.size() >= nImages) {
                        LOGGER.warn("Adding {}, no matching acquisition metadata", (Object)path);
                    }
                    pixelsFile.add(path);
                }
            }
            if (pixelsFile.size() == 0) {
                for (String f : files) {
                    if (!TillVisionReader.checkSuffix(f, "pst")) continue;
                    pixelsFile.add(new Location(directory, f).getAbsolutePath());
                }
                if (pixelsFile.size() == 0) {
                    throw new FormatException("No image files found.");
                }
            }
        }
        pixelsFile.sort(null);
        int nSeries = this.core.size();
        if (!this.embeddedImages) {
            this.core.clear();
            nSeries = pixelsFile.size();
        }
        this.pixelsFiles = new String[nSeries];
        this.infFiles = new String[nSeries];
        Object[] metadataKeys = tmpSeriesMetadata.keySet().toArray();
        IniParser parser = new IniParser();
        boolean bl = false;
        while (var11_31 < nSeries) {
            CoreMetadata ms;
            if (!this.embeddedImages) {
                String inf;
                ms = new CoreMetadata();
                this.core.add(ms);
                this.setSeries((int)var11_31);
                String file2 = (String)pixelsFile.get((int)var11_31);
                file2 = file2.replace('/', File.separatorChar);
                String oldFile = file2 = file2.replace('\\', File.separatorChar);
                Location f = new Location(directory, oldFile);
                if (!f.exists() && !(f = new Location(directory, oldFile = oldFile.substring(oldFile.lastIndexOf(File.separator) + 1))).exists()) {
                    throw new FormatException("Could not find pixels file '" + file2);
                }
                this.pixelsFiles[var11_31] = file2 = f.getAbsolutePath();
                int dot = file2.lastIndexOf(".");
                this.infFiles[var11_31] = inf = file2.substring(0, dot) + ".inf";
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inf), "UTF-8"));
                IniList data = parser.parseINI(reader);
                reader.close();
                IniTable infoTable = data.getTable("Info");
                ms.sizeX = Integer.parseInt((String)infoTable.get("Width"));
                ms.sizeY = Integer.parseInt((String)infoTable.get("Height"));
                ms.sizeC = Integer.parseInt((String)infoTable.get("Bands"));
                ms.sizeZ = Integer.parseInt((String)infoTable.get("Slices"));
                ms.sizeT = Integer.parseInt((String)infoTable.get("Frames"));
                int dataType = Integer.parseInt((String)infoTable.get("Datatype"));
                ms.pixelType = this.convertPixelType(dataType);
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    HashMap<String, String> iniMap = data.flattenIntoHashMap();
                    ms.seriesMetadata.putAll(iniMap);
                }
            } else {
                ms = (CoreMetadata)this.core.get((int)var11_31);
                this.setSeries((int)var11_31);
            }
            ms.imageCount = ms.sizeZ * ms.sizeC * ms.sizeT;
            ms.rgb = false;
            ms.littleEndian = true;
            ms.dimensionOrder = "XYCZT";
            ms.seriesMetadata = new Hashtable();
            for (Object key : metadataKeys) {
                String keyName = key.toString();
                if (!keyName.startsWith("Series " + (int)var11_31 + " ")) continue;
                keyName = keyName.replaceAll("Series " + (int)var11_31 + " ", "");
                ms.seriesMetadata.put(keyName, tmpSeriesMetadata.get(key));
            }
            ++var11_31;
        }
        this.setSeries(0);
        this.populateMetadataStore();
        poi.close();
        poi = null;
    }

    private void populateMetadataStore() throws FormatException {
        int i;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            String date;
            if (i < this.imageNames.size()) {
                store.setImageName(this.imageNames.get(i), i);
            }
            String string = date = i < this.dates.size() ? this.dates.get(i) : "";
            if (date == null || date.equals("")) continue;
            store.setImageAcquisitionDate(new Timestamp(date), i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.getSeriesCount(); ++i) {
                for (int q = 0; q < ((CoreMetadata)this.core.get((int)i)).imageCount; ++q) {
                    if (this.exposureTimes.get(i) == null) continue;
                    store.setPlaneExposureTime(new Time(this.exposureTimes.get(i), UNITS.SECOND), i, q);
                }
                if (i >= this.types.size()) continue;
                store.setExperimentID(MetadataTools.createLSID("Experiment", i), i);
                store.setExperimentType(MetadataTools.getExperimentType(this.types.get(i)), i);
            }
        }
    }

    private int convertPixelType(int type) throws FormatException {
        boolean signed = type % 2 == 1;
        int bytes = type / 2 + (signed ? 1 : 0);
        return FormatTools.pixelTypeFromBytes(bytes, signed, false);
    }

    private int findNextOffset(RandomAccessInputStream s2) throws IOException {
        long fp = s2.getFilePointer();
        int offset0 = this.findNextOffset(s2, MARKER_0);
        s2.seek(fp);
        int offset1 = this.findNextOffset(s2, MARKER_1);
        s2.seek(fp);
        int offset2 = this.findNextOffset(s2, MARKER_2);
        s2.seek(fp);
        int offset3 = this.findNextOffset(s2, MARKER_3);
        if (offset0 < 0) {
            offset0 = Integer.MAX_VALUE;
        }
        if (offset1 < 0) {
            offset1 = Integer.MAX_VALUE;
        }
        if (offset2 < 0) {
            offset2 = Integer.MAX_VALUE;
        }
        if (offset3 < 0) {
            offset3 = Integer.MAX_VALUE;
        }
        if (offset0 < offset1 && offset0 < offset2 && offset0 < offset3) {
            return offset0;
        }
        if (offset1 < offset0 && offset1 < offset2 && offset1 < offset3) {
            return offset1;
        }
        if (offset2 < offset1 && offset2 < offset0 && offset2 < offset3) {
            return offset2;
        }
        if (offset3 < offset1 && offset3 < offset0 && offset3 < offset2) {
            return offset3;
        }
        return -1;
    }

    private int findNextOffset(RandomAccessInputStream s2, byte[] marker) throws IOException {
        for (long i = s2.getFilePointer(); i < s2.length() - (long)marker.length; ++i) {
            s2.seek(i);
            boolean found = true;
            for (int q = 0; q < marker.length; ++q) {
                if (marker[q] == s2.readByte()) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return (int)(i + (long)marker.length);
        }
        return -1;
    }

    private Long[] findImages(RandomAccessInputStream s2) throws IOException {
        ArrayList<Long> offsets = new ArrayList<Long>();
        byte[] buf = new byte[8192];
        int overlap = 128;
        s2.read(buf, 0, overlap);
        while (s2.getFilePointer() < s2.length()) {
            s2.read(buf, overlap, buf.length - overlap);
            for (int i = 0; i < buf.length - overlap; ++i) {
                byte len;
                String name;
                long offset;
                if (DataTools.bytesToInt(buf, i, 4, false) != -264241408 || DataTools.bytesToInt(buf, i + 4, 4, false) != 0 || DataTools.bytesToInt(buf, i + 8, 4, false) != 0 || DataTools.bytesToInt(buf, i + 12, 4, false) != 65280) continue;
                int pointer = i + 22;
                short length = DataTools.bytesToShort(buf, pointer, 2, true);
                if (length == 6 && new String(buf, pointer + 2, (int)length, "UTF-8").equals("CImage")) {
                    pointer += length + 4;
                }
                if (DataTools.bytesToInt(buf, pointer, 4, false) != 0x8000400 || offsets.contains(offset = s2.getFilePointer() - (long)buf.length + (long)pointer + 4L) || (name = new String(buf, pointer + 5, (int)(len = buf[pointer + 4]), "UTF-8")).indexOf("Palette") >= 0) continue;
                offsets.add(offset);
            }
            System.arraycopy(buf, buf.length - overlap, buf, 0, overlap);
        }
        return offsets.toArray(new Long[offsets.size()]);
    }
}

