/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.LosslessJPEGCodec;
import loci.formats.in.APNGReader;
import loci.formats.in.BMPReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.xml.model.primitives.Timestamp;

public class CellSensReader
extends FormatReader {
    public static final String FAIL_ON_MISSING_KEY = "cellsens.fail_on_missing_ets";
    public static final boolean FAIL_ON_MISSING_DEFAULT = false;
    private static final int RAW = 0;
    private static final int JPEG = 2;
    private static final int JPEG_2000 = 3;
    private static final int JPEG_LOSSLESS = 5;
    private static final int PNG = 8;
    private static final int BMP = 9;
    private static final int CHAR = 1;
    private static final int UCHAR = 2;
    private static final int SHORT = 3;
    private static final int USHORT = 4;
    private static final int INT = 5;
    private static final int UINT = 6;
    private static final int LONG = 7;
    private static final int ULONG = 8;
    private static final int FLOAT = 9;
    private static final int DOUBLE = 10;
    private static final int COMPLEX = 11;
    private static final int BOOLEAN = 12;
    private static final int TCHAR = 13;
    private static final int DWORD = 14;
    private static final int TIMESTAMP = 17;
    private static final int DATE = 18;
    private static final int INT_2 = 256;
    private static final int INT_3 = 257;
    private static final int INT_4 = 258;
    private static final int INT_RECT = 259;
    private static final int DOUBLE_2 = 260;
    private static final int DOUBLE_3 = 261;
    private static final int DOUBLE_4 = 262;
    private static final int DOUBLE_RECT = 263;
    private static final int DOUBLE_2_2 = 264;
    private static final int DOUBLE_3_3 = 265;
    private static final int DOUBLE_4_4 = 266;
    private static final int INT_INTERVAL = 267;
    private static final int DOUBLE_INTERVAL = 268;
    private static final int RGB = 269;
    private static final int BGR = 270;
    private static final int FIELD_TYPE = 271;
    private static final int MEM_MODEL = 272;
    private static final int COLOR_SPACE = 273;
    private static final int INT_ARRAY_2 = 274;
    private static final int INT_ARRAY_3 = 275;
    private static final int INT_ARRAY_4 = 276;
    private static final int INT_ARRAY_5 = 277;
    private static final int DOUBLE_ARRAY_2 = 279;
    private static final int DOUBLE_ARRAY_3 = 280;
    private static final int UNICODE_TCHAR = 8192;
    private static final int DIM_INDEX_1 = 8195;
    private static final int DIM_INDEX_2 = 8199;
    private static final int VOLUME_INDEX = 8200;
    private static final int PIXEL_INFO_TYPE = 8470;
    private static final int NEW_VOLUME_HEADER = 0;
    private static final int PROPERTY_SET_VOLUME = 1;
    private static final int NEW_MDIM_VOLUME_HEADER = 2;
    private static final int TIFF_IFD = 10;
    private static final int VECTOR_DATA = 11;
    private static final int COLLECTION_VOLUME = 2000;
    private static final int MULTIDIM_IMAGE_VOLUME = 2001;
    private static final int IMAGE_FRAME_VOLUME = 2002;
    private static final int DIMENSION_SIZE = 2003;
    private static final int IMAGE_COLLECTION_PROPERTIES = 2004;
    private static final int MULTIDIM_STACK_PROPERTIES = 2005;
    private static final int FRAME_PROPERTIES = 2006;
    private static final int DIMENSION_DESCRIPTION_VOLUME = 2007;
    private static final int CHANNEL_PROPERTIES = 2008;
    private static final int DISPLAY_MAPPING_VOLUME = 2011;
    private static final int LAYER_INFO_PROPERTIES = 2012;
    private static final int CHANNEL_INFO_PROPERTIES = 2013;
    private static final int DEFAULT_SAMPLE_IFD = 2016;
    private static final int VECTOR_LAYER_VOLUME = 2017;
    private static final int EXTERNAL_FILE_PROPERTIES = 2018;
    private static final int COARSE_FRAME_IFD = 2019;
    private static final int COARSE_PYRAMID_LEVEL = 2022;
    private static final int SERIALIZED_MASK = 2023;
    private static final int UNKNOWN_BLOBS_VOLUME = 2024;
    private static final int SAMPLE_ID_LIST = 2027;
    private static final int EXTRA_SAMPLES = 2028;
    private static final int EXTRA_SAMPLES_PROPERTIES = 2029;
    private static final int SAMPLE_FLAGS_LIST = 2030;
    private static final int FRAME_TYPE = 2031;
    private static final int DEFAULT_BACKGROUND_COLOR = 2034;
    private static final int VERSION_NUMBER = 2035;
    private static final int DOCUMENT_PROPERTIES = 2109;
    private static final int DOCUMENT_NAME = 11;
    private static final int DOCUMENT_NOTE = 13;
    private static final int DOCUMENT_TIME = 14;
    private static final int DOCUMENT_AUTHOR = 15;
    private static final int DOCUMENT_COMPANY = 16;
    private static final int DOCUMENT_CREATOR_NAME = 17;
    private static final int DOCUMENT_CREATOR_MAJOR_VERSION = 18;
    private static final int DOCUMENT_CREATOR_MINOR_VERSION = 19;
    private static final int DOCUMENT_CREATOR_SUB_VERSION = 20;
    private static final int DOCUMENT_CREATOR_BUILD_NUMBER = 21;
    private static final int DOCUMENT_CREATOR_PACKAGE = 22;
    private static final int DOCUMENT_PRODUCT = 23;
    private static final int DOCUMENT_PRODUCT_NAME = 24;
    private static final int DOCUMENT_PRODUCT_VERSION = 25;
    private static final int DOCUMENT_TYPE_HINT = 27;
    private static final int DOCUMENT_THUMB = 28;
    private static final int SLIDE_PROPERTIES = 2062;
    private static final int SLIDE_SPECIMEN = 2055;
    private static final int SLIDE_TISSUE = 2057;
    private static final int SLIDE_PREPARATION = 2058;
    private static final int SLIDE_STAINING = 2059;
    private static final int SLIDE_INFO = 2060;
    private static final int SLIDE_NAME = 2061;
    private static final int DYNAMIC_PROPERTIES = 27300;
    private static final int MAGNIFICATION = 0x40000000;
    private static final int IMAGE_BOUNDARY = 2053;
    private static final int TILE_SYSTEM = 20004;
    private static final int HAS_EXTERNAL_FILE = 20005;
    private static final int EXTERNAL_DATA_VOLUME = 20025;
    private static final int TILE_ORIGIN = 2410;
    private static final int EXPOSURE_TIME = 100002;
    private static final int CAMERA_GAIN = 100003;
    private static final int CAMERA_OFFSET = 100004;
    private static final int CAMERA_GAMMA = 100005;
    private static final int SHARPNESS = 100006;
    private static final int RED_GAIN = 100007;
    private static final int GREEN_GAIN = 100008;
    private static final int BLUE_GAIN = 100009;
    private static final int RED_OFFSET = 100010;
    private static final int GREEN_OFFSET = 100011;
    private static final int BLUE_OFFSET = 100012;
    private static final int SHADING_SUB = 100013;
    private static final int SHADING_MUL = 100014;
    private static final int X_BINNING = 100015;
    private static final int Y_BINNING = 100016;
    private static final int CLIPPING = 100017;
    private static final int MIRROR_H = 100023;
    private static final int MIRROR_V = 100024;
    private static final int CLIPPING_STATE = 100025;
    private static final int ICC_ENABLED = 100030;
    private static final int BRIGHTNESS = 100031;
    private static final int CONTRAST = 100032;
    private static final int CONTRAST_TARGET = 100033;
    private static final int ACCUMULATION = 100034;
    private static final int AVERAGING = 100035;
    private static final int ISO_SENSITIVITY = 100038;
    private static final int ACCUMULATION_MODE = 100039;
    private static final int AUTOEXPOSURE = 100043;
    private static final int EXPOSURE_METERING_MODE = 100044;
    private static final int FRAME_SIZE = 100048;
    private static final int BIT_DEPTH = 100049;
    private static final int HDRI_ON = 100055;
    private static final int HDRI_FRAMES = 100056;
    private static final int HDRI_EXPOSURE_RANGE = 100057;
    private static final int HDRI_MAP_MODE = 100058;
    private static final int CUSTOM_GRAYSCALE = 100059;
    private static final int SATURATION = 100060;
    private static final int WB_PRESET_ID = 100061;
    private static final int WB_PRESET_NAME = 100062;
    private static final int WB_MODE = 100063;
    private static final int CCD_SENSITIVITY = 100064;
    private static final int ENHANCED_DYNAMIC_RANGE = 100065;
    private static final int PIXEL_CLOCK = 100066;
    private static final int COLORSPACE = 100067;
    private static final int COOLING_ON = 100068;
    private static final int FAN_SPEED = 100069;
    private static final int TEMPERATURE_TARGET = 100070;
    private static final int GAIN_UNIT = 100071;
    private static final int EM_GAIN = 100072;
    private static final int PHOTON_IMAGING_MODE = 100073;
    private static final int FRAME_TRANSFER = 100074;
    private static final int ANDOR_SHIFT_SPEED = 100075;
    private static final int VCLOCK_AMPLITUDE = 100076;
    private static final int SPURIOUS_NOISE_REMOVAL = 100077;
    private static final int SIGNAL_OUTPUT = 100078;
    private static final int BASELINE_OFFSET_CLAMP = 100079;
    private static final int DP80_FRAME_CENTERING = 100080;
    private static final int HOT_PIXEL_CORRECTION = 100081;
    private static final int NOISE_REDUCTION = 100082;
    private static final int WIDER = 100083;
    private static final int PHOTOBLEACHING = 100084;
    private static final int PREAMP_GAIN_VALUE = 100085;
    private static final int WIDER_ENABLED = 100086;
    private static final int Z_START = 2012;
    private static final int Z_INCREMENT = 2013;
    private static final int Z_VALUE = 2014;
    private static final int TIME_START = 2100;
    private static final int TIME_INCREMENT = 2016;
    private static final int TIME_VALUE = 2017;
    private static final int LAMBDA_START = 2039;
    private static final int LAMBDA_INCREMENT = 2040;
    private static final int LAMBDA_VALUE = 2041;
    private static final int DIMENSION_NAME = 2021;
    private static final int DIMENSION_MEANING = 2023;
    private static final int DIMENSION_START_ID = 2025;
    private static final int DIMENSION_INCREMENT_ID = 2026;
    private static final int DIMENSION_VALUE_ID = 2027;
    private static final int CHANNEL_NAME = 2419;
    private static final int Z = 1;
    private static final int T = 2;
    private static final int LAMBDA = 3;
    private static final int C = 4;
    private static final int UNKNOWN = 5;
    private static final int PHASE = 9;
    private static final int DISPLAY_LIMITS = 2003;
    private static final int STACK_DISPLAY_LUT = 2004;
    private static final int GAMMA_CORRECTION = 2005;
    private static final int FRAME_ORIGIN = 2006;
    private static final int FRAME_SCALE = 2007;
    private static final int DISPLAY_COLOR = 2008;
    private static final int CREATION_TIME = 2015;
    private static final int RWC_FRAME_ORIGIN = 2018;
    private static final int RWC_FRAME_SCALE = 2019;
    private static final int RWC_FRAME_UNIT = 2020;
    private static final int STACK_NAME = 2030;
    private static final int CHANNEL_DIM = 2031;
    private static final int OPTICAL_PATH = 2043;
    private static final int STACK_TYPE = 2074;
    private static final int LIVE_OVERFLOW = 2076;
    private static final int IS_TRANSMISSION = 20035;
    private static final int CONTRAST_BRIGHTNESS = 10047;
    private static final int ACQUISITION_PROPERTIES = 10048;
    private static final int GRADIENT_LUT = 10065;
    private static final int DEFAULT_IMAGE = 0;
    private static final int OVERVIEW_IMAGE = 1;
    private static final int SAMPLE_MASK = 2;
    private static final int FOCUS_IMAGE = 4;
    private static final int EFI_SHARPNESS_MAP = 8;
    private static final int EFI_HEIGHT_MAP = 16;
    private static final int EFI_TEXTURE_MAP = 32;
    private static final int EFI_STACK = 64;
    private static final int MACRO_IMAGE = 256;
    private static final int DISPLAY_PROCESSOR_TYPE = 10000;
    private static final int RENDER_OPERATION_ID = 10001;
    private static final int DISPLAY_STACK_ID = 10005;
    private static final int TRANSPARENCY_ID = 10006;
    private static final int THIRD_ID = 10007;
    private static final int DISPLAY_VISIBLE = 10008;
    private static final int TRANSPARENCY_VALUE = 10009;
    private static final int DISPLAY_LUT = 10013;
    private static final int DISPLAY_STACK_INDEX = 10014;
    private static final int CHANNEL_TRANSPARENCY_VALUE = 10018;
    private static final int CHANNEL_VISIBLE = 10025;
    private static final int SELECTED_CHANNELS = 10028;
    private static final int DISPLAY_GAMMA_CORRECTION = 10032;
    private static final int CHANNEL_GAMMA_CORRECTION = 10033;
    private static final int DISPLAY_CONTRAST_BRIGHTNESS = 10045;
    private static final int CHANNEL_CONTRAST_BRIGHTNESS = 10046;
    private static final int ACTIVE_STACK_DIMENSION = 10049;
    private static final int SELECTED_FRAMES = 10050;
    private static final int DISPLAYED_LUT_ID = 10054;
    private static final int HIDDEN_LAYER = 10056;
    private static final int LAYER_XY_FIXED = 10057;
    private static final int ACTIVE_LAYER_VECTOR = 10060;
    private static final int ACTIVE_LAYER_INDEX_VECTOR = 10061;
    private static final int CHAINED_LAYERS = 10062;
    private static final int LAYER_SELECTION = 10063;
    private static final int LAYER_SELECTION_INDEX = 10064;
    private static final int CANVAS_COLOR_1 = 10066;
    private static final int CANVAS_COLOR_2 = 10067;
    private static final int ORIGINAL_FRAME_RATE = 10069;
    private static final int USE_ORIGINAL_FRAME_RATE = 10070;
    private static final int ACTIVE_CHANNEL = 10071;
    private static final int PLANE_UNIT = 2011;
    private static final int Y_PLANE_DIMENSION_UNIT = 2063;
    private static final int Y_DIMENSION_UNIT = 2064;
    private static final int PLANE_ORIGIN_RWC = 20006;
    private static final int PLANE_SCALE_RWC = 20007;
    private static final int CHANNEL_OVERFLOW = 2073;
    private static final int OBJECTIVE_MAG = 120060;
    private static final int NUMERICAL_APERTURE = 120061;
    private static final int WORKING_DISTANCE = 120062;
    private static final int OBJECTIVE_NAME = 120063;
    private static final int OBJECTIVE_TYPE = 120064;
    private static final int REFRACTIVE_INDEX = 120079;
    private static final int DEVICE_NAME = 120116;
    private static final int DEVICE_ID = 120129;
    private static final int DEVICE_SUBTYPE = 120130;
    private static final int DEVICE_MANUFACTURER = 120133;
    private static final int VALUE = 0x10000002;
    private String[] usedFiles;
    private ArrayList<String> extraFiles = new ArrayList();
    private HashMap<Integer, String> fileMap = new HashMap();
    private TiffParser parser;
    private IFDList ifds;
    private ArrayList<Long[]> tileOffsets = new ArrayList();
    private boolean jpeg = false;
    private ArrayList<Integer> rows = new ArrayList();
    private ArrayList<Integer> cols = new ArrayList();
    private ArrayList<Integer> compressionType = new ArrayList();
    private ArrayList<Integer> tileX = new ArrayList();
    private ArrayList<Integer> tileY = new ArrayList();
    private ArrayList<ArrayList<TileCoordinate>> tileMap = new ArrayList();
    private ArrayList<Integer> nDimensions = new ArrayList();
    private boolean inDimensionProperties = false;
    private boolean foundChannelTag = false;
    private int dimensionTag;
    private HashMap<Integer, byte[]> backgroundColor = new HashMap();
    private int metadataIndex = -1;
    private int previousTag = 0;
    private ArrayList<Pyramid> pyramids = new ArrayList();
    private boolean[] bgr;
    private transient boolean expectETS = false;
    private transient int channelCount = 0;
    private transient int zCount = 0;

    public CellSensReader() {
        super("CellSens VSI", new String[]{"vsi", "ets"});
        this.domains = new String[]{"Histology"};
        this.suffixSufficient = true;
        this.datasetDescription = "One .vsi file and an optional directory with a similar name that contains at least one subdirectory with .ets files";
    }

    public boolean failOnMissingETS() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(FAIL_ON_MISSING_KEY, false);
        }
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return this.extraFiles.toArray(new String[this.extraFiles.size()]);
        }
        String[] allFiles = new String[this.extraFiles.size() + this.usedFiles.length];
        System.arraycopy(this.usedFiles, 0, allFiles, 0, this.usedFiles.length);
        for (int i = 0; i < this.extraFiles.size(); ++i) {
            allFiles[this.usedFiles.length + i] = this.extraFiles.get(i);
        }
        return allFiles;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCoreIndex() < this.core.size() - 1 && this.getCoreIndex() < this.tileX.size()) {
            return this.tileX.get(this.getCoreIndex());
        }
        try {
            return (int)((IFD)this.ifds.get(this.getIFDIndex())).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCoreIndex() < this.core.size() - 1 && this.getCoreIndex() < this.tileY.size()) {
            return this.tileY.get(this.getCoreIndex());
        }
        try {
            return (int)((IFD)this.ifds.get(this.getIFDIndex())).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentIndex = this.getCoreIndex();
        int thumbSize = this.getThumbSizeX() * this.getThumbSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()) * this.getRGBChannelCount();
        if (this.getCoreIndex() >= this.fileMap.size() || this.usedFiles.length >= this.core.size()) {
            return super.openThumbBytes(no);
        }
        this.setCoreIndex(this.fileMap.size());
        byte[] thumb = FormatTools.openThumbBytes(this, 0);
        this.setCoreIndex(currentIndex);
        if (thumb.length == thumbSize) {
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.getCoreIndex() < this.core.size() - 1 && this.getCoreIndex() < this.rows.size()) {
            int tileRows = this.rows.get(this.getCoreIndex());
            int tileCols = this.cols.get(this.getCoreIndex());
            Region image = new Region(x, y, w, h2);
            int outputRow = 0;
            int outputCol = 0;
            Region intersection = null;
            byte[] tileBuf = null;
            int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
            int pixel = this.getRGBChannelCount() * bpp;
            int outputRowLen = w * pixel;
            Pyramid pyramid = this.getCurrentPyramid();
            for (int row = 0; row < tileRows; ++row) {
                for (int col = 0; col < tileCols; ++col) {
                    int width = this.tileX.get(this.getCoreIndex());
                    int height = this.tileY.get(this.getCoreIndex());
                    Region tile = new Region(col * width, row * height, width, height);
                    if (pyramid.tileOriginX != null && pyramid.tileOriginY != null) {
                        int resScale = (int)Math.pow(2.0, this.getResolutionIndex());
                        tile.x += pyramid.tileOriginX / resScale;
                        tile.y += pyramid.tileOriginY / resScale;
                    }
                    if (!tile.intersects(image)) continue;
                    intersection = tile.intersection(image);
                    int intersectionX = 0;
                    if (tile.x < image.x) {
                        intersectionX = image.x - tile.x;
                    }
                    tileBuf = this.decodeTile(no, row, col);
                    int rowLen = pixel * Math.min(intersection.width, width);
                    int outputOffset = outputRow * outputRowLen + outputCol;
                    for (int trow = 0; trow < intersection.height; ++trow) {
                        int realRow = trow + intersection.y - tile.y;
                        int inputOffset = pixel * (realRow * width + intersectionX);
                        System.arraycopy(tileBuf, inputOffset, buf, outputOffset, rowLen);
                        outputOffset += outputRowLen;
                    }
                    outputCol += rowLen;
                }
                if (intersection == null) continue;
                outputRow += intersection.height;
                outputCol = 0;
            }
            if (this.bgr[this.getCurrentPyramidIndex()]) {
                ImageTools.bgrToRgb(buf, this.isInterleaved(), bpp, this.getRGBChannelCount());
            }
            return buf;
        }
        return this.parser.getSamples((IFD)this.ifds.get(this.getIFDIndex() + no), buf, x, y, w, h2);
    }

    @Override
    public void reopenFile() throws IOException {
        super.reopenFile();
        this.parser = new TiffParser(this.currentId);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.parser != null && this.parser.getStream() != null) {
                this.parser.getStream().close();
            }
            this.parser = null;
            this.ifds = null;
            this.usedFiles = null;
            this.extraFiles.clear();
            this.fileMap.clear();
            this.tileOffsets.clear();
            this.jpeg = false;
            this.rows.clear();
            this.cols.clear();
            this.compressionType.clear();
            this.tileX.clear();
            this.tileY.clear();
            this.tileMap.clear();
            this.nDimensions.clear();
            this.inDimensionProperties = false;
            this.foundChannelTag = false;
            this.dimensionTag = 0;
            this.backgroundColor.clear();
            this.metadataIndex = -1;
            this.previousTag = 0;
            this.expectETS = false;
            this.pyramids.clear();
            this.channelCount = 0;
            this.zCount = 0;
            this.bgr = null;
        }
    }

    @Override
    protected ArrayList<String> getAvailableOptions() {
        ArrayList<String> optionsList = super.getAvailableOptions();
        optionsList.add(FAIL_ON_MISSING_KEY);
        return optionsList;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!CellSensReader.checkSuffix(id, "vsi")) {
            Location current = new Location(id).getAbsoluteFile();
            Location parent = current.getParentFile();
            parent = parent.getParentFile();
            Location grandparent = parent.getParentFile();
            String vsi = parent.getName();
            Location vsiFile = new Location(grandparent, vsi = vsi.substring(1, vsi.length() - 1) + ".vsi");
            if (!vsiFile.exists()) {
                throw new FormatException("Could not find .vsi file.");
            }
            this.initFile(vsiFile.getAbsolutePath());
            return;
        }
        super.initFile(id);
        this.parser = new TiffParser(id);
        this.ifds = this.parser.getMainIFDs();
        try (RandomAccessInputStream vsi = new RandomAccessInputStream(id);){
            vsi.order(this.parser.getStream().isLittleEndian());
            vsi.seek(8L);
            this.readTags(vsi, false, "");
        }
        ArrayList<String> files = new ArrayList<String>();
        Location file2 = new Location(id).getAbsoluteFile();
        Location dir = file2.getParentFile();
        String name = file2.getName();
        name = name.substring(0, name.lastIndexOf("."));
        files.add(file2.getAbsolutePath());
        Location pixelsDir = new Location(dir, "_" + name + "_");
        Object[] stackDirs = pixelsDir.list(true);
        if (stackDirs != null) {
            Arrays.sort(stackDirs);
            for (Object f : stackDirs) {
                Location stackDir = new Location(pixelsDir, (String)f);
                Object[] pixelsFiles = stackDir.list(true);
                if (pixelsFiles == null) continue;
                Arrays.sort(pixelsFiles);
                for (Object pixelsFile : pixelsFiles) {
                    if (CellSensReader.checkSuffix((String)pixelsFile, "ets") && ((String)pixelsFile).startsWith("frame_")) {
                        files.add(new Location(stackDir, (String)pixelsFile).getAbsolutePath());
                        continue;
                    }
                    this.extraFiles.add(new Location(stackDir, (String)pixelsFile).getAbsolutePath());
                }
            }
        }
        this.usedFiles = files.toArray(new String[files.size()]);
        if (this.expectETS && files.size() == 1) {
            String message = "Missing expected .ets files in " + pixelsDir.getAbsolutePath();
            if (this.failOnMissingETS()) {
                throw new FormatException(message);
            }
            LOGGER.warn(message);
        } else if (!this.expectETS && files.size() > 1) {
            LOGGER.warn(".ets files present but not expected");
        }
        int seriesCount = files.size();
        this.core.clear();
        int ignoredPyramids = 0;
        if (files.size() == 1) {
            for (Pyramid pyramid : this.pyramids) {
                if (pyramid.name.equalsIgnoreCase("Overview")) continue;
                ++ignoredPyramids;
            }
            seriesCount = this.ifds.size();
            if (this.ifds.size() > 1) {
                if (((IFD)this.ifds.get(1)).getSamplesPerPixel() == 1) {
                    seriesCount = 2;
                    if (this.channelCount == 0 && this.zCount == 0) {
                        this.channelCount = this.ifds.size() - 1;
                    } else if (this.zCount > 0) {
                        this.zCount /= 2;
                        this.channelCount = (this.ifds.size() - 1) / this.zCount;
                    }
                } else {
                    if (this.ifds.size() > 2) {
                        this.ifds.remove(2);
                    }
                    seriesCount = Math.min(3, this.ifds.size());
                }
            }
        }
        IFDList exifs = this.parser.getExifIFDs();
        this.bgr = new boolean[seriesCount];
        int index = 0;
        for (int s2 = 0; s2 < seriesCount; ++s2) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            if (s2 < files.size() - 1) {
                this.setCoreIndex(index);
                String ff = (String)files.get(s2 + 1);
                boolean hasOrphanEtsFiles = this.pyramids.size() < files.size() - 1;
                try (RandomAccessInputStream stream = new RandomAccessInputStream(ff);){
                    boolean validFrameFile = this.parseETSFile(stream, ff, s2, hasOrphanEtsFiles);
                    if (!validFrameFile) {
                        this.core.remove(this.core.size() - 1);
                        this.extraFiles.add((String)files.get(s2 + 1));
                        files.remove(s2 + 1);
                        this.usedFiles = files.toArray(new String[files.size()]);
                        --s2;
                        --seriesCount;
                        continue;
                    }
                }
                ms.littleEndian = this.compressionType.get(index) == 0;
                ms.interleaved = ms.rgb;
                for (int q = 1; q < ms.resolutionCount; ++q) {
                    int res = this.core.size() - ms.resolutionCount + q;
                    ((CoreMetadata)this.core.get((int)res)).littleEndian = ms.littleEndian;
                    ((CoreMetadata)this.core.get((int)res)).interleaved = ms.interleaved;
                }
                if (s2 == 0 && exifs.size() > 0) {
                    IFD exif = (IFD)exifs.get(0);
                    int newX = exif.getIFDIntValue(40962);
                    int newY = exif.getIFDIntValue(40963);
                    if (this.getSizeX() > newX || this.getSizeY() > newY) {
                        ms.sizeX = newX;
                        ms.sizeY = newY;
                    }
                }
                index += ms.resolutionCount;
                this.setCoreIndex(0);
                ms.dimensionOrder = "XYCZT";
            } else {
                IFD ifd = (IFD)this.ifds.get(s2 - files.size() + 1);
                PhotoInterp p = ifd.getPhotometricInterpretation();
                int samples = ifd.getSamplesPerPixel();
                ms.rgb = samples > 1 || p == PhotoInterp.RGB;
                ms.sizeX = (int)ifd.getImageWidth();
                ms.sizeY = (int)ifd.getImageLength();
                ms.sizeT = 1;
                int n = ms.sizeC = ms.rgb ? samples : 1;
                if (files.size() == 1 && this.channelCount > 0 && this.channelCount < this.ifds.size() && s2 > 0) {
                    ms.sizeC *= this.channelCount;
                    ms.sizeZ = (this.ifds.size() - 1) / this.channelCount;
                    ms.imageCount = this.ifds.size() - 1;
                    ms.dimensionOrder = "XYZCT";
                } else {
                    ms.sizeZ = 1;
                    ms.imageCount = 1;
                    ms.dimensionOrder = "XYCZT";
                }
                ms.littleEndian = ifd.isLittleEndian();
                ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                ms.pixelType = ifd.getPixelType();
                ms.interleaved = false;
                ms.falseColor = false;
                ms.thumbnail = s2 != 0;
                ++index;
            }
            ms.metadataComplete = true;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String instrument = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrument, 0);
        block25: for (int i = 0; i < this.pyramids.size(); ++i) {
            int q;
            Pyramid pyramid = this.pyramids.get(i);
            store.setObjectiveID(MetadataTools.createLSID("Objective", 0, i), 0, i);
            store.setObjectiveNominalMagnification(pyramid.magnification, 0, i);
            store.setObjectiveWorkingDistance(FormatTools.createLength(pyramid.workingDistance, UNITS.MICROMETER), 0, i);
            for (q = 0; q < pyramid.objectiveTypes.size(); ++q) {
                if (pyramid.objectiveTypes.get(q) != 1) continue;
                store.setObjectiveModel(pyramid.objectiveNames.get(q), 0, i);
                break;
            }
            store.setObjectiveLensNA(pyramid.numericalAperture, 0, i);
            store.setDetectorID(MetadataTools.createLSID("Detector", 0, i), 0, i);
            store.setDetectorOffset(pyramid.offset, 0, i);
            store.setDetectorGain(pyramid.gain, 0, i);
            for (q = 0; q < pyramid.deviceTypes.size(); ++q) {
                if (!pyramid.deviceTypes.get(q).equals("Camera")) continue;
                if (q < pyramid.deviceNames.size()) {
                    store.setDetectorModel(pyramid.deviceNames.get(q), 0, i);
                }
                if (q < pyramid.deviceIDs.size()) {
                    store.setDetectorSerialNumber(pyramid.deviceIDs.get(q), 0, i);
                }
                if (q < pyramid.deviceManufacturers.size()) {
                    store.setDetectorManufacturer(pyramid.deviceManufacturers.get(q), 0, i);
                }
                store.setDetectorType(MetadataTools.getDetectorType("CCD"), 0, i);
                continue block25;
            }
        }
        int nextPyramid = 0;
        for (int i = 0; i < this.core.size(); i += ((CoreMetadata)this.core.get((int)i)).resolutionCount) {
            this.setCoreIndex(i);
            Pyramid pyramid = null;
            if ((ignoredPyramids <= 0 || i >= this.core.size() - (this.pyramids.size() - ignoredPyramids)) && nextPyramid < this.pyramids.size()) {
                pyramid = this.pyramids.get(nextPyramid++);
            }
            int ii = this.coreIndexToSeries(i);
            if (pyramid != null) {
                int nextPlane = 0;
                int effectiveSizeC = ((CoreMetadata)this.core.get((int)i)).rgb ? 1 : ((CoreMetadata)this.core.get((int)i)).sizeC;
                int[] tzc = new int[]{((CoreMetadata)this.core.get((int)i)).sizeT, ((CoreMetadata)this.core.get((int)i)).sizeZ, ((CoreMetadata)this.core.get((int)i)).sizeC};
                for (int c = 0; c < effectiveSizeC; ++c) {
                    int wave;
                    store.setDetectorSettingsID(MetadataTools.createLSID("Detector", 0, nextPyramid - 1), ii, c);
                    store.setDetectorSettingsBinning(MetadataTools.getBinning(pyramid.binningX + "x" + pyramid.binningY), ii, c);
                    if (c == 0) {
                        store.setDetectorSettingsGain(pyramid.redGain, ii, c);
                        store.setDetectorSettingsOffset(pyramid.redOffset, ii, c);
                    } else if (c == 1) {
                        store.setDetectorSettingsGain(pyramid.greenGain, ii, c);
                        store.setDetectorSettingsOffset(pyramid.greenOffset, ii, c);
                    } else if (c == 2) {
                        store.setDetectorSettingsGain(pyramid.blueGain, ii, c);
                        store.setDetectorSettingsOffset(pyramid.blueOffset, ii, c);
                    }
                    if (c < pyramid.channelNames.size()) {
                        store.setChannelName(pyramid.channelNames.get(c), ii, c);
                    }
                    if (c < pyramid.channelWavelengths.size() && (wave = pyramid.channelWavelengths.get(c).intValue()) > 0) {
                        store.setChannelEmissionWavelength(FormatTools.getEmissionWavelength(Double.valueOf(wave)), ii, c);
                    }
                    for (int z = 0; z < ((CoreMetadata)this.core.get((int)i)).sizeZ; ++z) {
                        for (int t2 = 0; t2 < ((CoreMetadata)this.core.get((int)i)).sizeT; ++t2) {
                            nextPlane = this.getIndex(z, c, t2);
                            Long exp = pyramid.defaultExposureTime;
                            if (c < pyramid.exposureTimes.size()) {
                                exp = pyramid.exposureTimes.get(c);
                            } else if (c < pyramid.otherExposureTimes.size()) {
                                exp = pyramid.otherExposureTimes.get(c);
                            }
                            if (exp != null) {
                                store.setPlaneExposureTime(FormatTools.createTime((double)exp.longValue() / 1000000.0, UNITS.SECOND), ii, nextPlane);
                            }
                            store.setPlanePositionX(FormatTools.createLength(pyramid.originX, UNITS.MICROMETER), ii, nextPlane);
                            store.setPlanePositionY(FormatTools.createLength(pyramid.originY, UNITS.MICROMETER), ii, nextPlane);
                            if (z < pyramid.zValues.size()) {
                                store.setPlanePositionZ(FormatTools.createLength(pyramid.zValues.get(z), UNITS.MICROMETER), ii, nextPlane);
                            } else if (pyramid.zStart != null && pyramid.zIncrement != null) {
                                store.setPlanePositionZ(FormatTools.createLength(pyramid.zStart + (double)z * pyramid.zIncrement, UNITS.MICROMETER), ii, nextPlane);
                            }
                            store.setPixelsPhysicalSizeZ(FormatTools.getPhysicalSizeZ(pyramid.zIncrement), ii);
                            int reorderedPlane = FormatTools.positionToRaster(tzc, new int[]{t2, z, c});
                            if (reorderedPlane >= pyramid.tValues.size()) continue;
                            store.setPlaneDeltaT(FormatTools.createTime(pyramid.tValues.get(reorderedPlane), UNITS.MILLISECOND), ii, nextPlane);
                        }
                    }
                }
            }
            store.setImageInstrumentRef(instrument, ii);
            if (pyramid != null) {
                String imageName = pyramid.name;
                boolean duplicate = false;
                for (int q = 0; q < this.pyramids.size(); ++q) {
                    if (q == nextPyramid - 1 || !imageName.equals(this.pyramids.get((int)q).name)) continue;
                    duplicate = true;
                    break;
                }
                if (!imageName.equals("Overview") && !imageName.equals("Label") && duplicate) {
                    imageName = imageName + " #" + ii;
                }
                if (imageName.equals("Overview") || imageName.equals("Label")) {
                    imageName = imageName.toLowerCase();
                }
                store.setImageName(imageName, ii);
                store.setObjectiveSettingsID(MetadataTools.createLSID("Objective", 0, nextPyramid - 1), ii);
                store.setObjectiveSettingsRefractiveIndex(pyramid.refractiveIndex, ii);
                if (pyramid.physicalSizeX > 0.0) {
                    store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(pyramid.physicalSizeX), ii);
                }
                if (pyramid.physicalSizeY > 0.0) {
                    store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(pyramid.physicalSizeY), ii);
                }
                if (pyramid.acquisitionTime == null) continue;
                store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate(pyramid.acquisitionTime * 1000L, 0)), ii);
                continue;
            }
            store.setImageName("macro image", ii);
        }
        this.setCoreIndex(0);
    }

    private int getTileSize() {
        int channels = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int index = this.getCoreIndex();
        return bpp * channels * this.tileX.get(index) * this.tileY.get(index);
    }

    private int getCurrentPyramidIndex() {
        int resIndex = this.getResolution();
        int pyramidIndex = this.getSeries();
        if (this.hasFlattenedResolutions()) {
            int index = 0;
            pyramidIndex = 0;
            int i = 0;
            while (i < this.core.size()) {
                if (index + ((CoreMetadata)this.core.get((int)i)).resolutionCount <= this.getSeries()) {
                    index += ((CoreMetadata)this.core.get((int)i)).resolutionCount;
                    i += ((CoreMetadata)this.core.get((int)i)).resolutionCount;
                    ++pyramidIndex;
                    continue;
                }
                resIndex = this.getSeries() - index;
                break;
            }
        }
        return pyramidIndex;
    }

    private Pyramid getCurrentPyramid() {
        return this.pyramids.get(this.getCurrentPyramidIndex());
    }

    private int getResolutionIndex() {
        int resIndex = this.getResolution();
        if (this.hasFlattenedResolutions()) {
            int index = 0;
            for (int i = 0; i < this.core.size(); i += ((CoreMetadata)this.core.get((int)i)).resolutionCount) {
                if (index + ((CoreMetadata)this.core.get((int)i)).resolutionCount <= this.getSeries()) {
                    index += ((CoreMetadata)this.core.get((int)i)).resolutionCount;
                    continue;
                }
                resIndex = this.getSeries() - index;
                break;
            }
        }
        return resIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decodeTile(int no, int row, int col) throws FormatException, IOException {
        ArrayList<TileCoordinate> map;
        Integer index;
        if (this.tileMap.get(this.getCoreIndex()) == null) {
            return new byte[this.getTileSize()];
        }
        int[] zct = this.getZCTCoords(no);
        TileCoordinate t2 = new TileCoordinate(this.nDimensions.get(this.getCoreIndex()));
        t2.coordinate[0] = col;
        t2.coordinate[1] = row;
        int resIndex = this.getResolutionIndex();
        Pyramid pyramid = this.getCurrentPyramid();
        for (String dim : pyramid.dimensionOrdering.keySet()) {
            int index2 = pyramid.dimensionOrdering.get(dim) + 2;
            if (dim.equals("Z")) {
                t2.coordinate[index2] = zct[0];
                continue;
            }
            if (dim.equals("C")) {
                t2.coordinate[index2] = zct[1];
                continue;
            }
            if (!dim.equals("T")) continue;
            t2.coordinate[index2] = zct[2];
        }
        if (resIndex > 0) {
            t2.coordinate[t2.coordinate.length - 1] = resIndex;
        }
        if ((index = Integer.valueOf((map = this.tileMap.get(this.getCoreIndex())).indexOf(t2))) != null && index >= 0) {
            Long offset = this.tileOffsets.get(this.getCoreIndex())[index];
            byte[] buf = null;
            try (Closeable reader = null;
                 RandomAccessInputStream ets = new RandomAccessInputStream(this.fileMap.get(this.getCoreIndex()));){
                ets.seek(offset);
                CodecOptions options = new CodecOptions();
                options.interleaved = this.isInterleaved();
                options.littleEndian = this.isLittleEndian();
                int tileSize = this.getTileSize();
                if (tileSize == 0) {
                    tileSize = this.tileX.get(this.getCoreIndex()) * this.tileY.get(this.getCoreIndex()) * 10;
                }
                long end = index < this.tileOffsets.get(this.getCoreIndex()).length - 1 ? this.tileOffsets.get(this.getCoreIndex())[index + 1].longValue() : ets.length();
                int compression = this.compressionType.get(this.getCoreIndex());
                int compressedBufSize = compression == 8 || compression == 9 ? (int)(end - offset) : tileSize;
                byte[] compressedBuf = new byte[compressedBufSize];
                ets.read(compressedBuf);
                String file2 = null;
                switch (compression) {
                    case 0: {
                        buf = compressedBuf;
                        return buf;
                    }
                    case 2: {
                        JPEGCodec codec = new JPEGCodec();
                        buf = codec.decompress(compressedBuf, options);
                        return buf;
                    }
                    case 3: {
                        JPEG2000Codec codec = new JPEG2000Codec();
                        buf = codec.decompress(compressedBuf, options);
                        return buf;
                    }
                    case 5: {
                        LosslessJPEGCodec codec = new LosslessJPEGCodec();
                        buf = codec.decompress(compressedBuf, options);
                        return buf;
                    }
                    case 8: {
                        file2 = "tile.png";
                        reader = new APNGReader();
                    }
                    case 9: {
                        if (reader == null) {
                            file2 = "tile.bmp";
                            reader = new BMPReader();
                        }
                        Location.mapFile(file2, new ByteArrayHandle(compressedBuf));
                        reader.setId(file2);
                        buf = reader.openBytes(0);
                        Location.mapFile(file2, null);
                        return buf;
                    }
                }
                return buf;
            }
        }
        byte[] tile = new byte[this.getTileSize()];
        byte[] color = this.backgroundColor.get(this.getCoreIndex());
        if (color == null) return tile;
        int q = 0;
        while (q < this.getTileSize()) {
            for (int i = 0; i < color.length; ++i) {
                tile[q + i] = color[i];
            }
            q += color.length;
        }
        return tile;
    }

    private boolean parseETSFile(RandomAccessInputStream etsFile, String file2, int s2, boolean hasOrphanEtsFiles) throws FormatException, IOException {
        this.fileMap.put(this.core.size() - 1, file2);
        etsFile.order(true);
        CoreMetadata ms = (CoreMetadata)this.core.get(this.getCoreIndex());
        String magic = etsFile.readString(4).trim();
        if (!magic.equals("SIS")) {
            throw new FormatException("Unknown magic bytes: " + magic);
        }
        int headerSize = etsFile.readInt();
        int version = etsFile.readInt();
        this.nDimensions.add(etsFile.readInt());
        long additionalHeaderOffset = etsFile.readLong();
        int additionalHeaderSize = etsFile.readInt();
        etsFile.skipBytes(4);
        long usedChunkOffset = etsFile.readLong();
        int nUsedChunks = etsFile.readInt();
        etsFile.skipBytes(4);
        etsFile.seek(additionalHeaderOffset);
        String moreMagic = etsFile.readString(4).trim();
        if (!moreMagic.equals("ETS")) {
            throw new FormatException("Unknown magic bytes: " + moreMagic);
        }
        etsFile.skipBytes(4);
        int pixelType = etsFile.readInt();
        ms.sizeC = etsFile.readInt();
        int colorspace = etsFile.readInt();
        this.compressionType.add(etsFile.readInt());
        int compressionQuality = etsFile.readInt();
        this.tileX.add(etsFile.readInt());
        this.tileY.add(etsFile.readInt());
        int tileZ = etsFile.readInt();
        etsFile.skipBytes(68);
        byte[] color = new byte[ms.sizeC * FormatTools.getBytesPerPixel(this.convertPixelType(pixelType))];
        etsFile.read(color);
        this.backgroundColor.put(this.getCoreIndex(), color);
        etsFile.skipBytes(40 - color.length);
        int componentOrder = etsFile.readInt();
        this.bgr[s2] = componentOrder == 1 && this.compressionType.get(this.compressionType.size() - 1) == 0;
        boolean usePyramid = etsFile.readInt() != 0;
        ms.rgb = ms.sizeC > 1;
        etsFile.seek(usedChunkOffset);
        this.tileOffsets.add(new Long[nUsedChunks]);
        ArrayList<TileCoordinate> tmpTiles = new ArrayList<TileCoordinate>();
        for (int chunk = 0; chunk < nUsedChunks; ++chunk) {
            etsFile.skipBytes(4);
            int dimensions = this.nDimensions.get(this.nDimensions.size() - 1);
            TileCoordinate t2 = new TileCoordinate(dimensions);
            for (int i = 0; i < dimensions; ++i) {
                t2.coordinate[i] = etsFile.readInt();
            }
            this.tileOffsets.get((int)(this.tileOffsets.size() - 1))[chunk] = etsFile.readLong();
            int nBytes = etsFile.readInt();
            etsFile.skipBytes(4);
            tmpTiles.add(t2);
        }
        int maxResolution = 0;
        if (usePyramid) {
            for (TileCoordinate t2 : tmpTiles) {
                if (t2.coordinate[t2.coordinate.length - 1] <= maxResolution) continue;
                maxResolution = t2.coordinate[t2.coordinate.length - 1];
            }
        }
        int[] maxX = new int[++maxResolution];
        int[] maxY = new int[maxResolution];
        int[] maxZ = new int[maxResolution];
        int[] maxC = new int[maxResolution];
        int[] maxT = new int[maxResolution];
        HashMap<Object, Object> dimOrder = new HashMap();
        Pyramid pyramid = null;
        if (hasOrphanEtsFiles) {
            int maxXAtRes0 = 0;
            int maxYAtRes0 = 0;
            for (TileCoordinate t3 : tmpTiles) {
                if (usePyramid && t3.coordinate[t3.coordinate.length - 1] != 0) continue;
                maxXAtRes0 = Math.max(maxXAtRes0, t3.coordinate[0]);
                maxYAtRes0 = Math.max(maxYAtRes0, t3.coordinate[1]);
            }
            int maxPixelWidth = (maxXAtRes0 + 1) * this.tileX.get(this.tileX.size() - 1);
            int maxPixelHeight = (maxYAtRes0 + 1) * this.tileY.get(this.tileY.size() - 1);
            for (Pyramid p : this.pyramids) {
                if (p.HasAssociatedEtsFile || p.width > maxPixelWidth || p.width < maxPixelWidth - this.tileX.get(this.tileX.size() - 1) || p.height > maxPixelHeight || p.height < maxPixelHeight - this.tileY.get(this.tileY.size() - 1)) continue;
                pyramid = p;
                p.HasAssociatedEtsFile = true;
                break;
            }
            if (pyramid == null) {
                this.fileMap.remove(this.core.size() - 1);
                this.nDimensions.remove(this.nDimensions.size() - 1);
                this.compressionType.remove(this.compressionType.size() - 1);
                this.tileX.remove(this.tileX.size() - 1);
                this.tileY.remove(this.tileY.size() - 1);
                this.backgroundColor.remove(this.getCoreIndex());
                this.tileOffsets.remove(this.tileOffsets.size() - 1);
                return false;
            }
        } else {
            pyramid = this.pyramids.get(s2);
        }
        dimOrder = pyramid.dimensionOrdering;
        for (TileCoordinate t4 : tmpTiles) {
            int upperLimit;
            int cIndex;
            int resolution = usePyramid ? t4.coordinate[t4.coordinate.length - 1] : 0;
            Integer tv = (Integer)dimOrder.get("T");
            Integer zv = (Integer)dimOrder.get("Z");
            Integer cv = (Integer)dimOrder.get("C");
            int tIndex = tv == null ? -1 : tv + 2;
            int zIndex = zv == null ? -1 : zv + 2;
            int n = cIndex = cv == null ? -1 : cv + 2;
            if (usePyramid && tIndex == t4.coordinate.length - 1) {
                tv = null;
                tIndex = -1;
            }
            if (usePyramid && zIndex == t4.coordinate.length - 1) {
                zv = null;
                zIndex = -1;
            }
            int n2 = upperLimit = usePyramid ? t4.coordinate.length - 1 : t4.coordinate.length;
            if (!(tIndex >= 0 && tIndex < upperLimit || zIndex >= 0 && zIndex < upperLimit || cIndex >= 0 && cIndex < upperLimit)) {
                --tIndex;
                --zIndex;
                --cIndex;
                if (dimOrder.containsKey("T")) {
                    dimOrder.put("T", tIndex - 2);
                }
                if (dimOrder.containsKey("Z")) {
                    dimOrder.put("Z", zIndex - 2);
                }
                if (dimOrder.containsKey("C")) {
                    dimOrder.put("C", cIndex - 2);
                }
            }
            if (tv == null && zv == null) {
                if (t4.coordinate.length > 4 && cv == null) {
                    cIndex = 2;
                    dimOrder.put("C", cIndex - 2);
                }
                if (t4.coordinate.length > 4) {
                    tIndex = cv == null ? 3 : cIndex + 2;
                    if (tIndex < t4.coordinate.length) {
                        dimOrder.put("T", tIndex - 2);
                    } else {
                        tIndex = -1;
                    }
                }
                if (t4.coordinate.length > 5) {
                    zIndex = cv == null ? 4 : cIndex + 1;
                    if (zIndex < t4.coordinate.length) {
                        dimOrder.put("Z", zIndex - 2);
                    } else {
                        zIndex = -1;
                    }
                }
            }
            if (t4.coordinate[0] > maxX[resolution]) {
                maxX[resolution] = t4.coordinate[0];
            }
            if (t4.coordinate[1] > maxY[resolution]) {
                maxY[resolution] = t4.coordinate[1];
            }
            if (tIndex >= 0 && t4.coordinate[tIndex] > maxT[resolution]) {
                maxT[resolution] = t4.coordinate[tIndex];
            }
            if (zIndex >= 0 && t4.coordinate[zIndex] > maxZ[resolution]) {
                maxZ[resolution] = t4.coordinate[zIndex];
            }
            if (cIndex < 0 || t4.coordinate[cIndex] <= maxC[resolution]) continue;
            maxC[resolution] = t4.coordinate[cIndex];
        }
        ms.sizeX = pyramid.width;
        ms.sizeY = pyramid.height;
        ms.seriesMetadata = pyramid.originalMetadata;
        ms.sizeZ = maxZ[0] + 1;
        if (maxC[0] > 0) {
            ms.sizeC *= maxC[0] + 1;
        }
        ms.sizeT = maxT[0] + 1;
        if (ms.sizeZ == 0) {
            ms.sizeZ = 1;
        }
        ms.imageCount = ms.sizeZ * ms.sizeT;
        if (maxC[0] > 0) {
            ms.imageCount *= maxC[0] + 1;
        }
        if (maxY[0] >= 1) {
            this.rows.add(maxY[0] + 1);
        } else {
            this.rows.add(1);
        }
        if (maxX[0] >= 1) {
            this.cols.add(maxX[0] + 1);
        } else {
            this.cols.add(1);
        }
        ArrayList map = new ArrayList();
        for (int i = 0; i < tmpTiles.size(); ++i) {
            map.add(tmpTiles.get(i));
        }
        this.tileMap.add(map);
        ms.pixelType = this.convertPixelType(pixelType);
        if (usePyramid) {
            int finalResolution = 1;
            int initialCoreSize = this.core.size();
            for (int i = 1; i < maxResolution; ++i) {
                CoreMetadata newResolution = new CoreMetadata(ms);
                int previousX = ((CoreMetadata)this.core.get((int)(this.core.size() - 1))).sizeX;
                int previousY = ((CoreMetadata)this.core.get((int)(this.core.size() - 1))).sizeY;
                int maxSizeX = this.tileX.get(this.tileX.size() - 1) * (maxX[i] < 1 ? 1 : maxX[i] + 1);
                int maxSizeY = this.tileY.get(this.tileY.size() - 1) * (maxY[i] < 1 ? 1 : maxY[i] + 1);
                newResolution.sizeX = previousX / 2;
                if (previousX % 2 == 1 && newResolution.sizeX < maxSizeX) {
                    ++newResolution.sizeX;
                } else if (newResolution.sizeX > maxSizeX) {
                    newResolution.sizeX = maxSizeX;
                }
                newResolution.sizeY = previousY / 2;
                if (previousY % 2 == 1 && newResolution.sizeY < maxSizeY) {
                    ++newResolution.sizeY;
                } else if (newResolution.sizeY > maxSizeY) {
                    newResolution.sizeY = maxSizeY;
                }
                newResolution.sizeZ = maxZ[i] + 1;
                if (maxC[i] > 0 && newResolution.sizeC != maxC[i] + 1) {
                    newResolution.sizeC *= maxC[i] + 1;
                }
                newResolution.sizeT = maxT[i] + 1;
                if (newResolution.sizeZ == 0) {
                    newResolution.sizeZ = 1;
                }
                newResolution.imageCount = newResolution.sizeZ * newResolution.sizeT;
                if (maxC[i] > 0) {
                    newResolution.imageCount *= maxC[i] + 1;
                }
                newResolution.metadataComplete = true;
                newResolution.dimensionOrder = "XYCZT";
                this.core.add(newResolution);
                this.rows.add(maxY[i] >= 1 ? maxY[i] + 1 : 1);
                this.cols.add(maxX[i] >= 1 ? maxX[i] + 1 : 1);
                this.fileMap.put(this.core.size() - 1, file2);
                finalResolution = this.core.size() - initialCoreSize + 1;
                this.tileX.add(this.tileX.get(this.tileX.size() - 1));
                this.tileY.add(this.tileY.get(this.tileY.size() - 1));
                this.compressionType.add(this.compressionType.get(this.compressionType.size() - 1));
                this.tileMap.add(map);
                this.nDimensions.add(this.nDimensions.get(this.nDimensions.size() - 1));
                this.tileOffsets.add(this.tileOffsets.get(this.tileOffsets.size() - 1));
                this.backgroundColor.put(this.core.size() - 1, color);
            }
            ms.resolutionCount = finalResolution;
        }
        return true;
    }

    private int convertPixelType(int pixelType) throws FormatException {
        switch (pixelType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                throw new FormatException("Unsupported pixel type: long");
            }
            case 8: {
                throw new FormatException("Unsupported pixel type: unsigned long");
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 7;
            }
        }
        throw new FormatException("Unsupported pixel type: " + pixelType);
    }

    private void readTags(RandomAccessInputStream vsi, boolean populateMetadata, String tagPrefix) {
        try {
            long fp = vsi.getFilePointer();
            if (fp + 24L >= vsi.length()) {
                return;
            }
            LOGGER.debug("reading tag container data from {}", (Object)vsi.getFilePointer());
            short headerSize = vsi.readShort();
            short version = vsi.readShort();
            int volumeVersion = vsi.readInt();
            long dataFieldOffset = vsi.readLong();
            int flags = vsi.readInt();
            vsi.skipBytes(4);
            LOGGER.debug("  headerSize = {}", (Object)headerSize);
            LOGGER.debug("  version = {}", (Object)version);
            LOGGER.debug("  volumeVersion = {}", (Object)volumeVersion);
            LOGGER.debug("  dataFieldOffset = {}", (Object)dataFieldOffset);
            LOGGER.debug("  flags = {}", (Object)flags);
            int tagCount = flags & 0xFFFFFFF;
            if (fp + dataFieldOffset < 0L) {
                return;
            }
            vsi.seek(fp + dataFieldOffset);
            if (vsi.getFilePointer() >= vsi.length()) {
                return;
            }
            LOGGER.debug("parsing {} tags from {}", (Object)tagCount, (Object)vsi.getFilePointer());
            if ((long)tagCount > vsi.length()) {
                return;
            }
            for (int i = 0; i < tagCount && vsi.getFilePointer() + 16L < vsi.length(); ++i) {
                int fieldType = vsi.readInt();
                int tag = vsi.readInt();
                long nextField = (long)vsi.readInt() & 0xFFFFFFFFL;
                int dataSize = vsi.readInt();
                String storedValue = null;
                LOGGER.debug("  tag #{}: fieldType={}, tag={}, nextField={}, dataSize={}", i, fieldType, tag, nextField, dataSize);
                boolean extraTag = (fieldType & 0x8000000) >> 27 == 1;
                boolean extendedField = (fieldType & 0x10000000) >> 28 == 1;
                boolean inlineData = (fieldType & 0x40000000) >> 30 == 1;
                boolean array = !inlineData && !extendedField && (fieldType & 0x20000000) >> 29 == 1;
                boolean newVolume = (fieldType & Integer.MIN_VALUE) >> 31 == 1;
                int realType = fieldType & 0xFFFFFF;
                int secondTag = -1;
                if (extraTag) {
                    secondTag = vsi.readInt();
                }
                LOGGER.debug("  inlineData = {}", (Object)inlineData);
                LOGGER.debug("  extraTag = {}", (Object)extraTag);
                LOGGER.debug("  extendedField = {}", (Object)extendedField);
                LOGGER.debug("  realType = {}", (Object)realType);
                if (tag < 0) {
                    if (!inlineData && (long)dataSize + vsi.getFilePointer() < vsi.length()) {
                        vsi.skipBytes(dataSize);
                    }
                    return;
                }
                if (tag == 2018 && this.previousTag == 2002) {
                    ++this.metadataIndex;
                } else if (tag == 2109 || tag == 2062) {
                    this.metadataIndex = -1;
                }
                this.previousTag = tag;
                while (this.metadataIndex >= this.pyramids.size()) {
                    this.pyramids.add(new Pyramid());
                }
                if (extendedField && realType == 0) {
                    if (tag == 2007) {
                        this.dimensionTag = secondTag;
                        this.inDimensionProperties = true;
                    }
                    long endPointer = vsi.getFilePointer() + (long)dataSize;
                    while (vsi.getFilePointer() < endPointer && vsi.getFilePointer() < vsi.length()) {
                        long start = vsi.getFilePointer();
                        this.readTags(vsi, populateMetadata || this.inDimensionProperties, this.getVolumeName(tag));
                        long end = vsi.getFilePointer();
                        if (start < end) continue;
                        break;
                    }
                    if (tag == 2007) {
                        this.inDimensionProperties = false;
                        this.foundChannelTag = false;
                    }
                } else if (extendedField && (realType == 1 || realType == 2)) {
                    String tagName;
                    long start = vsi.getFilePointer();
                    String string = tagName = realType == 2 ? this.getVolumeName(tag) : tagPrefix;
                    if (tagName.isEmpty() && realType == 2) {
                        switch (tag) {
                            case 2012: {
                                tagName = "Z start position";
                                break;
                            }
                            case 2013: {
                                tagName = "Z increment";
                                break;
                            }
                            case 2014: {
                                tagName = "Z value";
                            }
                        }
                    }
                    this.readTags(vsi, tag != 2037, tagName);
                } else {
                    Pyramid pyramid;
                    String tagName = this.getTagName(tag);
                    String value = inlineData ? String.valueOf(dataSize) : " ";
                    Pyramid pyramid2 = pyramid = this.metadataIndex < 0 ? null : this.pyramids.get(this.metadataIndex);
                    if (!inlineData && dataSize > 0) {
                        switch (realType) {
                            case 1: 
                            case 2: {
                                value = String.valueOf(vsi.read());
                                break;
                            }
                            case 3: 
                            case 4: {
                                value = String.valueOf(vsi.readShort());
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 14: 
                            case 271: 
                            case 272: 
                            case 273: {
                                int intValue = vsi.readInt();
                                value = String.valueOf(intValue);
                                break;
                            }
                            case 7: 
                            case 8: 
                            case 17: {
                                long longValue = vsi.readLong();
                                value = String.valueOf(longValue);
                                break;
                            }
                            case 9: {
                                value = String.valueOf(vsi.readFloat());
                                break;
                            }
                            case 10: 
                            case 18: {
                                value = String.valueOf(vsi.readDouble());
                                break;
                            }
                            case 12: {
                                value = Boolean.valueOf(vsi.readBoolean()).toString();
                                break;
                            }
                            case 13: 
                            case 8192: {
                                value = vsi.readString(dataSize);
                                value = DataTools.stripString(value);
                                if (tag == 2419) {
                                    if (pyramid == null) break;
                                    pyramid.channelNames.add(value);
                                    break;
                                }
                                if (tag != 2030 || value.equals("0") || pyramid == null || pyramid.name != null) break;
                                pyramid.name = value;
                                break;
                            }
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 267: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 8195: 
                            case 8199: 
                            case 8200: 
                            case 8470: {
                                int nIntValues = dataSize / 4;
                                int[] intValues = new int[nIntValues];
                                StringBuilder sb = new StringBuilder();
                                if (nIntValues > 1) {
                                    sb.append("(");
                                }
                                for (int v = 0; v < nIntValues; ++v) {
                                    intValues[v] = vsi.readInt();
                                    sb.append(intValues[v]);
                                    if (v >= nIntValues - 1) continue;
                                    sb.append(", ");
                                }
                                if (nIntValues > 1) {
                                    sb.append(")");
                                }
                                value = sb.toString();
                                if (tag == 2053) {
                                    if (pyramid == null || pyramid.width != null) break;
                                    pyramid.width = intValues[2];
                                    pyramid.height = intValues[3];
                                    break;
                                }
                                if (tag != 2410 || pyramid == null) break;
                                pyramid.tileOriginX = intValues[0];
                                pyramid.tileOriginY = intValues[1];
                                break;
                            }
                            case 11: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 268: 
                            case 279: 
                            case 280: {
                                int nDoubleValues = dataSize / 8;
                                double[] doubleValues = new double[nDoubleValues];
                                StringBuilder sb = new StringBuilder();
                                if (nDoubleValues > 1) {
                                    sb.append("(");
                                }
                                for (int v = 0; v < nDoubleValues; ++v) {
                                    doubleValues[v] = vsi.readDouble();
                                    sb.append(doubleValues[v]);
                                    if (v >= nDoubleValues - 1) continue;
                                    sb.append(", ");
                                }
                                if (nDoubleValues > 1) {
                                    sb.append(')');
                                }
                                value = sb.toString();
                                if (tag == 2019) {
                                    if (pyramid == null || pyramid.physicalSizeX != null) break;
                                    pyramid.physicalSizeX = doubleValues[0];
                                    pyramid.physicalSizeY = doubleValues[1];
                                    break;
                                }
                                if (tag != 2018 || pyramid == null || pyramid.originX != null) break;
                                pyramid.originX = doubleValues[0];
                                pyramid.originY = doubleValues[1];
                                break;
                            }
                            case 269: {
                                int red = vsi.read();
                                int green = vsi.read();
                                int blue = vsi.read();
                                value = "red = " + red + ", green = " + green + ", blue = " + blue;
                                break;
                            }
                            case 270: {
                                int blue = vsi.read();
                                int green = vsi.read();
                                int red = vsi.read();
                                value = "red = " + red + ", green = " + green + ", blue = " + blue;
                            }
                        }
                    }
                    if (this.metadataIndex >= 0) {
                        try {
                            if (tag == 2074) {
                                value = this.getStackType(value);
                            } else if (tag == 120130) {
                                value = this.getDeviceSubtype(value);
                                pyramid.deviceTypes.add(value);
                            } else if (tag == 120129) {
                                pyramid.deviceIDs.add(value);
                            } else if (tag == 120116) {
                                pyramid.deviceNames.add(value);
                            } else if (tag == 120133) {
                                pyramid.deviceManufacturers.add(value);
                            } else if (tag == 100002 && tagPrefix.length() == 0) {
                                pyramid.exposureTimes.add(Long.parseLong(value));
                            } else if (tag == 100002) {
                                pyramid.defaultExposureTime = Long.parseLong(value);
                                pyramid.otherExposureTimes.add(pyramid.defaultExposureTime);
                            } else if (tag == 2015 && pyramid.acquisitionTime == null) {
                                pyramid.acquisitionTime = Long.parseLong(value);
                            } else if (tag == 120079) {
                                pyramid.refractiveIndex = DataTools.parseDouble(value);
                            } else if (tag == 120060) {
                                pyramid.magnification = DataTools.parseDouble(value);
                            } else if (tag == 120061) {
                                pyramid.numericalAperture = DataTools.parseDouble(value);
                            } else if (tag == 120062) {
                                pyramid.workingDistance = DataTools.parseDouble(value);
                            } else if (tag == 120063) {
                                pyramid.objectiveNames.add(value);
                            } else if (tag == 120064) {
                                pyramid.objectiveTypes.add(Integer.parseInt(value));
                            } else if (tag == 100049) {
                                pyramid.bitDepth = Integer.parseInt(value);
                            } else if (tag == 100015) {
                                pyramid.binningX = Integer.parseInt(value);
                            } else if (tag == 100016) {
                                pyramid.binningY = Integer.parseInt(value);
                            } else if (tag == 100003) {
                                pyramid.gain = DataTools.parseDouble(value);
                            } else if (tag == 100004) {
                                pyramid.offset = DataTools.parseDouble(value);
                            } else if (tag == 100007) {
                                pyramid.redGain = DataTools.parseDouble(value);
                            } else if (tag == 100008) {
                                pyramid.greenGain = DataTools.parseDouble(value);
                            } else if (tag == 100009) {
                                pyramid.blueGain = DataTools.parseDouble(value);
                            } else if (tag == 100010) {
                                pyramid.redOffset = DataTools.parseDouble(value);
                            } else if (tag == 100011) {
                                pyramid.greenOffset = DataTools.parseDouble(value);
                            } else if (tag == 100012) {
                                pyramid.blueOffset = DataTools.parseDouble(value);
                            } else if (tag == 0x10000002) {
                                if (tagPrefix.equals("Channel Wavelength ")) {
                                    pyramid.channelWavelengths.add(DataTools.parseDouble(value));
                                } else if (tagPrefix.startsWith("Objective Working Distance")) {
                                    pyramid.workingDistance = DataTools.parseDouble(value);
                                } else if (tagPrefix.equals("Z start position")) {
                                    pyramid.zStart = DataTools.parseDouble(value);
                                } else if (tagPrefix.equals("Z increment")) {
                                    pyramid.zIncrement = DataTools.parseDouble(value);
                                } else if (tagPrefix.equals("Z value")) {
                                    pyramid.zValues.add(DataTools.parseDouble(value));
                                } else if (tagPrefix.equals("Timestamp ")) {
                                    pyramid.tValues.add(DataTools.parseDouble(value));
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse tag " + tag, e);
                        }
                    }
                    if (tag == 14 || tag == 2015) {
                        value = DateTools.convertDate(Long.parseLong(value) * 1000L, 0);
                    }
                    if (tag == 20005) {
                        boolean bl = this.expectETS = Integer.parseInt(value) == 1;
                    }
                    if (tagName != null && populateMetadata) {
                        if (this.metadataIndex >= 0) {
                            this.addMetaList(tagPrefix + tagName, value, this.pyramids.get((int)this.metadataIndex).originalMetadata);
                        } else if (tag != 0x10000002 || tagPrefix.length() > 0) {
                            this.addGlobalMetaList(tagPrefix + tagName, value);
                        }
                        if ("Channel Wavelength Value".equals(tagPrefix + tagName)) {
                            ++this.channelCount;
                        } else if ("Z valueValue".equals(tagPrefix + tagName)) {
                            ++this.zCount;
                        }
                    }
                    storedValue = value;
                }
                if (this.inDimensionProperties) {
                    Pyramid p = this.pyramids.get(this.metadataIndex);
                    if (tag == 2012 && !p.dimensionOrdering.containsValue(this.dimensionTag)) {
                        p.dimensionOrdering.put("Z", this.dimensionTag);
                    } else if (!(tag != 2100 && tag != 2027 || p.dimensionOrdering.containsValue(this.dimensionTag))) {
                        p.dimensionOrdering.put("T", this.dimensionTag);
                    } else if (tag == 2039 && !p.dimensionOrdering.containsValue(this.dimensionTag)) {
                        p.dimensionOrdering.put("L", this.dimensionTag);
                    } else if (tag == 2008 && this.foundChannelTag && !p.dimensionOrdering.containsValue(this.dimensionTag)) {
                        p.dimensionOrdering.put("C", this.dimensionTag);
                    } else if (tag == 2008) {
                        this.foundChannelTag = true;
                    } else if (tag == 2023 && storedValue != null) {
                        int dimension = -1;
                        try {
                            dimension = Integer.parseInt(storedValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        switch (dimension) {
                            case 1: {
                                p.dimensionOrdering.put("Z", this.dimensionTag);
                                break;
                            }
                            case 2: {
                                p.dimensionOrdering.put("T", this.dimensionTag);
                                break;
                            }
                            case 3: {
                                p.dimensionOrdering.put("L", this.dimensionTag);
                                break;
                            }
                            case 4: {
                                p.dimensionOrdering.put("C", this.dimensionTag);
                                break;
                            }
                            case 9: {
                                p.dimensionOrdering.put("P", this.dimensionTag);
                            }
                            default: {
                                throw new FormatException("Invalid dimension: " + dimension);
                            }
                        }
                    }
                }
                if (nextField == 0L || tag == -494804095) {
                    if (fp + (long)dataSize + 32L < vsi.length() && fp + (long)dataSize >= 0L) {
                        vsi.seek(fp + (long)dataSize + 32L);
                    }
                    return;
                }
                if (fp + nextField < vsi.length() && fp + nextField >= 0L) {
                    vsi.seek(fp + nextField);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to read all tags", e);
        }
    }

    private String getVolumeName(int tag) {
        switch (tag) {
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2011: 
            case 2012: {
                return "";
            }
            case 2043: {
                return "Microscope ";
            }
            case 2417: {
                return "Channel Wavelength ";
            }
            case 120062: {
                return "Objective Working Distance ";
            }
            case 2017: {
                return "Timestamp ";
            }
        }
        LOGGER.debug("Unhandled volume {}", (Object)tag);
        return "";
    }

    private String getTagName(int tag) {
        switch (tag) {
            case 2063: {
                return "Image plane rectangle unit (Y dimension)";
            }
            case 2064: {
                return "Y dimension unit";
            }
            case 2073: {
                return "Channel under/overflow";
            }
            case 2055: {
                return "Specimen";
            }
            case 2057: {
                return "Tissue";
            }
            case 2058: {
                return "Preparation";
            }
            case 2059: {
                return "Staining";
            }
            case 2060: {
                return "Slide Info";
            }
            case 2061: {
                return "Slide Name";
            }
            case 100002: {
                return "Exposure time (microseconds)";
            }
            case 100003: {
                return "Camera gain";
            }
            case 100004: {
                return "Camera offset";
            }
            case 100005: {
                return "Gamma";
            }
            case 100006: {
                return "Sharpness";
            }
            case 100007: {
                return "Red channel gain";
            }
            case 100008: {
                return "Green channel gain";
            }
            case 100009: {
                return "Blue channel gain";
            }
            case 100010: {
                return "Red channel offset";
            }
            case 100011: {
                return "Green channel offset";
            }
            case 100012: {
                return "Blue channel offset";
            }
            case 100013: {
                return "Shading sub";
            }
            case 100014: {
                return "Shading mul";
            }
            case 100015: {
                return "Binning (X)";
            }
            case 100016: {
                return "Binning (Y)";
            }
            case 100017: {
                return "Clipping";
            }
            case 100023: {
                return "Mirror (horizontal)";
            }
            case 100024: {
                return "Mirror (vertical)";
            }
            case 100025: {
                return "Clipping state";
            }
            case 100030: {
                return "ICC enabled";
            }
            case 100031: {
                return "Brightness";
            }
            case 100032: {
                return "Contrast";
            }
            case 100033: {
                return "Contrast reference";
            }
            case 100034: {
                return "Camera accumulation";
            }
            case 100035: {
                return "Camera averaging";
            }
            case 100038: {
                return "ISO sensitivity";
            }
            case 100039: {
                return "Camera accumulation mode";
            }
            case 100043: {
                return "Autoexposure enabled";
            }
            case 100044: {
                return "Autoexposure metering mode";
            }
            case 2012: {
                return "Z stack start";
            }
            case 2013: {
                return "Z stack increment";
            }
            case 2014: {
                return "Z position";
            }
            case 2100: {
                return "Timelapse start";
            }
            case 2016: {
                return "Timelapse increment";
            }
            case 2017: {
                return "Timestamp";
            }
            case 2039: {
                return "Lambda start";
            }
            case 2040: {
                return "Lambda increment";
            }
            case 2041: {
                return "Lambda value";
            }
            case 2021: {
                return "Dimension name";
            }
            case 2023: {
                return "Dimension description";
            }
            case 2025: {
                return "Dimension start ID";
            }
            case 2026: {
                return "Dimension increment ID";
            }
            case 2027: {
                return "Dimension value ID";
            }
            case 2053: {
                return "Image size";
            }
            case 20004: {
                return "Tile system";
            }
            case 20005: {
                return "External file present";
            }
            case 20025: {
                return "External file volume";
            }
            case 2410: {
                return "Origin of tile coordinate system";
            }
            case 2003: {
                return "Display limits";
            }
            case 2004: {
                return "Stack display LUT";
            }
            case 2005: {
                return "Gamma correction";
            }
            case 2006: {
                return "Frame origin (plane coordinates)";
            }
            case 2007: {
                return "Frame scale (plane coordinates)";
            }
            case 2008: {
                return "Display color";
            }
            case 2015: {
                return "Creation time (UTC)";
            }
            case 2018: {
                return "Origin";
            }
            case 2019: {
                return "Calibration";
            }
            case 2020: {
                return "Calibration units";
            }
            case 2030: {
                return "Layer";
            }
            case 2031: {
                return "Channel dimension";
            }
            case 2074: {
                return "Image Type";
            }
            case 2076: {
                return "Live overflow";
            }
            case 20035: {
                return "IS transmission mask";
            }
            case 10047: {
                return "Contrast and brightness";
            }
            case 10048: {
                return "Acquisition properties";
            }
            case 10065: {
                return "Gradient LUT";
            }
            case 10000: {
                return "Display processor type";
            }
            case 10001: {
                return "Render operation ID";
            }
            case 10005: {
                return "Displayed stack ID";
            }
            case 10006: {
                return "Transparency ID";
            }
            case 10007: {
                return "Display third ID";
            }
            case 10008: {
                return "Display visible";
            }
            case 10009: {
                return "Transparency value";
            }
            case 10013: {
                return "Display LUT";
            }
            case 10014: {
                return "Display stack index";
            }
            case 10018: {
                return "Channel transparency value";
            }
            case 10025: {
                return "Channel visible";
            }
            case 10028: {
                return "List of selected channels";
            }
            case 10032: {
                return "Display gamma correction";
            }
            case 10033: {
                return "Channel gamma correction";
            }
            case 10045: {
                return "Display contrast and brightness";
            }
            case 10046: {
                return "Channel contrast and brightness";
            }
            case 10049: {
                return "Active stack dimension";
            }
            case 10050: {
                return "Selected frames";
            }
            case 10054: {
                return "Displayed LUT ID";
            }
            case 10056: {
                return "Hidden layer";
            }
            case 10057: {
                return "Layer fixed in XY";
            }
            case 10060: {
                return "Active layer vector";
            }
            case 10061: {
                return "Active layer index vector";
            }
            case 10062: {
                return "Chained layers";
            }
            case 10063: {
                return "Layer selection";
            }
            case 10064: {
                return "Layer selection index";
            }
            case 10066: {
                return "Canvas background color 1";
            }
            case 10067: {
                return "Canvas background color 2";
            }
            case 10069: {
                return "Original frame rate (ms)";
            }
            case 10070: {
                return "Use original frame rate";
            }
            case 10071: {
                return "Active channel";
            }
            case 2011: {
                return "Plane unit";
            }
            case 20006: {
                return "Origin";
            }
            case 20007: {
                return "Physical pixel size";
            }
            case 0x40000000: {
                return "Original magnification";
            }
            case 11: {
                return "Document Name";
            }
            case 13: {
                return "Document Note";
            }
            case 14: {
                return "Document Creation Time";
            }
            case 15: {
                return "Document Author";
            }
            case 16: {
                return "Document Company";
            }
            case 17: {
                return "Document creator name";
            }
            case 18: {
                return "Document creator major version";
            }
            case 19: {
                return "Document creator minor version";
            }
            case 20: {
                return "Document creator sub version";
            }
            case 21: {
                return "Product Build Number";
            }
            case 22: {
                return "Document creator package";
            }
            case 23: {
                return "Document product";
            }
            case 24: {
                return "Document product name";
            }
            case 25: {
                return "Document product version";
            }
            case 27: {
                return "Document type hint";
            }
            case 28: {
                return "Document thumbnail";
            }
            case 2022: {
                return "Coarse pyramid level";
            }
            case 2028: {
                return "Extra samples";
            }
            case 2034: {
                return "Default background color";
            }
            case 2035: {
                return "Version number";
            }
            case 2419: {
                return "Channel name";
            }
            case 120060: {
                return "Magnification";
            }
            case 120061: {
                return "Numerical Aperture";
            }
            case 120062: {
                return "Objective Working Distance";
            }
            case 120063: {
                return "Objective Name";
            }
            case 120064: {
                return "Objective Type";
            }
            case 120065: {
                return "Objective Description";
            }
            case 120066: {
                return "Objective Subtype";
            }
            case 120069: {
                return "Brightness Correction";
            }
            case 120070: {
                return "Objective Lens";
            }
            case 120075: {
                return "Objective X Shift";
            }
            case 120076: {
                return "Objective Y Shift";
            }
            case 120077: {
                return "Objective Z Shift";
            }
            case 120078: {
                return "Objective Gear Setting";
            }
            case 120635: {
                return "Slide Bar Code";
            }
            case 120638: {
                return "Tray No.";
            }
            case 120637: {
                return "Slide No.";
            }
            case 34: {
                return "Product Name";
            }
            case 35: {
                return "Product Version";
            }
            case 120116: {
                return "Device Name";
            }
            case 100049: {
                return "Camera Actual Bit Depth";
            }
            case 120001: {
                return "Device Position";
            }
            case 120050: {
                return "TV Adapter Magnification";
            }
            case 120079: {
                return "Objective Refractive Index";
            }
            case 120117: {
                return "Device Type";
            }
            case 120129: {
                return "Device Unit ID";
            }
            case 120130: {
                return "Device Subtype";
            }
            case 120132: {
                return "Device Model";
            }
            case 120133: {
                return "Device Manufacturer";
            }
            case 121102: {
                return "Stage Insert Position";
            }
            case 121131: {
                return "Laser/Lamp Intensity";
            }
            case 0x10000000: {
                return "Units";
            }
            case 0x10000002: {
                return "Value";
            }
            case 175208: {
                return "Snapshot Count";
            }
            case 175209: {
                return "Scanning Time (seconds)";
            }
            case 120210: {
                return "Device Configuration Position";
            }
            case 120211: {
                return "Device Configuration Index";
            }
            case 124000: {
                return "Aperture Max Mode";
            }
            case 100048: {
                return "Camera Maximum Frame Size";
            }
            case 100055: {
                return "Camera HDRI Enabled";
            }
            case 100056: {
                return "Camera Images per HDRI image";
            }
            case 100057: {
                return "Camera HDRI Exposure Ratio";
            }
            case 100058: {
                return "Camera HDRI Mapping Mode";
            }
            case 100059: {
                return "Camera Custom Grayscale Value";
            }
            case 100060: {
                return "Camera Saturation";
            }
            case 100061: {
                return "Camera White Balance Preset ID";
            }
            case 100062: {
                return "Camera White Balance Preset Name";
            }
            case 100063: {
                return "Camera White Balance Mode";
            }
            case 100064: {
                return "Camera CCD Sensitivity";
            }
            case 100065: {
                return "Camera Enhanced Dynamic Range";
            }
            case 100066: {
                return "Camera Pixel Clock (MHz)";
            }
            case 100067: {
                return "Camera Colorspace";
            }
            case 100068: {
                return "Camera Cooling Enabled";
            }
            case 100069: {
                return "Camera Cooling Fan Speed";
            }
            case 100070: {
                return "Camera Cooling Temperature Target";
            }
            case 100071: {
                return "Camera Gain Unit";
            }
            case 100072: {
                return "Camera EM Gain";
            }
            case 100073: {
                return "Camera Photon Imaging Mode";
            }
            case 100074: {
                return "Camera Frame Transfer Enabled";
            }
            case 100075: {
                return "Camera iXon Shift Speed";
            }
            case 100076: {
                return "Camera Vertical Clock Amplitude";
            }
            case 100077: {
                return "Camera Spurious Noise Removal Enabled";
            }
            case 100078: {
                return "Camera Signal Output";
            }
            case 100079: {
                return "Camera Baseline Offset Clamp";
            }
            case 100080: {
                return "Camera DP80 Frame Centering";
            }
            case 100081: {
                return "Camera Hot Pixel Correction Enabled";
            }
            case 100082: {
                return "Camera Noise Reduction";
            }
            case 100083: {
                return "Camera WiDER";
            }
            case 100084: {
                return "Camera Photobleaching Enabled";
            }
            case 100085: {
                return "Camera Preamp Gain";
            }
            case 100086: {
                return "Camera WiDER Enabled";
            }
        }
        LOGGER.debug("Unhandled tag {}", (Object)tag);
        return null;
    }

    private String getDeviceSubtype(String type) {
        int deviceType = Integer.parseInt(type);
        switch (deviceType) {
            case 0: {
                return "Camera";
            }
            case 10000: {
                return "Stage";
            }
            case 20000: {
                return "Objective revolver";
            }
            case 20001: {
                return "TV Adapter";
            }
            case 20002: {
                return "Filter Wheel";
            }
            case 20003: {
                return "Lamp";
            }
            case 20004: {
                return "Aperture Stop";
            }
            case 20005: {
                return "Shutter";
            }
            case 20006: {
                return "Objective";
            }
            case 20007: {
                return "Objective Changer";
            }
            case 20008: {
                return "TopLens";
            }
            case 20009: {
                return "Prism";
            }
            case 20010: {
                return "Zoom";
            }
            case 20011: {
                return "DSU";
            }
            case 20012: {
                return "ZDC";
            }
            case 20050: {
                return "Stage Insert";
            }
            case 30000: {
                return "Slide Loader";
            }
            case 40000: {
                return "Manual Control";
            }
            case 40500: {
                return "Microscope Frame";
            }
        }
        return type;
    }

    private String getStackType(String type) {
        int stackType = Integer.parseInt(type);
        switch (stackType) {
            case 0: {
                return "Default image";
            }
            case 1: {
                return "Overview image";
            }
            case 2: {
                return "Sample mask";
            }
            case 4: {
                return "Focus image";
            }
            case 8: {
                return "EFI sharpness map";
            }
            case 16: {
                return "EFI height map";
            }
            case 32: {
                return "EFI texture map";
            }
            case 64: {
                return "EFI stack";
            }
            case 256: {
                return "Macro image";
            }
        }
        return type;
    }

    private int getIFDIndex() {
        if (this.usedFiles.length == 1) {
            return this.getCoreIndex();
        }
        return 1 - (this.core.size() - this.getCoreIndex());
    }

    class Pyramid {
        public String name;
        public Double magnification;
        public Double numericalAperture;
        public String objectiveName;
        public Double refractiveIndex;
        public Double workingDistance;
        public Integer width;
        public Integer height;
        public Integer tileOriginX;
        public Integer tileOriginY;
        public Double originX;
        public Double originY;
        public Double physicalSizeX;
        public Double physicalSizeY;
        public Long acquisitionTime;
        public Integer bitDepth;
        public Integer binningX;
        public Integer binningY;
        public Double gain;
        public Double offset;
        public Double redGain;
        public Double greenGain;
        public Double blueGain;
        public Double redOffset;
        public Double greenOffset;
        public Double blueOffset;
        public ArrayList<String> channelNames = new ArrayList();
        public ArrayList<Double> channelWavelengths = new ArrayList();
        public ArrayList<Long> exposureTimes = new ArrayList();
        public transient ArrayList<Long> otherExposureTimes = new ArrayList();
        public Long defaultExposureTime;
        public ArrayList<String> objectiveNames = new ArrayList();
        public ArrayList<Integer> objectiveTypes = new ArrayList();
        public ArrayList<String> deviceNames = new ArrayList();
        public ArrayList<String> deviceTypes = new ArrayList();
        public ArrayList<String> deviceIDs = new ArrayList();
        public ArrayList<String> deviceManufacturers = new ArrayList();
        public Hashtable<String, Object> originalMetadata = new Hashtable();
        public HashMap<String, Integer> dimensionOrdering = new HashMap();
        public transient Double zStart;
        public transient Double zIncrement;
        public transient ArrayList<Double> zValues = new ArrayList();
        public transient ArrayList<Double> tValues = new ArrayList();
        public boolean HasAssociatedEtsFile = false;

        Pyramid() {
        }
    }

    class TileCoordinate {
        public int[] coordinate;

        public TileCoordinate(int nDimensions) {
            this.coordinate = new int[nDimensions];
        }

        public boolean equals(Object o) {
            if (!(o instanceof TileCoordinate)) {
                return false;
            }
            TileCoordinate t2 = (TileCoordinate)o;
            if (this.coordinate.length != t2.coordinate.length) {
                return false;
            }
            for (int i = 0; i < this.coordinate.length; ++i) {
                if (this.coordinate[i] == t2.coordinate[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("{");
            for (int p : this.coordinate) {
                b.append(p);
                b.append(", ");
            }
            b.append("}");
            return b.toString();
        }
    }
}

