/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import loci.common.Location;

public class ResourceNamer {
    public static final String PLATE = "Plate";
    public static final String RUN = "Run";
    public static final String WELL = "Well";
    public static final String FIELD = "Field";
    public static final String FAKE_EXT = "fake";
    public static final String DOT = ".";
    private static final int ALPHABET_LENGTH = 26;
    private int resourceCount = 0;
    private char letter;
    private char tmpLetter;

    public ResourceNamer(int resourceCount) {
        if (resourceCount < 0) {
            throw new IllegalArgumentException();
        }
        this.resourceCount = resourceCount;
        this.restartAlphabet();
    }

    public Location getLocationFromResourceName(Location resourceParentPath, String resourceName, int nameIndex, String resourceExtension) {
        StringBuilder sb = new StringBuilder();
        sb.append(resourceName + String.format("%03d", nameIndex));
        if (resourceExtension != null) {
            if (!resourceExtension.startsWith(File.separator)) {
                sb.append(DOT);
            }
            sb.append(resourceExtension);
        }
        return new Location(resourceParentPath, sb.toString());
    }

    public void restartAlphabet() {
        this.tmpLetter = (char)65;
        this.letter = (char)65;
    }

    public void nextLetter() {
        this.tmpLetter = (char)(this.tmpLetter + '\u0001');
        if (this.tmpLetter > 'Z') {
            this.tmpLetter = this.letter;
            this.letter = (char)(this.letter + '\u0001');
        }
    }

    public String getLetter() {
        if (this.resourceCount > 26) {
            return Character.toString(this.letter) + Character.toString(this.tmpLetter);
        }
        return Character.toString(this.tmpLetter);
    }

    public static int alphabeticIndexCount(String index) {
        int count = 0;
        char[] letters = index.toCharArray();
        if (letters.length > 6) {
            throw new IllegalArgumentException("Cannot count more than 6 characters");
        }
        for (int i = 0; i < letters.length; ++i) {
            int letterIndex = (int)Math.pow(26.0, i);
            int letterValue = letterIndex * (letters[i] - 64);
            count += letterValue;
        }
        return count;
    }
}

